/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.phases.EnumSwitchPlugin;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.phases.util.Providers;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class EnumSwitchFeature
implements InternalFeature {
    BigBang bb;
    final ConcurrentMap<AnalysisMethod, Boolean> methodsSafeForExecution = new ConcurrentHashMap<AnalysisMethod, Boolean>();

    EnumSwitchFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.bb = access.getBigBang();
        access.getHostVM().addMethodAfterParsingListener(this::onMethodParsed);
    }

    private void onMethodParsed(AnalysisMethod method, StructuredGraph graph) {
        boolean methodSafeForExecution = graph.getNodes().filter(node -> node instanceof EnsureClassInitializedNode).isEmpty();
        Boolean existingValue = this.methodsSafeForExecution.put(method, methodSafeForExecution);
        assert (existingValue == null || method.isDeoptTarget()) : "Method parsed twice: " + method.format("%H.%n(%p)");
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.bb = null;
    }

    @Override
    public void registerGraphBuilderPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        plugins.appendNodePlugin((NodePlugin)new EnumSwitchPlugin(reason));
    }
}

