/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.heap.TypedConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.meta.MethodPointer;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.c.function.RelocatedPointer;

public class RelocatableConstant
implements JavaConstant,
TypedConstant {
    private final RelocatedPointer pointer;
    private final AnalysisType type;

    public RelocatableConstant(RelocatedPointer pointer, AnalysisType type) {
        this.pointer = pointer;
        this.type = type;
    }

    public RelocatedPointer getPointer() {
        return this.pointer;
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isDefaultForKind() {
        throw new IllegalArgumentException();
    }

    public Object asBoxedPrimitive() {
        throw new IllegalArgumentException();
    }

    public int asInt() {
        throw new IllegalArgumentException();
    }

    public boolean asBoolean() {
        throw new IllegalArgumentException();
    }

    public long asLong() {
        throw new IllegalArgumentException();
    }

    public float asFloat() {
        throw new IllegalArgumentException();
    }

    public double asDouble() {
        throw new IllegalArgumentException();
    }

    public AnalysisType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.pointer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelocatableConstant) {
            RelocatableConstant rc = (RelocatableConstant)obj;
            return this.pointer == rc.pointer;
        }
        return false;
    }

    public String toValueString() {
        RelocatedPointer relocatedPointer = this.pointer;
        if (relocatedPointer instanceof MethodPointer) {
            MethodPointer mp = (MethodPointer)relocatedPointer;
            return "relocatable method pointer: " + mp.getMethod().format("%H.%n(%p)") + ", isAbsolute: " + mp.isAbsolute();
        }
        return "relocatable constant";
    }
}

