/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.macho.MachOSymtab;
import com.oracle.svm.core.BuildDirectoryProvider;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.libc.BionicLibC;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.c.libc.HostedLibCBase;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.jdk.JNIRegistrationSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

public abstract class CCLinkerInvocation
implements LinkerInvocation {
    protected final List<String> additionalPreOptions = new ArrayList<String>();
    protected final List<String> nativeLinkerOptions = new ArrayList<String>();
    protected final List<Path> inputFilenames = new ArrayList<Path>();
    protected final List<String> rpaths = new ArrayList<String>();
    protected final List<String> libpaths = new ArrayList<String>();
    protected final List<String> libs = new ArrayList<String>();
    protected final AbstractImage.NativeImageKind imageKind;
    protected final NativeLibraries nativeLibs;
    private final List<ObjectFile.Symbol> imageSymbols;
    protected Path tempDirectory;
    protected Path outputFile;

    protected CCLinkerInvocation(AbstractImage.NativeImageKind imageKind, NativeLibraries nativeLibs, List<ObjectFile.Symbol> imageSymbols) {
        this.imageKind = imageKind;
        this.nativeLibs = nativeLibs;
        this.imageSymbols = imageSymbols;
    }

    abstract String getSymbolName(ObjectFile.Symbol var1);

    @Override
    public List<String> getImageSymbols(boolean onlyGlobal) {
        Stream<Object> stream = this.imageSymbols.stream();
        if (onlyGlobal) {
            Set<String> globalHiddenSymbols = CGlobalDataFeature.singleton().getGlobalHiddenSymbols();
            stream = stream.filter(symbol -> symbol.isGlobal() && !globalHiddenSymbols.contains(symbol.getName()));
        }
        if (!SubstrateOptions.useLLVMBackend()) {
            stream = stream.filter(ObjectFile.Symbol::isDefined);
        }
        return stream.map(this::getSymbolName).collect(Collectors.toList());
    }

    @Override
    public List<Path> getInputFiles() {
        return Collections.unmodifiableList(this.inputFilenames);
    }

    @Override
    public void addInputFile(Path filename) {
        this.inputFilenames.add(filename);
    }

    @Override
    public void addInputFile(int index, Path filename) {
        this.inputFilenames.add(index, filename);
    }

    @Override
    public List<String> getLibPaths() {
        return Collections.unmodifiableList(this.libpaths);
    }

    @Override
    public void addLibPath(String libPath) {
        this.addLibPath(this.libpaths.size(), libPath);
    }

    @Override
    public void addLibPath(int index, String libPath) {
        if (!libPath.isEmpty()) {
            this.libpaths.add(index, libPath);
        }
    }

    @Override
    public List<String> getRPaths() {
        return Collections.unmodifiableList(this.rpaths);
    }

    @Override
    public void addRPath(String rPath) {
        this.addRPath(this.rpaths.size(), rPath);
    }

    @Override
    public void addRPath(int index, String rPath) {
        if (!rPath.isEmpty()) {
            this.rpaths.add(rPath);
        }
    }

    @Override
    public Path getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setOutputFile(Path out) {
        this.outputFile = out;
    }

    public void setTempDirectory(Path tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    @Override
    public Path getTempDirectory() {
        return this.tempDirectory;
    }

    @Override
    public List<String> getLinkedLibraries() {
        return Collections.unmodifiableList(this.libs);
    }

    @Override
    public void addLinkedLibrary(String libname) {
        this.libs.add(libname);
    }

    @Override
    public void addLinkedLibrary(int index, String libname) {
        this.libs.add(index, libname);
    }

    protected List<String> getCompilerCommand(List<String> options) {
        Path[] inputPaths = (Path[])this.inputFilenames.stream().map(path -> path.startsWith(this.tempDirectory) ? this.tempDirectory.relativize((Path)path) : path).toArray(Path[]::new);
        return ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).createCompilerCommand(options, this.outputFile, inputPaths);
    }

    protected abstract void setOutputKind(List<String> var1);

    @Override
    public List<String> getCommand() {
        List<String> compilerCmd = this.getCompilerCommand(this.additionalPreOptions);
        ArrayList<String> cmd = new ArrayList<String>(compilerCmd);
        this.setOutputKind(cmd);
        cmd.add("-v");
        for (String libpath : this.libpaths) {
            cmd.add("-L" + libpath);
        }
        for (String rpath : this.rpaths) {
            cmd.add("-Wl,-rpath");
            cmd.add("-Wl," + rpath);
        }
        cmd.addAll(this.getLibrariesCommand());
        cmd.addAll(this.getNativeLinkerOptions());
        if (Platform.includedIn(Platform.RISCV64.class)) {
            cmd.add("-latomic");
        }
        return cmd;
    }

    protected List<String> getLibrariesCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        for (String lib : this.libs) {
            if (lib.startsWith("-")) {
                cmd.add("-Wl," + lib.replace(" ", ","));
                continue;
            }
            cmd.add("-l" + lib);
        }
        return cmd;
    }

    @Override
    public void addNativeLinkerOption(String option) {
        this.nativeLinkerOptions.add(option);
    }

    protected List<String> getNativeLinkerOptions() {
        return Stream.of(this.nativeLinkerOptions, Options.NativeLinkerOption.getValue().values()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static LinkerInvocation getLinkerInvocation(AbstractImage.NativeImageKind imageKind, NativeLibraries nativeLibs, Path[] inputFiles, Path outputDirectory, Path tempDirectory, String imageName, List<ObjectFile.Symbol> symbols) {
        CCLinkerInvocation inv = switch (ObjectFile.getNativeFormat()) {
            case ObjectFile.Format.MACH_O -> new DarwinCCLinkerInvocation(imageKind, nativeLibs, symbols);
            case ObjectFile.Format.PECOFF -> new WindowsCCLinkerInvocation(imageKind, nativeLibs, symbols, imageName);
            default -> new BinutilsCCLinkerInvocation(imageKind, nativeLibs, symbols);
        };
        Path outputFile = outputDirectory.resolve(imageName + imageKind.getFilenameSuffix());
        UserError.guarantee(!Files.isDirectory(outputFile, new LinkOption[0]), "Cannot write image to %s. Path exists as directory (use '-o /path/to/image').", outputFile);
        inv.setOutputFile(outputFile);
        inv.setTempDirectory(tempDirectory);
        inv.addLibPath(tempDirectory.toString());
        for (String libraryPath : nativeLibs.getLibraryPaths()) {
            inv.addLibPath(libraryPath);
        }
        for (String rPath : SubstrateOptions.LinkerRPath.getValue().values()) {
            inv.addRPath(rPath);
        }
        Collection libraries = nativeLibs.getLibraries();
        if (Platform.includedIn(Platform.LINUX.class) && LibCBase.targetLibCIs(BionicLibC.class)) {
            libraries = libraries.stream().filter(library -> !Arrays.asList("pthread", "rt").contains(library)).collect(Collectors.toList());
        }
        libraries.forEach(inv::addLinkedLibrary);
        for (Path filename : inputFiles) {
            inv.addInputFile(filename);
        }
        for (Path staticLibraryPath : nativeLibs.getStaticLibraries()) {
            inv.addInputFile(staticLibraryPath);
        }
        return inv;
    }

    public static class Options {
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> NativeLinkerOption = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
    }

    private static class DarwinCCLinkerInvocation
    extends CCLinkerInvocation {
        DarwinCCLinkerInvocation(AbstractImage.NativeImageKind imageKind, NativeLibraries nativeLibs, List<ObjectFile.Symbol> symbols) {
            super(imageKind, nativeLibs, symbols);
            this.setLinkerFlags(nativeLibs, false);
        }

        private void setLinkerFlags(NativeLibraries nativeLibs, boolean useFallback) {
            this.additionalPreOptions.add("-Wl,-U,___darwin_check_fd_set_overflow");
            boolean useLld = false;
            if (useFallback) {
                Path lld = BuildDirectoryProvider.singleton().getHome().resolve("lib").resolve("svm").resolve("bin").resolve("ld64.lld").toAbsolutePath();
                if (Files.exists(lld, new LinkOption[0])) {
                    useLld = true;
                    this.additionalPreOptions.add("-fuse-ld=" + String.valueOf(lld));
                } else {
                    throw new RuntimeException("This should not happen. ld64.lld should be shipped as part of Native Image, please report.");
                }
            }
            if (!SubstrateOptions.useLLVMBackend() && !useLld) {
                this.additionalPreOptions.add("-Wl,-no_compact_unwind");
            }
            if (SubstrateOptions.RemoveUnusedSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,-dead_strip");
            }
            try {
                Path exportedSymbolsPath = nativeLibs.tempDirectory.resolve("exported_symbols.list");
                Files.write(exportedSymbolsPath, this.getImageSymbols(true), new OpenOption[0]);
                this.additionalPreOptions.add("-Wl,-exported_symbols_list");
                this.additionalPreOptions.add("-Wl," + String.valueOf(exportedSymbolsPath.toAbsolutePath()));
            }
            catch (IOException e) {
                VMError.shouldNotReachHere(e);
            }
            if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,-x");
            }
            this.additionalPreOptions.add("-arch");
            if (Platform.includedIn(Platform.AMD64.class)) {
                this.additionalPreOptions.add("x86_64");
            } else if (Platform.includedIn(Platform.AARCH64.class)) {
                this.additionalPreOptions.add("arm64");
            }
        }

        @Override
        public List<String> getFallbackCommand() {
            this.additionalPreOptions.clear();
            this.setLinkerFlags(this.nativeLibs, true);
            return this.getCommand();
        }

        @Override
        public boolean shouldRunFallback(String message) {
            if (Platform.includedIn(Platform.AARCH64.class)) {
                if (message.contains("branch out of range") || message.contains("Unable to insert branch island")) {
                    return true;
                }
                return message.contains("out of range");
            }
            return false;
        }

        @Override
        String getSymbolName(ObjectFile.Symbol symbol) {
            return ((MachOSymtab.Entry)symbol).getNameInObject();
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (this.imageKind) {
                case STATIC_EXECUTABLE: {
                    throw VMError.shouldNotReachHereUnexpectedInput((Object)this.imageKind);
                }
                case SHARED_LIBRARY: {
                    cmd.add("-shared");
                    if (!Platform.includedIn(Platform.DARWIN.class)) break;
                    cmd.add("-undefined");
                    cmd.add("dynamic_lookup");
                }
            }
        }
    }

    private static class WindowsCCLinkerInvocation
    extends CCLinkerInvocation {
        private final String imageName;

        WindowsCCLinkerInvocation(AbstractImage.NativeImageKind imageKind, NativeLibraries nativeLibs, List<ObjectFile.Symbol> symbols, String imageName) {
            super(imageKind, nativeLibs, symbols);
            this.imageName = imageName;
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (this.imageKind) {
                case EXECUTABLE: 
                case STATIC_EXECUTABLE: {
                    cmd.add("/MD");
                    break;
                }
                case IMAGE_LAYER: 
                case SHARED_LIBRARY: {
                    cmd.add("/MD");
                    cmd.add("/LD");
                    break;
                }
                default: {
                    VMError.shouldNotReachHereUnexpectedInput((Object)this.imageKind);
                }
            }
        }

        @Override
        String getSymbolName(ObjectFile.Symbol symbol) {
            return symbol.getName();
        }

        @Override
        public List<String> getCommand() {
            List<String> compilerCmd = this.getCompilerCommand(this.additionalPreOptions);
            ArrayList<String> cmd = new ArrayList<String>(compilerCmd);
            this.setOutputKind(cmd);
            for (Path staticLibrary : this.nativeLibs.getStaticLibraries()) {
                cmd.add(staticLibrary.toString());
            }
            cmd.add("/link");
            cmd.add("/INCREMENTAL:NO");
            cmd.add("/NODEFAULTLIB:LIBCMT");
            cmd.add("/FILEALIGN:4096");
            cmd.add("/IMPLIB:" + String.valueOf(this.getTempDirectory().resolve(this.imageName + ".lib")));
            if (SubstrateOptions.useDebugInfoGeneration()) {
                cmd.add("/DEBUG");
                if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                    String pdbFile = this.imageName + ".pdb";
                    cmd.add("/PDB:" + String.valueOf(this.getTempDirectory().resolve(pdbFile)));
                    cmd.add("/PDBSTRIPPED:" + String.valueOf(this.getOutputFile().resolveSibling(pdbFile)));
                }
            }
            if (!SubstrateOptions.RemoveUnusedSymbols.getValue().booleanValue()) {
                cmd.add("/OPT:NOREF,NOICF");
            }
            for (String libraryPath : this.nativeLibs.getLibraryPaths()) {
                cmd.add("/LIBPATH:" + libraryPath);
            }
            for (String library : this.nativeLibs.getLibraries()) {
                cmd.add(library + ".lib");
            }
            cmd.add("advapi32.lib");
            cmd.add("ws2_32.lib");
            cmd.add("secur32.lib");
            cmd.add("iphlpapi.lib");
            cmd.add("userenv.lib");
            cmd.add("mswsock.lib");
            if (SubstrateOptions.EnableWildcardExpansion.getValue().booleanValue() && this.imageKind == AbstractImage.NativeImageKind.EXECUTABLE) {
                cmd.add("setargv.obj");
            }
            cmd.addAll(this.getNativeLinkerOptions());
            return cmd;
        }
    }

    private static class BinutilsCCLinkerInvocation
    extends CCLinkerInvocation {
        private final boolean dynamicLibC = SubstrateOptions.StaticExecutableWithDynamicLibC.getValue();
        private final boolean staticLibCpp = SubstrateOptions.StaticLibStdCpp.getValue();
        private final boolean customStaticLibs = this.dynamicLibC || this.staticLibCpp;
        private static final Set<String> LIB_C_NAMES = Set.of("pthread", "dl", "rt", "m");

        BinutilsCCLinkerInvocation(AbstractImage.NativeImageKind imageKind, NativeLibraries nativeLibs, List<ObjectFile.Symbol> symbols) {
            super(imageKind, nativeLibs, symbols);
            this.additionalPreOptions.add("-z");
            this.additionalPreOptions.add("noexecstack");
            this.additionalPreOptions.add("-z");
            this.additionalPreOptions.add(SubstrateOptions.SpawnIsolates.getValue() != false ? "text" : "notext");
            if (SubstrateOptions.RemoveUnusedSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,--gc-sections");
            }
            if (SubstrateOptions.IgnoreUndefinedReferences.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,--unresolved-symbols=ignore-in-object-files");
            }
            try {
                StringBuilder exportedSymbols = new StringBuilder();
                exportedSymbols.append("{\n");
                Set<String> globalSymbols = Stream.concat(this.getImageSymbols(true).stream(), JNIRegistrationSupport.getShimLibrarySymbols()).collect(Collectors.toSet());
                if (!globalSymbols.isEmpty()) {
                    exportedSymbols.append("global:\n");
                    globalSymbols.forEach(symbol -> exportedSymbols.append('\"').append((String)symbol).append("\";\n"));
                }
                exportedSymbols.append("local: *;\n");
                exportedSymbols.append("};");
                Path exportedSymbolsPath = nativeLibs.tempDirectory.resolve("exported_symbols.list");
                Files.write(exportedSymbolsPath, Collections.singleton(exportedSymbols.toString()), new OpenOption[0]);
                this.additionalPreOptions.add("-Wl,--version-script," + String.valueOf(exportedSymbolsPath.toAbsolutePath()));
            }
            catch (IOException e) {
                VMError.shouldNotReachHere(e);
            }
            this.additionalPreOptions.addAll(HostedLibCBase.singleton().getAdditionalLinkerOptions(imageKind));
            if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,-x");
            }
        }

        @Override
        String getSymbolName(ObjectFile.Symbol symbol) {
            return symbol.getName();
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (this.imageKind) {
                case EXECUTABLE: {
                    cmd.add("-Wl,--export-dynamic");
                    break;
                }
                case STATIC_EXECUTABLE: {
                    if (this.customStaticLibs) break;
                    cmd.add("-static");
                    break;
                }
                case IMAGE_LAYER: 
                case SHARED_LIBRARY: {
                    cmd.add("-shared");
                    break;
                }
                default: {
                    VMError.shouldNotReachHereUnexpectedInput((Object)this.imageKind);
                }
            }
        }

        @Override
        protected List<String> getLibrariesCommand() {
            ArrayList<String> cmd = new ArrayList<String>();
            if (this.customStaticLibs) {
                cmd.add("-Wl,--push-state");
            }
            for (String lib : this.libs) {
                String linkingMode = null;
                if (this.dynamicLibC) {
                    linkingMode = LIB_C_NAMES.contains(lib) ? "dynamic" : "static";
                } else if (this.staticLibCpp) {
                    String string = linkingMode = lib.equals("stdc++") ? "static" : "dynamic";
                }
                if (linkingMode != null) {
                    cmd.add("-Wl,-B" + linkingMode);
                }
                cmd.add("-l" + lib);
            }
            if (this.customStaticLibs) {
                cmd.add("-Wl,--pop-state");
            }
            if (this.customStaticLibs) {
                cmd.add("-static-libgcc");
            }
            return cmd;
        }
    }
}

