/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageLayerLoader;
import com.oracle.graal.pointsto.heap.ImageLayerSnapshotUtil;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.BaseLayerMethod;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.heap.ImageSingletonLoaderImpl;
import com.oracle.svm.hosted.heap.SVMImageLayerSnapshotUtil;
import com.oracle.svm.hosted.meta.RelocatableConstant;
import com.oracle.svm.hosted.util.IdentityHashCodeUtil;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.c.function.RelocatedPointer;

public class SVMImageLayerLoader
extends ImageLayerLoader {
    private final Field dynamicHubArrayHubField = ReflectionUtil.lookupField(DynamicHub.class, (String)"arrayHub");

    public SVMImageLayerLoader(List<Path> loaderPaths) {
        super((ImageLayerSnapshotUtil)new SVMImageLayerSnapshotUtil(), loaderPaths);
    }

    protected void prepareConstantRelinking(EconomicMap<String, Object> constantData, int identityHashCode, int id) {
        Integer tid = (Integer)SVMImageLayerLoader.get(constantData, (String)"class id");
        if (tid != null) {
            this.typeToConstant.put(tid, id);
        } else {
            super.prepareConstantRelinking(constantData, identityHashCode, id);
        }
    }

    protected boolean delegateProcessing(String constantType, Object constantValue, Object[] values, int i) {
        if (constantType.equals("M")) {
            AnalysisType methodPointerType = this.metaAccess.lookupJavaType(MethodPointer.class);
            int mid = (Integer)constantValue;
            AnalysisMethod method = (AnalysisMethod)this.methods.get(mid);
            if (method != null) {
                values[i] = new RelocatableConstant((RelocatedPointer)new MethodPointer((ResolvedJavaMethod)method), methodPointerType);
            } else {
                AnalysisFuture task = new AnalysisFuture(() -> {
                    ResolvedJavaMethod resolvedMethod = (ResolvedJavaMethod)this.methods.get(mid);
                    if (resolvedMethod == null) {
                        resolvedMethod = new BaseLayerMethod();
                        this.missingMethodTasks.computeIfAbsent(mid, unused -> ConcurrentHashMap.newKeySet()).add(new AnalysisFuture(() -> {
                            AnalysisMethod analysisMethod = (AnalysisMethod)this.methods.get(mid);
                            VMError.guarantee(analysisMethod != null, "Method with method id %d should be loaded.", mid);
                            RelocatableConstant constant = new RelocatableConstant((RelocatedPointer)new MethodPointer((ResolvedJavaMethod)analysisMethod), methodPointerType);
                            values[i] = constant;
                            return constant;
                        }));
                    }
                    RelocatableConstant methodPointer = new RelocatableConstant((RelocatedPointer)new MethodPointer(resolvedMethod), methodPointerType);
                    values[i] = methodPointer;
                    return methodPointer;
                });
                values[i] = task;
                this.missingMethodTasks.computeIfAbsent(mid, unused -> ConcurrentHashMap.newKeySet()).add(task);
            }
            return true;
        }
        return super.delegateProcessing(constantType, constantValue, values, i);
    }

    protected JavaConstant getHostedObject(EconomicMap<String, Object> baseLayerConstant, Class<?> clazz) {
        Integer tid;
        if (clazz.equals(Class.class) && (tid = (Integer)SVMImageLayerLoader.get(baseLayerConstant, (String)"class id")) != null) {
            return this.getDynamicHub(tid);
        }
        return super.getHostedObject(baseLayerConstant, clazz);
    }

    private JavaConstant getDynamicHub(int tid) {
        this.getAnalysisType(tid);
        AnalysisType type = this.universe.getType(tid);
        DynamicHub hub = ((SVMHost)this.universe.hostVM()).dynamicHub((ResolvedJavaType)type);
        return this.getHostedObject(hub);
    }

    protected void injectIdentityHashCode(Object object, Integer identityHashCode) {
        if (object == null || identityHashCode == null) {
            return;
        }
        boolean result = IdentityHashCodeUtil.injectIdentityHashCode(object, identityHashCode);
        if (!result && SubstrateOptions.LoggingHashCodeInjection.getValue().booleanValue()) {
            LogUtils.warning((String)"Object of type %s already had an hash code: %s", (Object[])new Object[]{object.getClass(), object});
        }
    }

    public void ensureHubInitialized(ImageHeapConstant constant) {
        JavaConstant javaConstant = constant.getHostedObject();
        if (constant.getType().getJavaClass().equals(Class.class)) {
            DynamicHub hub = (DynamicHub)this.universe.getHostedValuesProvider().asObject(DynamicHub.class, javaConstant);
            AnalysisType type = ((SVMHost)this.universe.hostVM()).lookupType(hub);
            SVMImageLayerLoader.ensureHubInitialized(type);
            if (((ImageHeapInstance)constant).getFieldValue(this.metaAccess.lookupJavaField(this.dynamicHubArrayHubField)) != JavaConstant.NULL_POINTER && hub.getArrayHub() == null) {
                AnalysisType arrayClass = type.getArrayClass();
                SVMImageLayerLoader.ensureHubInitialized(arrayClass);
            }
        }
    }

    private static void ensureHubInitialized(AnalysisType type) {
        type.registerAsReachable((Object)"persisted");
        type.getInitializeMetaDataTask().ensureDone();
    }

    public void rescanHub(AnalysisType type, Object hubObject) {
        DynamicHub hub = (DynamicHub)hubObject;
        this.universe.getHeapScanner().rescanObject((Object)hub);
        this.universe.getHeapScanner().rescanField((Object)hub, SVMImageLayerSnapshotUtil.classInitializationInfo);
        if (type.getJavaKind() == JavaKind.Object) {
            if (type.isArray()) {
                this.universe.getHeapScanner().rescanField((Object)hub.getComponentHub(), SVMImageLayerSnapshotUtil.arrayHub);
            }
            this.universe.getHeapScanner().rescanField((Object)hub, SVMImageLayerSnapshotUtil.interfacesEncoding);
            if (type.isEnum()) {
                this.universe.getHeapScanner().rescanField((Object)hub, SVMImageLayerSnapshotUtil.enumConstantsReference);
            }
        }
    }

    protected boolean hasValueForObject(Object object) {
        if (object instanceof DynamicHub) {
            DynamicHub dynamicHub = (DynamicHub)object;
            AnalysisType type = ((SVMHost)this.universe.hostVM()).lookupType(dynamicHub);
            return this.typeToConstant.containsKey(type.getId());
        }
        return super.hasValueForObject(object);
    }

    protected ImageHeapConstant getValueForObject(Object object) {
        if (object instanceof DynamicHub) {
            DynamicHub dynamicHub = (DynamicHub)object;
            AnalysisType type = ((SVMHost)this.universe.hostVM()).lookupType(dynamicHub);
            int id = (Integer)this.typeToConstant.get(type.getId());
            return this.getOrCreateConstant(id);
        }
        return super.getValueForObject(object);
    }

    public Map<Object, Set<Class<?>>> loadImageSingletons(Object forbiddenObject) {
        this.loadJsonMap();
        return this.loadImageSingletons0(forbiddenObject);
    }

    private Map<Object, Set<Class<?>>> loadImageSingletons0(Object forbiddenObject) {
        List singletonObjects = (List)SVMImageLayerLoader.cast((Object)this.jsonMap.get((Object)"image singleton objects"));
        HashMap<Integer, Object> idToObjectMap = new HashMap<Integer, Object>();
        for (Object entry : singletonObjects) {
            Object result;
            List list = (List)SVMImageLayerLoader.cast(entry);
            Integer id = (Integer)SVMImageLayerLoader.cast(list.get(0));
            String className = (String)SVMImageLayerLoader.cast(list.get(1));
            EconomicMap keyStore = (EconomicMap)SVMImageLayerLoader.cast(list.get(2));
            try {
                Class clazz = ReflectionUtil.lookupClass((boolean)false, (String)className);
                Method createMethod = ReflectionUtil.lookupMethod((Class)clazz, (String)"createFromLoader", (Class[])new Class[]{ImageSingletonLoader.class});
                result = createMethod.invoke(null, new ImageSingletonLoaderImpl((UnmodifiableEconomicMap<String, Object>)keyStore));
            }
            catch (Throwable t) {
                throw VMError.shouldNotReachHere("Failed to recreate image singleton", t);
            }
            idToObjectMap.put(id, result);
        }
        HashMap singletonInitializationMap = new HashMap();
        List singletonKeys = (List)SVMImageLayerLoader.cast((Object)this.jsonMap.get((Object)"image singleton keys"));
        for (Object entry : singletonKeys) {
            List list = (List)SVMImageLayerLoader.cast(entry);
            String key = (String)SVMImageLayerLoader.cast(list.get(0));
            LayeredImageSingleton.PersistFlags persistInfo = LayeredImageSingleton.PersistFlags.values()[(Integer)list.get(1)];
            int id = (Integer)SVMImageLayerLoader.cast(list.get(2));
            if (persistInfo == LayeredImageSingleton.PersistFlags.CREATE) {
                assert (id != -1) : "Create image singletons should be linked to an object";
                Object singletonObject = idToObjectMap.get(id);
                Class clazz = ReflectionUtil.lookupClass((boolean)false, (String)key);
                singletonInitializationMap.computeIfAbsent(singletonObject, k -> new HashSet());
                ((Set)singletonInitializationMap.get(singletonObject)).add(clazz);
                continue;
            }
            if (persistInfo == LayeredImageSingleton.PersistFlags.FORBIDDEN) {
                assert (id == -1) : "Unrestored image singleton should not be linked to an object";
                Class clazz = ReflectionUtil.lookupClass((boolean)false, (String)key);
                singletonInitializationMap.computeIfAbsent(forbiddenObject, k -> new HashSet());
                ((Set)singletonInitializationMap.get(forbiddenObject)).add(clazz);
                continue;
            }
            assert (persistInfo == LayeredImageSingleton.PersistFlags.NOTHING) : "Unexpected PersistFlags value: " + String.valueOf((Object)persistInfo);
            assert (id == -1) : "Unrestored image singleton should not be linked to an object";
        }
        return singletonInitializationMap;
    }
}

