/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.fieldfolding;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingFeature;
import com.oracle.svm.hosted.meta.HostedField;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractStateSplit;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

@NodeInfo(size=NodeSize.SIZE_1, cycles=NodeCycles.CYCLES_1)
public final class MarkStaticFinalFieldInitializedNode
extends AbstractStateSplit
implements Simplifiable {
    public static final NodeClass<MarkStaticFinalFieldInitializedNode> TYPE = NodeClass.create(MarkStaticFinalFieldInitializedNode.class);
    private final ResolvedJavaField field;

    protected MarkStaticFinalFieldInitializedNode(ResolvedJavaField field) {
        super(TYPE, StampFactory.forVoid());
        this.field = field;
    }

    public ResolvedJavaField getField() {
        return this.field;
    }

    public void simplify(SimplifierTool tool) {
        if (this.field instanceof AnalysisField) {
            return;
        }
        assert (this.field instanceof HostedField);
        StaticFinalFieldFoldingFeature feature = StaticFinalFieldFoldingFeature.singleton();
        Integer fieldCheckIndex = feature.fieldCheckIndexMap.get(StaticFinalFieldFoldingFeature.toAnalysisField(this.field));
        if (fieldCheckIndex != null) {
            ConstantNode fieldInitializationStatusNode = ConstantNode.forConstant((JavaConstant)tool.getSnippetReflection().forObject((Object)feature.fieldInitializationStatus), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)this.graph());
            ConstantNode fieldCheckIndexNode = ConstantNode.forInt((int)fieldCheckIndex, (StructuredGraph)this.graph());
            ConstantNode trueNode = ConstantNode.forBoolean((boolean)true, (StructuredGraph)this.graph());
            StoreIndexedNode replacementNode = (StoreIndexedNode)this.graph().add((Node)new StoreIndexedNode((ValueNode)fieldInitializationStatusNode, (ValueNode)fieldCheckIndexNode, null, null, JavaKind.Boolean, (ValueNode)trueNode));
            this.graph().addBeforeFixed((FixedNode)this, (FixedWithNextNode)replacementNode);
            replacementNode.setStateAfter(this.stateAfter());
        }
        this.graph().removeFixed((FixedWithNextNode)this);
    }
}

