/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Reference;

class AdrpAddMacroInstructionHostedPatcher
extends CompilationResult.CodeAnnotation
implements HostedPatcher {
    private final AArch64MacroAssembler.AdrpAddMacroInstruction macroInstruction;

    AdrpAddMacroInstructionHostedPatcher(AArch64MacroAssembler.AdrpAddMacroInstruction macroInstruction) {
        super(macroInstruction.instructionPosition);
        this.macroInstruction = macroInstruction;
    }

    @Override
    public void relocate(Reference ref, RelocatableBuffer relocs, int compStart) {
        if (ref instanceof ConstantReference) {
            ConstantReference constantRef = (ConstantReference)ref;
            VMError.guarantee(!(constantRef.getConstant() instanceof SubstrateMethodPointerConstant), "SubstrateMethodPointerConstants should not be relocated %s", constantRef);
        } else {
            VMError.guarantee(ref instanceof DataSectionReference || ref instanceof CGlobalDataReference, "Unexpected reference: %s", ref);
        }
        int siteOffset = compStart + this.macroInstruction.instructionPosition;
        relocs.addRelocationWithoutAddend(siteOffset, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADR_PREL_PG_HI21, ref);
        relocs.addRelocationWithoutAddend(siteOffset += 4, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADD_ABS_LO12_NC, ref);
    }

    @Override
    @Uninterruptible(reason=".")
    public void patch(int compStart, int relative, byte[] code) {
        long startAddress = (long)compStart + (long)this.macroInstruction.instructionPosition;
        this.macroInstruction.patch(startAddress, relative, code);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

