/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.code.FactoryMethodHolder;
import com.oracle.svm.core.code.FactoryThrowMethodHolder;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.FactoryMethod;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton
public class FactoryMethodSupport {
    private final Map<AnalysisMethod, FactoryMethod> factoryMethods = new ConcurrentHashMap<AnalysisMethod, FactoryMethod>();
    private final Map<AnalysisMethod, FactoryMethod> factoryThrowMethods = new ConcurrentHashMap<AnalysisMethod, FactoryMethod>();

    public static FactoryMethodSupport singleton() {
        return (FactoryMethodSupport)ImageSingletons.lookup(FactoryMethodSupport.class);
    }

    public AnalysisMethod lookup(AnalysisMetaAccess aMetaAccess, AnalysisMethod aConstructor, boolean throwAllocatedObject) {
        VMError.guarantee(aConstructor.getDeclaringClass().isInstanceClass() && !aConstructor.getDeclaringClass().isAbstract(), "Must be a non-abstract instance class");
        Map<AnalysisMethod, FactoryMethod> methods = throwAllocatedObject ? this.factoryThrowMethods : this.factoryMethods;
        FactoryMethod factoryMethod = methods.computeIfAbsent(aConstructor, key -> {
            String name = SubstrateUtil.uniqueStubName((ResolvedJavaMethod)aConstructor);
            ResolvedJavaType[] unwrappedParameterTypes = new ResolvedJavaType[aConstructor.getSignature().getParameterCount(false)];
            for (int i = 0; i < unwrappedParameterTypes.length; ++i) {
                unwrappedParameterTypes[i] = ((AnalysisType)aConstructor.getSignature().getParameterType(i)).getWrapped();
            }
            ResolvedJavaType unwrappedReturnType = (throwAllocatedObject ? aMetaAccess.lookupJavaType(Void.TYPE) : aConstructor.getDeclaringClass()).getWrapped();
            ResolvedSignature unwrappedSignature = ResolvedSignature.fromArray((ResolvedJavaType[])unwrappedParameterTypes, (ResolvedJavaType)unwrappedReturnType);
            ResolvedJavaMethod unwrappedConstructor = aConstructor.getWrapped();
            ResolvedJavaType unwrappedDeclaringClass = aMetaAccess.lookupJavaType(throwAllocatedObject ? FactoryThrowMethodHolder.class : FactoryMethodHolder.class).getWrapped();
            ConstantPool unwrappedConstantPool = unwrappedConstructor.getConstantPool();
            return new FactoryMethod(name, unwrappedConstructor, unwrappedDeclaringClass, (Signature)unwrappedSignature, unwrappedConstantPool, throwAllocatedObject);
        });
        return aMetaAccess.getUniverse().lookup((JavaMethod)factoryMethod);
    }

    protected AbstractNewObjectNode createNewInstance(HostedGraphKit kit, ResolvedJavaType type, boolean fillContents) {
        return (AbstractNewObjectNode)kit.append((Node)new NewInstanceNode(type, fillContents));
    }
}

