/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import java.util.function.Function;

public final class ClassInitializationOptions {
    public static final String SEPARATOR = ":";
    public static final String SUFFIX_BUILD_TIME = ":build_time";
    public static final String SUFFIX_RUN_TIME = ":run_time";
    @APIOption.List(value={@APIOption(name={"initialize-at-run-time"}, valueTransformer={InitializationValueRunTime.class}, defaultValue={""}, customHelp="A comma-separated list of packages and classes (and implicitly all of their subclasses) that must be initialized at runtime and not during image building. An empty string is currently not supported."), @APIOption(name={"initialize-at-build-time"}, valueTransformer={InitializationValueBuildTime.class}, defaultValue={""}, customHelp="A comma-separated list of packages and classes (and implicitly all of their superclasses) that are initialized during image generation. An empty string designates all packages."), @APIOption(name={"delay-class-initialization-to-runtime"}, valueTransformer={InitializationValueRunTime.class}, deprecated="Use --initialize-at-run-time.", defaultValue={""}), @APIOption(name={"rerun-class-initialization-at-runtime"}, valueTransformer={InitializationValueRunTime.class}, deprecated="Equivalent to --initialize-at-run-time.", defaultValue={""})})
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ClassInitialization = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
    public static final HostedOptionKey<Boolean> AllowDeprecatedInitializeAllClassesAtBuildTime = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> PrintClassInitialization = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> AssertInitializationSpecifiedForAllClasses = new HostedOptionKey<Boolean>(false);
    @APIOption(name={"strict-image-heap"}, deprecated="'--strict-image-heap' is now the default. You can remove the option.")
    static final HostedOptionKey<Boolean> StrictImageHeap = new HostedOptionKey<Boolean>(true);
    public static final HostedOptionKey<Boolean> SimulateClassInitializer = new HostedOptionKey<Boolean>(true);
    static final HostedOptionKey<Boolean> SimulateClassInitializerCollectAllReasons = new HostedOptionKey<Boolean>(false);
    static final HostedOptionKey<Integer> SimulateClassInitializerMaxInlineDepth = new HostedOptionKey<Integer>(200);
    static final HostedOptionKey<Integer> SimulateClassInitializerMaxLoopIterations = new HostedOptionKey<Integer>(2000);
    static final HostedOptionKey<Integer> SimulateClassInitializerMaxAllocatedBytes = new HostedOptionKey<Integer>(40000);

    private static class InitializationValueBuildTime
    extends InitializationValueTransformer {
        InitializationValueBuildTime() {
            super(ClassInitializationOptions.SUFFIX_BUILD_TIME);
        }
    }

    private static class InitializationValueRunTime
    extends InitializationValueTransformer {
        InitializationValueRunTime() {
            super(ClassInitializationOptions.SUFFIX_RUN_TIME);
        }
    }

    private static class InitializationValueTransformer
    implements Function<Object, Object> {
        private final String suffix;

        InitializationValueTransformer(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public Object apply(Object o) {
            String[] elements = o.toString().split(",");
            if (elements.length == 0) {
                return this.suffix;
            }
            CharSequence[] results = new String[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                results[i] = elements[i] + this.suffix;
            }
            return String.join((CharSequence)",", results);
        }
    }
}

