/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import jdk.graal.compiler.debug.GraalError;
import jdk.internal.reflect.ConstantPool;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.TypeNotPresentExceptionProxy;

public class AnnotationMetadata {
    private static final Method annotationParserParseSig = ReflectionUtil.lookupMethod(AnnotationParser.class, (String)"parseSig", (Class[])new Class[]{String.class, Class.class});
    private static final Constructor<?> annotationTypeMismatchExceptionProxyConstructor;

    static Object extractType(ByteBuffer buf, ConstantPool cp, Class<?> container, boolean skip) {
        Class type;
        int typeIndex = buf.getShort() & 0xFFFF;
        if (skip) {
            return null;
        }
        String signature = cp.getUTF8At(typeIndex);
        try {
            type = (Class)annotationParserParseSig.invoke(null, signature, container);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof LinkageError || targetException instanceof TypeNotPresentException) {
                return new TypeNotPresentExceptionProxy(signature, targetException);
            }
            throw new AnnotationExtractionError((Object)signature, (Throwable)e);
        }
        catch (ReflectiveOperationException e) {
            throw new AnnotationExtractionError((Object)signature, (Throwable)e);
        }
        return type;
    }

    static String extractString(ByteBuffer buf, ConstantPool cp, boolean skip) {
        int index = buf.getShort() & 0xFFFF;
        return skip ? null : cp.getUTF8At(index);
    }

    static Object checkResult(Object value, Class<?> expectedType) {
        if (!expectedType.isInstance(value)) {
            if (value instanceof Annotation) {
                return AnnotationMetadata.createAnnotationTypeMismatchExceptionProxy(value.toString());
            }
            return AnnotationMetadata.createAnnotationTypeMismatchExceptionProxy(value.getClass().getName() + "[" + String.valueOf(value) + "]");
        }
        return value;
    }

    static Object createAnnotationTypeMismatchExceptionProxy(String message) {
        try {
            return annotationTypeMismatchExceptionProxyConstructor.newInstance(message);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new AnnotationExtractionError((Object)message, (Throwable)e);
        }
    }

    static {
        try {
            annotationTypeMismatchExceptionProxyConstructor = ReflectionUtil.lookupConstructor(Class.forName("sun.reflect.annotation.AnnotationTypeMismatchExceptionProxy"), (Class[])new Class[]{String.class});
        }
        catch (ClassNotFoundException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    static final class AnnotationExtractionError
    extends Error {
        AnnotationExtractionError(Object targetElement, Throwable cause) {
            super("Failed to process '%s': %s".formatted(targetElement, cause), cause);
        }

        AnnotationExtractionError(Object targetElement, String message) {
            super("Failed to process '%s': %s".formatted(targetElement, message));
        }
    }
}

