/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.graal.compiler.debug.Assertions;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class OpenTypeWorldFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return !SubstrateOptions.closedTypeWorld();
    }

    public void beforeUniverseBuilding(Feature.BeforeUniverseBuildingAccess access) {
        if (ImageLayerBuildingSupport.buildingInitialLayer()) {
            ImageSingletons.add(LayerTypeInfo.class, (Object)new LayerTypeInfo());
        } else assert (!ImageLayerBuildingSupport.buildingImageLayer() || ImageSingletons.contains(LayerTypeInfo.class)) : "Layered image is missing layer type info";
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FeatureImpl.BeforeCompilationAccessImpl impl = (FeatureImpl.BeforeCompilationAccessImpl)access;
        for (HostedType type : impl.getUniverse().getTypes()) {
            DynamicHub hub = type.getHub();
            impl.registerAsImmutable(hub.getOpenTypeWorldTypeCheckSlots());
        }
    }

    public static int loadTypeInfo(Collection<HostedType> types) {
        if (ImageSingletons.contains(LayerTypeInfo.class) && ImageLayerBuildingSupport.buildingExtensionLayer()) {
            return ((LayerTypeInfo)ImageSingletons.lookup(LayerTypeInfo.class)).loadTypeID(types);
        }
        return 0;
    }

    public static void persistTypeInfo(Collection<HostedType> types) {
        if (ImageSingletons.contains(LayerTypeInfo.class)) {
            ((LayerTypeInfo)ImageSingletons.lookup(LayerTypeInfo.class)).persistTypeInfo(types);
        }
    }

    private static class LayerTypeInfo
    implements LayeredImageSingleton {
        Map<Integer, TypeInfo> identifierToTypeInfo = new HashMap<Integer, TypeInfo>();
        int maxTypeID = 0;

        private LayerTypeInfo() {
        }

        public int loadTypeID(Collection<HostedType> types) {
            ArrayList<Integer> usedIDs = new ArrayList<Integer>();
            for (HostedType type : types) {
                int identifierID = type.getWrapped().getId();
                TypeInfo info = this.identifierToTypeInfo.get(identifierID);
                if (info == null) continue;
                usedIDs.add(info.typeID);
                type.loadTypeID(info.typeID);
            }
            return this.maxTypeID;
        }

        public void persistTypeInfo(Collection<HostedType> types) {
            for (HostedType type : types) {
                if (type.getTypeID() == -1) continue;
                int identifierID = type.getWrapped().getId();
                int typeID = type.getTypeID();
                int numClassTypes = type.getNumClassTypes();
                int numInterfaceTypes = type.getNumInterfaceTypes();
                int[] typecheckSlots = type.getOpenTypeWorldTypeCheckSlots();
                TypeInfo priorInfo = this.identifierToTypeInfo.get(identifierID);
                TypeInfo newTypeInfo = new TypeInfo(typeID, numClassTypes, numInterfaceTypes, typecheckSlots);
                if (priorInfo == null) {
                    this.identifierToTypeInfo.put(identifierID, newTypeInfo);
                    continue;
                }
                assert (newTypeInfo.equals(priorInfo)) : Assertions.errorMessage((Object[])new Object[]{"Mismatch for ", type, priorInfo, newTypeInfo, Arrays.toString(priorInfo.typecheckSlots), Arrays.toString(newTypeInfo.typecheckSlots)});
            }
        }

        @Override
        public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
            return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
        }

        @Override
        public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
            List<Integer> identifierIDs = this.identifierToTypeInfo.keySet().stream().sorted().toList();
            writer.writeIntList("identifierIDs", identifierIDs);
            writer.writeInt("maxTypeID", DynamicHubSupport.singleton().getMaxTypeId());
            for (int identifierID : identifierIDs) {
                TypeInfo typeInfo = this.identifierToTypeInfo.get(identifierID);
                writer.writeIntList(Integer.toString(identifierID), typeInfo.toIntList());
            }
            return LayeredImageSingleton.PersistFlags.CREATE;
        }

        public static Object createFromLoader(ImageSingletonLoader loader) {
            LayerTypeInfo info = new LayerTypeInfo();
            info.maxTypeID = loader.readInt("maxTypeID");
            List<Integer> identifierIDs = loader.readIntList("identifierIDs");
            for (Integer identifierID : identifierIDs) {
                TypeInfo previous = info.identifierToTypeInfo.put(identifierID, TypeInfo.fromIntList(loader.readIntList(Integer.toString(identifierID))));
                assert (previous == null) : previous;
            }
            return info;
        }
    }

    record TypeInfo(int typeID, int numClassTypes, int numInterfaceTypes, int[] typecheckSlots) {
        private List<Integer> toIntList() {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(this.typeID);
            list.add(this.numClassTypes);
            list.add(this.numInterfaceTypes);
            Arrays.stream(this.typecheckSlots).forEach(list::add);
            return list;
        }

        private static TypeInfo fromIntList(List<Integer> list) {
            int typeID = list.get(0);
            int numClassTypes = list.get(1);
            int numInterfaceTypes = list.get(2);
            int[] typecheckSlots = list.subList(3, list.size()).stream().mapToInt(i -> i).toArray();
            return new TypeInfo(typeID, numClassTypes, numInterfaceTypes, typecheckSlots);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeInfo typeInfo = (TypeInfo)o;
            return this.typeID == typeInfo.typeID && this.numClassTypes == typeInfo.numClassTypes && this.numInterfaceTypes == typeInfo.numInterfaceTypes && Arrays.equals(this.typecheckSlots, typeInfo.typecheckSlots);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.typeID, this.numClassTypes, this.numInterfaceTypes);
            result = 31 * result + Arrays.hashCode(this.typecheckSlots);
            return result;
        }
    }
}

