/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CIsolateData;
import com.oracle.svm.core.c.CIsolateDataFactory;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.pthread.PthreadConditionUtils;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import com.oracle.svm.core.posix.pthread.PthreadVMMutex;

final class PthreadVMCondition
extends VMCondition {
    private final CIsolateData<Pthread.pthread_cond_t> structPointer = CIsolateDataFactory.createStruct("pthreadCondition_" + this.getName(), Pthread.pthread_cond_t.class);

    PthreadVMCondition(PthreadVMMutex mutex, String name) {
        super(mutex, name);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Pthread.pthread_cond_t getStructPointer() {
        return this.structPointer.get();
    }

    @Override
    @Uninterruptible(reason="Too early for safepoints.")
    public int initialize() {
        return PthreadConditionUtils.initConditionWithRelativeTime(this.getStructPointer());
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public int destroy() {
        return Pthread.pthread_cond_destroy(this.getStructPointer());
    }

    @Override
    public void block() {
        this.mutex.clearCurrentThreadOwner();
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_wait(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer()), "pthread_cond_wait");
        this.mutex.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public void blockNoTransition() {
        this.mutex.clearCurrentThreadOwner();
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_wait_no_transition(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer()), "pthread_cond_wait");
        this.mutex.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public void blockNoTransitionUnspecifiedOwner() {
        this.mutex.clearUnspecifiedOwner();
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_wait_no_transition(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer()), "pthread_cond_wait");
        this.mutex.setOwnerToUnspecified();
    }

    @Override
    public long block(long waitNanos) {
        if (waitNanos <= 0L) {
            return 0L;
        }
        long startTime = System.nanoTime();
        Time.timespec absTime = UnsafeStackValue.get(Time.timespec.class);
        PthreadConditionUtils.fillTimespec(absTime, waitNanos);
        this.mutex.clearCurrentThreadOwner();
        int timedWaitResult = Pthread.pthread_cond_timedwait(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer(), absTime);
        this.mutex.setOwnerToCurrentThread();
        if (timedWaitResult == Errno.ETIMEDOUT()) {
            return 0L;
        }
        PthreadVMLockSupport.checkResult(timedWaitResult, "PthreadVMLockSupport.block(long): pthread_cond_timedwait");
        return PthreadVMCondition.remainingNanos(waitNanos, startTime);
    }

    @Override
    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public long blockNoTransition(long waitNanos) {
        if (waitNanos <= 0L) {
            return 0L;
        }
        long startTime = System.nanoTime();
        Time.timespec absTime = UnsafeStackValue.get(Time.timespec.class);
        PthreadConditionUtils.fillTimespec(absTime, waitNanos);
        this.mutex.clearCurrentThreadOwner();
        int timedWaitResult = Pthread.pthread_cond_timedwait_no_transition(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer(), absTime);
        this.mutex.setOwnerToCurrentThread();
        if (timedWaitResult == Errno.ETIMEDOUT()) {
            return 0L;
        }
        PthreadVMLockSupport.checkResult(timedWaitResult, "PthreadVMLockSupport.blockNoTransition(long): pthread_cond_timedwait");
        return PthreadVMCondition.remainingNanos(waitNanos, startTime);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long remainingNanos(long waitNanos, long startNanos) {
        long actual = System.nanoTime() - startNanos;
        return UninterruptibleUtils.Math.max(0L, waitNanos - actual);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void signal() {
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_signal(this.getStructPointer()), "pthread_cond_signal");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void broadcast() {
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_broadcast(this.getStructPointer()), "pthread_cond_broadcast");
    }
}

