/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public interface SharedType
extends ResolvedJavaType {
    public DynamicHub getHub();

    public JavaKind getStorageKind();

    public int getTypeID();

    default public ResolvedJavaMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        throw VMError.intentionallyUnimplemented();
    }

    default public ResolvedJavaMethod resolveConcreteMethod(ResolvedJavaMethod m, ResolvedJavaType callerType) {
        SharedMethod method = (SharedMethod)m;
        SharedMethod found = null;
        if (!this.isInterface()) {
            for (SharedMethod cur : method.getImplementations()) {
                if (!1.$assertionsDisabled && cur.isAbstract()) {
                    throw new AssertionError();
                }
                ResolvedJavaType curHolder = cur.getDeclaringClass();
                if (!curHolder.isAssignableFrom((ResolvedJavaType)this)) continue;
                if (found == null) {
                    found = cur;
                    continue;
                }
                if (!found.getDeclaringClass().isAssignableFrom(curHolder)) continue;
                found = cur;
            }
        }
        return found;
    }

    default public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod m) {
        SharedMethod method = (SharedMethod)m;
        SharedMethod[] implementations = method.getImplementations();
        if (implementations.length == 1) {
            return new Assumptions.AssumptionResult((Object)implementations[0]);
        }
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

