/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.throttling;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.throttling.JfrAdaptiveSampler;
import com.oracle.svm.core.jfr.throttling.JfrSamplerParams;
import com.oracle.svm.core.jfr.throttling.JfrSamplerWindow;
import com.oracle.svm.core.jfr.throttling.Target_jdk_jfr_internal_settings_ThrottleSetting;
import com.oracle.svm.core.thread.JavaSpinLockUtils;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.TimeUtils;

public class JfrEventThrottler
extends JfrAdaptiveSampler {
    private static final long MINUTE = TimeUtils.secondsToMillis(60L);
    private static final long TEN_PER_1000_MS_IN_MINUTES = 600L;
    private static final long HOUR = 60L * MINUTE;
    private static final long TEN_PER_1000_MS_IN_HOURS = 36000L;
    private static final long DAY = 24L * HOUR;
    private static final long TEN_PER_1000_MS_IN_DAYS = 864000L;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/recorder/service/jfrEventThrottler.cpp#L105")
    private static final long DEFAULT_WINDOW_LOOKBACK_COUNT = 25L;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/recorder/service/jfrEventThrottler.cpp#L112")
    private static final long LOW_RATE_UPPER_BOUND = 9L;
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/recorder/service/jfrEventThrottler.cpp#L113")
    private static final long WINDOW_DIVISOR = 5L;
    private static final JfrSamplerParams DISABLED_PARAMS = new JfrSamplerParams();
    private final JfrSamplerParams lastParams = new JfrSamplerParams();
    private long sampleSize;
    private long periodMs;
    private boolean disabled = true;
    private boolean update;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public void configure(long sampleSize, long periodMs) {
        JavaSpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
        try {
            this.sampleSize = sampleSize;
            this.periodMs = periodMs;
            this.update = true;
            this.reconfigure();
        }
        finally {
            JavaSpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected JfrSamplerParams nextWindowParams() {
        if (this.update) {
            this.disabled = JfrEventThrottler.isDisabled(this.sampleSize);
            if (!this.disabled) {
                this.updateParams();
            }
        }
        return this.disabled ? DISABLED_PARAMS : this.lastParams;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/recorder/service/jfrEventThrottler.cpp#L200-L212")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void updateParams() {
        this.normalize();
        JfrEventThrottler.setSamplePointsAndWindowDuration(this.lastParams, this.sampleSize, this.periodMs);
        JfrEventThrottler.setWindowLookback(this.lastParams);
        this.lastParams.reconfigure = true;
        this.update = false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isDisabled(long eventSampleSize) {
        return eventSampleSize == Target_jdk_jfr_internal_settings_ThrottleSetting.OFF;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/recorder/service/jfrEventThrottler.cpp#L170-L194")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void normalize() {
        if (this.periodMs != 1000L) {
            if (this.periodMs == MINUTE) {
                if (this.sampleSize >= 600L) {
                    this.sampleSize /= 60L;
                    this.periodMs /= 60L;
                }
            } else if (this.periodMs == HOUR) {
                if (this.sampleSize >= 36000L) {
                    this.sampleSize /= 3600L;
                    this.periodMs /= 3600L;
                }
            } else if (this.sampleSize >= 864000L) {
                this.sampleSize /= 86400L;
                this.periodMs /= 86400L;
            }
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/recorder/service/jfrEventThrottler.cpp#L145-L165")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void setSamplePointsAndWindowDuration(JfrSamplerParams params, long sampleSize, long periodMs) {
        assert (sampleSize != Target_jdk_jfr_internal_settings_ThrottleSetting.OFF);
        assert (sampleSize >= 0L);
        if (sampleSize <= 9L) {
            JfrEventThrottler.setLowRate(params, sampleSize, periodMs);
        } else if (periodMs == MINUTE && sampleSize < 600L) {
            JfrEventThrottler.setLowRate(params, sampleSize, periodMs);
        } else if (periodMs == HOUR && sampleSize < 36000L) {
            JfrEventThrottler.setLowRate(params, sampleSize, periodMs);
        } else if (periodMs == DAY && sampleSize < 864000L) {
            JfrEventThrottler.setLowRate(params, sampleSize, periodMs);
        } else {
            assert (periodMs % 5L == 0L);
            params.samplePointsPerWindow = sampleSize / 5L;
            params.windowDurationMs = periodMs / 5L;
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/recorder/service/jfrEventThrottler.cpp#L134-L137")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void setLowRate(JfrSamplerParams params, long eventSampleSize, long periodMs) {
        params.samplePointsPerWindow = eventSampleSize;
        params.windowDurationMs = periodMs;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+8/src/hotspot/share/jfr/recorder/service/jfrEventThrottler.cpp#L122-L132")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void setWindowLookback(JfrSamplerParams params) {
        params.windowLookbackCount = params.windowDurationMs <= 1000L ? 25L : (params.windowDurationMs == MINUTE ? 5L : 1L);
    }

    public static class TestingBackdoor {
        public static boolean sample(JfrEventThrottler throttler) {
            return throttler.sample(JfrTicks.now());
        }

        public static void expireActiveWindow(JfrEventThrottler throttler) {
            JfrSamplerWindow window = TestingBackdoor.getActiveWindow(throttler);
            JfrSamplerWindow.TestingBackdoor.expire(window);
        }

        public static long getActiveWindowAccumulatedDebt(JfrEventThrottler throttler) {
            return -TestingBackdoor.getActiveWindow(throttler).getAccumulatedDebt();
        }

        public static double getAveragePopulationSize(JfrEventThrottler throttler) {
            return throttler.avgPopulationSize;
        }

        public static long getWindowLookbackCount(JfrEventThrottler throttler) {
            return throttler.lastParams.windowLookbackCount;
        }

        public static long getSampleSize(JfrEventThrottler throttler) {
            return throttler.sampleSize;
        }

        public static long getPeriodMs(JfrEventThrottler throttler) {
            return throttler.periodMs;
        }

        public static long getWindowsPerPeriod() {
            return 5L;
        }

        private static JfrSamplerWindow getActiveWindow(JfrEventThrottler throttler) {
            return throttler.activeWindow;
        }
    }
}

