/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.sampler;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jfr.JfrExecutionSamplerSupported;
import com.oracle.svm.core.jfr.JfrFeature;
import com.oracle.svm.core.jfr.sampler.JfrExecutionSampler;
import com.oracle.svm.core.jfr.sampler.JfrRecurringCallbackExecutionSampler;
import com.oracle.svm.core.thread.ThreadListenerSupport;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class JfrRecurringCallbackExecutionSamplerFeature
implements InternalFeature {
    JfrRecurringCallbackExecutionSamplerFeature() {
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(JfrFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (JfrExecutionSamplerSupported.isSupported() && !ImageSingletons.contains(JfrExecutionSampler.class)) {
            JfrRecurringCallbackExecutionSampler sampler = new JfrRecurringCallbackExecutionSampler();
            ImageSingletons.add(JfrExecutionSampler.class, (Object)sampler);
            ThreadListenerSupport.get().register(sampler);
        }
    }
}

