/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jfr.JfrJdkCompatibility;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.events.EndChunkNativePeriodicEvents;
import com.oracle.svm.core.jfr.events.EveryChunkNativePeriodicEvents;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.UserError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.OldObjectSample;
import jdk.jfr.internal.Options;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.jfc.JFC;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrManager {
    private static final String DEFAULT_JFC_NAME = "default";
    @Platforms(value={Platform.HOSTED_ONLY.class})
    final boolean hostedEnabled;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrManager(boolean hostedEnabled) {
        this.hostedEnabled = hostedEnabled;
    }

    @Fold
    public static JfrManager get() {
        return (JfrManager)ImageSingletons.lookup(JfrManager.class);
    }

    public static RuntimeSupport.Hook initializationHook() {
        return isFirstIsolate -> {
            JfrManager.parseFlightRecorderLogging();
            JfrManager.parseFlightRecorderOptions();
        };
    }

    public static RuntimeSupport.Hook startupHook() {
        return isFirstIsolate -> {
            boolean startRecording;
            JfrManager.periodicEventSetup();
            boolean bl = startRecording = SubstrateOptions.FlightRecorder.getValue() != false || !SubstrateOptions.StartFlightRecording.getValue().isEmpty();
            if (startRecording) {
                JfrManager.initRecording();
            }
        };
    }

    private static void parseFlightRecorderOptions() {
        Map<JfrArgument, String> optionsArgs = JfrManager.parseJfrOptions(SubstrateOptions.FlightRecorderOptions, FlightRecorderOptionsArgument.values());
        Long globalBufferSize = JfrManager.parseMaxSize(optionsArgs, FlightRecorderOptionsArgument.GlobalBufferSize);
        Long maxChunkSize = JfrManager.parseMaxSize(optionsArgs, FlightRecorderOptionsArgument.MaxChunkSize);
        Long memorySize = JfrManager.parseMaxSize(optionsArgs, FlightRecorderOptionsArgument.MemorySize);
        Integer oldObjectQueueSize = JfrManager.parseInteger(optionsArgs, FlightRecorderOptionsArgument.OldObjectQueueSize);
        String repositoryPath = optionsArgs.get(FlightRecorderOptionsArgument.RepositoryPath);
        Integer stackDepth = JfrManager.parseInteger(optionsArgs, FlightRecorderOptionsArgument.StackDepth);
        Boolean preserveRepository = JfrManager.parseBoolean(optionsArgs, FlightRecorderOptionsArgument.PreserveRepository);
        Long threadBufferSize = JfrManager.parseMaxSize(optionsArgs, FlightRecorderOptionsArgument.ThreadBufferSize);
        if (globalBufferSize != null) {
            Options.setGlobalBufferSize(globalBufferSize);
        }
        if (maxChunkSize != null) {
            Options.setMaxChunkSize(maxChunkSize);
        }
        if (memorySize != null) {
            Options.setMemorySize(memorySize);
        }
        if (oldObjectQueueSize != null) {
            if (oldObjectQueueSize >= 0) {
                SubstrateJVM.getOldObjectProfiler().configure(oldObjectQueueSize);
            } else {
                throw JfrManager.argumentParsingFailed(FlightRecorderOptionsArgument.OldObjectQueueSize.getCmdLineKey() + " must be greater or equal 0.");
            }
        }
        if (repositoryPath != null) {
            try {
                SecuritySupport.SafePath repositorySafePath = new SecuritySupport.SafePath(repositoryPath);
                Repository.getRepository().setBasePath(repositorySafePath);
            }
            catch (Throwable e) {
                throw JfrManager.argumentParsingFailed("Could not use " + repositoryPath + " as repository. " + e.getMessage(), e);
            }
        }
        if (stackDepth != null) {
            Options.setStackDepth(stackDepth);
        }
        if (preserveRepository != null) {
            Options.setPreserveRepository(preserveRepository);
        }
        if (threadBufferSize != null) {
            Options.setThreadBufferSize(threadBufferSize);
        }
    }

    public static RuntimeSupport.Hook shutdownHook() {
        return isFirstIsolate -> {
            FlightRecorder.removePeriodicEvent(EveryChunkNativePeriodicEvents::emit);
            FlightRecorder.removePeriodicEvent(EndChunkNativePeriodicEvents::emit);
        };
    }

    private static void parseFlightRecorderLogging() {
        String option = SubstrateOptions.FlightRecorderLogging.getValue();
        SubstrateJVM.getLogging().parseConfiguration(option);
    }

    private static void periodicEventSetup() throws SecurityException {
        FlightRecorder.addPeriodicEvent(EveryChunkNativePeriodicEvents.class, EveryChunkNativePeriodicEvents::emit);
        FlightRecorder.addPeriodicEvent(EndChunkNativePeriodicEvents.class, EndChunkNativePeriodicEvents::emit);
    }

    private static void initRecording() {
        Map<JfrArgument, String> startArgs = JfrManager.parseJfrOptions(SubstrateOptions.StartFlightRecording, JfrStartArgument.values());
        String name = startArgs.get(JfrStartArgument.Name);
        String[] settings = JfrManager.parseSettings(startArgs);
        Long delay = JfrManager.parseDuration(startArgs, JfrStartArgument.Delay);
        Long duration = JfrManager.parseDuration(startArgs, JfrStartArgument.Duration);
        Boolean disk = JfrManager.parseBoolean(startArgs, JfrStartArgument.Disk);
        String path = startArgs.get(JfrStartArgument.Filename);
        Long maxAge = JfrManager.parseDuration(startArgs, JfrStartArgument.MaxAge);
        Long maxSize = JfrManager.parseMaxSize(startArgs, JfrStartArgument.MaxSize);
        Boolean dumpOnExit = JfrManager.parseBoolean(startArgs, JfrStartArgument.DumpOnExit);
        Boolean pathToGcRoots = JfrManager.parseBoolean(startArgs, JfrStartArgument.PathToGCRoots);
        if (Logger.shouldLog(LogTag.JFR_DCMD, LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR_DCMD, LogLevel.DEBUG, "Executing DCmdStart: name=" + name + ", settings=" + String.valueOf(Arrays.asList(settings)) + ", delay=" + delay + ", duration=" + duration + ", disk=" + disk + ", filename=" + path + ", maxage=" + maxAge + ", maxsize=" + maxSize + ", dumponexit =" + dumpOnExit + ", path-to-gc-roots=" + pathToGcRoots);
        }
        if (name != null) {
            try {
                Integer.parseInt(name);
                throw JfrManager.argumentParsingFailed("Name of recording can't be numeric");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (duration == null && Boolean.FALSE.equals(dumpOnExit) && path != null) {
            throw JfrManager.argumentParsingFailed("Filename can only be set for a time bound recording or if dumponexit=true. Set duration/dumponexit or omit filename.");
        }
        if (settings.length == 1 && settings[0].length() == 0) {
            throw JfrManager.argumentParsingFailed("No settings specified. Use settings=none to start without any settings");
        }
        HashMap<String, String> s = new HashMap<String, String>();
        for (String configName : settings) {
            try {
                s.putAll(JFC.createKnown(configName).getSettings());
            }
            catch (FileNotFoundException e) {
                throw JfrManager.argumentParsingFailed("Could not find settings file'" + configName + "'", e);
            }
            catch (IOException | ParseException e) {
                throw JfrManager.argumentParsingFailed("Could not parse settings file '" + settings[0] + "'", e);
            }
        }
        OldObjectSample.updateSettingPathToGcRoots(s, pathToGcRoots);
        if (duration != null && duration < 1000000000L) {
            throw JfrManager.argumentParsingFailed("Could not start recording, duration must be at least 1 second.");
        }
        if (delay != null && delay < 1000000000L) {
            throw JfrManager.argumentParsingFailed("Could not start recording, delay must be at least 1 second.");
        }
        Recording recording = new Recording();
        if (name != null) {
            recording.setName(name);
        }
        if (disk != null) {
            recording.setToDisk(disk);
        }
        recording.setSettings(s);
        SecuritySupport.SafePath safePath = null;
        if (path != null) {
            try {
                Path p;
                if (dumpOnExit == null) {
                    dumpOnExit = Boolean.TRUE;
                }
                if (Files.isDirectory(p = Paths.get(path, new String[0]), new LinkOption[0]) && (JavaVersionUtil.JAVA_SPEC >= 23 || Boolean.TRUE.equals(dumpOnExit))) {
                    JfrJdkCompatibility.setDumpDirectory(PrivateAccess.getInstance().getPlatformRecording(recording), new SecuritySupport.SafePath(p));
                } else {
                    safePath = JfrManager.resolvePath(recording, path);
                    recording.setDestination(safePath.toPath());
                }
            }
            catch (IOException | InvalidPathException e) {
                recording.close();
                throw new RuntimeException("Could not start recording, not able to write to file: " + path, e);
            }
        }
        if (maxAge != null) {
            recording.setMaxAge(Duration.ofNanos(maxAge));
        }
        if (maxSize != null) {
            recording.setMaxSize(maxSize);
        }
        if (duration != null) {
            recording.setDuration(Duration.ofNanos(duration));
        }
        if (dumpOnExit != null) {
            recording.setDumpOnExit(dumpOnExit);
        }
        StringBuilder msg = new StringBuilder();
        if (delay != null) {
            Duration dDelay = Duration.ofNanos(delay);
            recording.scheduleStart(dDelay);
            msg.append("Recording ");
            msg.append(recording.getId());
            msg.append(" scheduled to start in ");
            msg.append(JfrJdkCompatibility.formatTimespan(dDelay, " "));
            msg.append(".");
        } else {
            recording.start();
            msg.append("Started recording ");
            msg.append(recording.getId());
            msg.append(".");
        }
        if (recording.isToDisk() && duration == null && maxAge == null && maxSize == null) {
            msg.append(" No limit specified, using maxsize=250MB as default.");
            recording.setMaxSize(0xFA00000L);
        }
        if (safePath != null && duration != null) {
            msg.append(" The result will be written to:");
            msg.append(System.getProperty("line.separator"));
            msg.append(JfrManager.getPath(safePath));
            msg.append(System.getProperty("line.separator"));
        }
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, msg.toString());
    }

    private static SecuritySupport.SafePath resolvePath(Recording recording, String filename) throws InvalidPathException {
        if (filename == null) {
            return JfrManager.makeGenerated(recording, Paths.get(".", new String[0]));
        }
        Path path = Paths.get(filename, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            return JfrManager.makeGenerated(recording, path);
        }
        return new SecuritySupport.SafePath(path.toAbsolutePath().normalize());
    }

    private static SecuritySupport.SafePath makeGenerated(Recording recording, Path directory) {
        return new SecuritySupport.SafePath(directory.toAbsolutePath().resolve(JfrJdkCompatibility.makeFilename(recording)).normalize());
    }

    private static String getPath(SecuritySupport.SafePath path) {
        if (path == null) {
            return "N/A";
        }
        try {
            return JfrManager.getPath(SecuritySupport.getAbsolutePath(path).toPath());
        }
        catch (IOException ioe) {
            return JfrManager.getPath(path.toPath());
        }
    }

    private static String getPath(Path path) {
        try {
            return path.toAbsolutePath().toString();
        }
        catch (SecurityException e) {
            return path.toString();
        }
    }

    private static Map<JfrArgument, String> parseJfrOptions(RuntimeOptionKey<String> runtimeOptionKey, JfrArgument[] possibleArguments) {
        HashMap<JfrArgument, String> optionsMap = new HashMap<JfrArgument, String>();
        String userInput = runtimeOptionKey.getValue();
        if (!userInput.isEmpty()) {
            String[] options;
            for (String option : options = userInput.split(",")) {
                String[] keyVal = option.split("=");
                JfrArgument arg = JfrManager.findArgument(possibleArguments, keyVal[0]);
                if (arg == null) {
                    throw JfrManager.argumentParsingFailed("Unknown argument '" + keyVal[0] + "' in " + runtimeOptionKey.getName());
                }
                optionsMap.put(arg, keyVal[1]);
            }
        }
        return optionsMap;
    }

    private static String[] parseSettings(Map<JfrArgument, String> args) throws UserError.UserException {
        String settings = args.get(JfrStartArgument.Settings);
        if (settings == null) {
            return new String[]{DEFAULT_JFC_NAME};
        }
        if (settings.equals("none")) {
            return new String[0];
        }
        return settings.split(",");
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="null allowed as return value")
    private static Boolean parseBoolean(Map<JfrArgument, String> args, JfrArgument key) throws IllegalArgumentException {
        String value = args.get(key);
        if (value == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw JfrManager.argumentParsingFailed("Could not parse JFR argument '" + key.getCmdLineKey() + "=" + value + "'. Expected a boolean value.");
    }

    private static Long parseDuration(Map<JfrArgument, String> args, JfrStartArgument key) {
        String value = args.get(key);
        if (value != null) {
            try {
                String unit;
                long time;
                int idx = JfrManager.indexOfFirstNonDigitCharacter(value);
                try {
                    time = Long.parseLong(value.substring(0, idx));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Expected a number.");
                }
                if (idx == value.length()) {
                    if (time != 0L) {
                        throw new IllegalArgumentException("Unit is required.");
                    }
                    return 0L;
                }
                return switch (unit = value.substring(idx)) {
                    case "ns" -> Duration.ofNanos(time).toNanos();
                    case "us" -> Duration.ofNanos(time * 1000L).toNanos();
                    case "ms" -> Duration.ofMillis(time).toNanos();
                    case "s" -> Duration.ofSeconds(time).toNanos();
                    case "m" -> Duration.ofMinutes(time).toNanos();
                    case "h" -> Duration.ofHours(time).toNanos();
                    case "d" -> Duration.ofDays(time).toNanos();
                    default -> throw new IllegalArgumentException("Unit is invalid.");
                };
            }
            catch (IllegalArgumentException e) {
                throw JfrManager.argumentParsingFailed("Could not parse JFR argument '" + key.cmdLineKey + "=" + value + "'. " + e.getMessage());
            }
        }
        return null;
    }

    private static Integer parseInteger(Map<JfrArgument, String> args, JfrArgument key) {
        String value = args.get(key);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (Throwable e) {
                throw JfrManager.argumentParsingFailed("Could not parse JFR argument '" + key.getCmdLineKey() + "=" + value + "'. " + e.getMessage());
            }
        }
        return null;
    }

    private static Long parseMaxSize(Map<JfrArgument, String> args, JfrArgument key) {
        String value = args.get(key);
        if (value == null) {
            return null;
        }
        try {
            long number;
            int idx = JfrManager.indexOfFirstNonDigitCharacter(value);
            try {
                number = Long.parseLong(value.substring(0, idx));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected a positive number.");
            }
            if (idx == value.length()) {
                return number;
            }
            char unit = value.substring(idx).charAt(0);
            return switch (unit) {
                case 'K', 'k' -> number * 1024L;
                case 'M', 'm' -> number * 1024L * 1024L;
                case 'G', 'g' -> number * 1024L * 1024L * 1024L;
                default -> number;
            };
        }
        catch (IllegalArgumentException e) {
            throw JfrManager.argumentParsingFailed("Could not parse JFR argument '" + key.getCmdLineKey() + "=" + value + "'. " + e.getMessage());
        }
    }

    private static int indexOfFirstNonDigitCharacter(String durationText) {
        int idx;
        for (idx = 0; idx < durationText.length() && Character.isDigit(durationText.charAt(idx)); ++idx) {
        }
        return idx;
    }

    private static JfrArgument findArgument(JfrArgument[] possibleArguments, String value) {
        for (JfrArgument arg : possibleArguments) {
            if (!arg.getCmdLineKey().equals(value)) continue;
            return arg;
        }
        return null;
    }

    private static RuntimeException argumentParsingFailed(String message) {
        throw new JfrArgumentParsingFailed(message);
    }

    private static RuntimeException argumentParsingFailed(String message, Throwable cause) {
        throw new JfrArgumentParsingFailed(message, cause);
    }

    private static enum FlightRecorderOptionsArgument implements JfrArgument
    {
        GlobalBufferSize("globalbuffersize"),
        MaxChunkSize("maxchunksize"),
        MemorySize("memorysize"),
        OldObjectQueueSize("old-object-queue-size"),
        RepositoryPath("repository"),
        StackDepth("stackdepth"),
        ThreadBufferSize("threadbuffersize"),
        PreserveRepository("preserve-repository");

        private final String cmdLineKey;

        private FlightRecorderOptionsArgument(String key) {
            this.cmdLineKey = key;
        }

        @Override
        public String getCmdLineKey() {
            return this.cmdLineKey;
        }
    }

    private static interface JfrArgument {
        public String getCmdLineKey();
    }

    private static enum JfrStartArgument implements JfrArgument
    {
        Name("name"),
        Settings("settings"),
        Delay("delay"),
        Duration("duration"),
        Filename("filename"),
        Disk("disk"),
        MaxAge("maxage"),
        MaxSize("maxsize"),
        DumpOnExit("dumponexit"),
        PathToGCRoots("path-to-gc-roots");

        private final String cmdLineKey;

        private JfrStartArgument(String key) {
            this.cmdLineKey = key;
        }

        @Override
        public String getCmdLineKey() {
            return this.cmdLineKey;
        }
    }

    private static class JfrArgumentParsingFailed
    extends RuntimeException {
        private static final long serialVersionUID = -1050173145647068124L;

        JfrArgumentParsingFailed(String message, Throwable cause) {
            super(message, cause);
        }

        JfrArgumentParsingFailed(String message) {
            super(message);
        }
    }
}

