/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.jdk.resources.MissingResourceRegistrationError;
import java.nio.file.Files;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.internal.loader.Loader;

public final class MissingResourceRegistrationUtils {
    private static final Map<String, Set<String>> resourceEntryPoints = Map.of(ClassLoader.class.getTypeName(), Set.of("getResource", "getResources", "getSystemResource", "getSystemResources"), BuiltinClassLoader.class.getTypeName(), Set.of("findResource", "findResourceAsStream"), Loader.class.getTypeName(), Set.of("findResource"), ResourceBundle.class.getTypeName(), Set.of("getBundleImpl"), Module.class.getTypeName(), Set.of("getResourceAsStream"), Class.class.getTypeName(), Set.of("getResource", "getResourceAsStream"), Files.class.getTypeName(), Set.of("walk", "getFileStore", "readAttributes", "setAttribute", "newByteChannel", "newOutputStream", "newInputStream", "createDirectory", "move", "copy", "newDirectoryStream", "delete"), FileSystemProvider.class.getTypeName(), Set.of("newFileChannel"));

    public static void missingResource(String resourcePath) {
        MissingResourceRegistrationError exception = new MissingResourceRegistrationError(MissingResourceRegistrationUtils.errorMessage("resource at path", resourcePath), resourcePath);
        MissingResourceRegistrationUtils.report(exception);
    }

    public static void missingResourceBundle(String baseName) {
        MissingResourceRegistrationError exception = new MissingResourceRegistrationError(MissingResourceRegistrationUtils.errorMessage("resource bundle with name", baseName), baseName);
        MissingResourceRegistrationUtils.report(exception);
    }

    private static String errorMessage(String type, String resourcePath) {
        return "The program tried to access the " + type + System.lineSeparator() + System.lineSeparator() + "   " + resourcePath + System.lineSeparator() + System.lineSeparator() + "without it being registered as reachable. Add it to the resource metadata to solve this problem. See https://www.graalvm.org/latest/reference-manual/native-image/metadata/#resources-and-resource-bundles for help";
    }

    private static void report(MissingResourceRegistrationError exception) {
        StackTraceElement responsibleClass = MissingResourceRegistrationUtils.getResponsibleClass(exception);
        MissingRegistrationUtils.report(exception, responsibleClass);
    }

    private static StackTraceElement getResponsibleClass(Throwable t) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = t.getStackTrace()) {
            if (!resourceEntryPoints.getOrDefault(stackTraceElement.getClassName(), Set.of()).contains(stackTraceElement.getMethodName())) continue;
            return stackTraceElement;
        }
        return null;
    }
}

