/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.proxy;

import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.jdk.proxy.Target_jdk_internal_loader_AbstractClassLoaderValue_Sub;
import com.oracle.svm.core.jdk.proxy.Target_jdk_internal_loader_ClassLoaderValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=Proxy.class)
final class Target_java_lang_reflect_Proxy {
    @Delete
    private static Target_jdk_internal_loader_ClassLoaderValue proxyCache;

    Target_java_lang_reflect_Proxy() {
    }

    @Substitute
    private static Constructor<?> getProxyConstructor(Class<?> caller, ClassLoader loader, Class<?> ... interfaces) {
        Class<?> cl = ((DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class)).getProxyClass(loader, interfaces);
        try {
            Constructor<?> cons = cl.getConstructor(InvocationHandler.class);
            cons.setAccessible(true);
            return cons;
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString(), e);
        }
    }

    @Delete
    @TargetElement(name="lambda$getProxyConstructor$0")
    private static native Constructor<?> lambdaGetProxyConstructor0(ClassLoader var0, Target_jdk_internal_loader_AbstractClassLoaderValue_Sub var1);

    @Delete
    @TargetElement(name="lambda$getProxyConstructor$1")
    private static native Constructor<?> lambdaGetProxyConstructor1(ClassLoader var0, Target_jdk_internal_loader_AbstractClassLoaderValue_Sub var1);

    @Substitute
    public static boolean isProxyClass(Class<?> cl) {
        return DynamicHub.fromClass(cl).isProxyClass();
    }
}

