/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap.dump;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.heap.dump.HeapDumpMetadata;
import com.oracle.svm.core.heap.dump.HeapDumpWriter;
import com.oracle.svm.core.heap.dump.HeapDumping;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.memory.UntrackedNullableNativeMemory;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.thread.NativeVMOperation;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperation;
import java.io.IOException;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class HeapDumpSupportImpl
extends HeapDumping {
    private final HeapDumpWriter writer;
    private final HeapDumpOperation heapDumpOperation;
    private final VMMutex outOfMemoryHeapDumpMutex = new VMMutex("outOfMemoryHeapDump");
    private CCharPointer outOfMemoryHeapDumpPath;
    private boolean outOfMemoryHeapDumpAttempted;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapDumpSupportImpl(HeapDumpMetadata metadata) {
        this.writer = new HeapDumpWriter(metadata);
        this.heapDumpOperation = new HeapDumpOperation();
    }

    @Override
    public void initializeDumpHeapOnOutOfMemoryError() {
        assert (this.outOfMemoryHeapDumpPath.isNull());
        String defaultFilename = HeapDumpSupportImpl.getDefaultHeapDumpFilename("OOME");
        String heapDumpPath = HeapDumpSupportImpl.getHeapDumpPath(defaultFilename);
        this.outOfMemoryHeapDumpPath = HeapDumpSupportImpl.getFileSupport().allocateCPath(heapDumpPath);
    }

    @Override
    public void teardownDumpHeapOnOutOfMemoryError() {
        UntrackedNullableNativeMemory.free((PointerBase)this.outOfMemoryHeapDumpPath);
        this.outOfMemoryHeapDumpPath = (CCharPointer)WordFactory.nullPointer();
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="OutOfMemoryError heap dumping must not allocate.")
    public void dumpHeapOnOutOfMemoryError() {
        this.outOfMemoryHeapDumpMutex.lock();
        try {
            if (!this.outOfMemoryHeapDumpAttempted) {
                this.dumpHeapOnOutOfMemoryError0();
                this.outOfMemoryHeapDumpAttempted = true;
            }
        }
        finally {
            this.outOfMemoryHeapDumpMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpHeapOnOutOfMemoryError0() {
        CCharPointer path = this.outOfMemoryHeapDumpPath;
        if (path.isNull()) {
            Log.log().string("OutOfMemoryError heap dumping failed because the heap dump file path could not be allocated.").newline();
            return;
        }
        RawFileOperationSupport.RawFileDescriptor fd = HeapDumpSupportImpl.getFileSupport().create(path, RawFileOperationSupport.FileCreationMode.CREATE_OR_REPLACE, RawFileOperationSupport.FileAccessMode.READ_WRITE);
        if (!HeapDumpSupportImpl.getFileSupport().isValid(fd)) {
            Log.log().string("OutOfMemoryError heap dumping failed because the heap dump file could not be created: ").string(path).newline();
            return;
        }
        try {
            Log.log().string("Dumping heap to ").string(path).string(" ...").newline();
            long start = System.currentTimeMillis();
            if (this.dumpHeap(fd, false)) {
                long fileSize = HeapDumpSupportImpl.getFileSupport().size(fd);
                long elapsedMs = System.currentTimeMillis() - start;
                long seconds = elapsedMs / 1000L;
                long ms = elapsedMs % 1000L;
                Log.log().string("Heap dump file created [").signed(fileSize).string(" bytes in ").signed(seconds).character('.').signed(ms).string(" secs]").newline();
            }
        }
        finally {
            HeapDumpSupportImpl.getFileSupport().close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpHeap(String filename, boolean gcBefore) throws IOException {
        RawFileOperationSupport.RawFileDescriptor fd = HeapDumpSupportImpl.getFileSupport().create(filename, RawFileOperationSupport.FileCreationMode.CREATE_OR_REPLACE, RawFileOperationSupport.FileAccessMode.READ_WRITE);
        if (!HeapDumpSupportImpl.getFileSupport().isValid(fd)) {
            throw new IOException("Could not create the heap dump file: " + filename);
        }
        try {
            this.writeHeapTo(fd, gcBefore);
        }
        finally {
            HeapDumpSupportImpl.getFileSupport().close(fd);
        }
    }

    private boolean dumpHeap(RawFileOperationSupport.RawFileDescriptor fd, boolean gcBefore) {
        int size = SizeOf.get(HeapDumpVMOperationData.class);
        HeapDumpVMOperationData data = (HeapDumpVMOperationData)StackValue.get((int)size);
        UnmanagedMemoryUtil.fill((Pointer)data, WordFactory.unsigned((int)size), (byte)0);
        data.setGCBefore(gcBefore);
        data.setRawFileDescriptor(fd);
        this.heapDumpOperation.enqueue(data);
        return data.getSuccess();
    }

    public void writeHeapTo(RawFileOperationSupport.RawFileDescriptor fd, boolean gcBefore) throws IOException {
        boolean success = this.dumpHeap(fd, gcBefore);
        if (!success) {
            throw new IOException("An error occurred while writing the heap dump.");
        }
    }

    @Fold
    static RawFileOperationSupport getFileSupport() {
        return RawFileOperationSupport.bigEndian();
    }

    private class HeapDumpOperation
    extends NativeVMOperation {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        HeapDumpOperation() {
            super(VMOperationInfos.get(HeapDumpOperation.class, "Write heap dump", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Heap dumping must not allocate.")
        protected void operate(NativeVMOperationData d) {
            HeapDumpVMOperationData data = (HeapDumpVMOperationData)d;
            if (data.getGCBefore()) {
                Heap.getHeap().getGC().collectCompletely(GCCause.HeapDump);
            }
            try {
                boolean success = HeapDumpSupportImpl.this.writer.dumpHeap(data.getRawFileDescriptor());
                data.setSuccess(success);
            }
            catch (Throwable e) {
                Log.log().string("An exception occurred during heap dumping. The data in the heap dump file may be corrupt: ").string(e.getClass().getName()).newline();
                data.setSuccess(false);
            }
        }
    }

    @RawStructure
    private static interface HeapDumpVMOperationData
    extends NativeVMOperationData {
        @RawField
        public boolean getGCBefore();

        @RawField
        public void setGCBefore(boolean var1);

        @RawField
        public RawFileOperationSupport.RawFileDescriptor getRawFileDescriptor();

        @RawField
        public void setRawFileDescriptor(RawFileOperationSupport.RawFileDescriptor var1);

        @RawField
        public boolean getSuccess();

        @RawField
        public void setSuccess(boolean var1);
    }
}

