/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.graal.amd64.FramePointerPhase;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64Backend;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.FinalCodeAnalysisPhase;
import jdk.vm.ci.code.TargetDescription;

class VerifyFramePointerPhase
extends FinalCodeAnalysisPhase {
    VerifyFramePointerPhase() {
    }

    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, FinalCodeAnalysisPhase.FinalCodeAnalysisContext context) {
        LIR lir = lirGenRes.getLIR();
        for (int blockId : lir.getBlocks()) {
            if (LIR.isBlockDeleted((int)blockId)) continue;
            BasicBlock block = lir.getBlockById(blockId);
            for (LIRInstruction op : lir.getLIRforBlock(block)) {
                if (!op.modifiesStackPointer()) continue;
                SubstrateAMD64Backend.SubstrateAMD64RegisterAllocationConfig registerAllocationConfig = (SubstrateAMD64Backend.SubstrateAMD64RegisterAllocationConfig)lirGenRes.getRegisterAllocationConfig();
                SubstrateAMD64Backend.SubstrateAMD64FrameMap frameMap = (SubstrateAMD64Backend.SubstrateAMD64FrameMap)lirGenRes.getFrameMap();
                if (registerAllocationConfig.preserveFramePointer() && frameMap.needsFramePointer()) {
                    return;
                }
                throw VMError.shouldNotReachHere("The following instruction modifies the stack pointer, but was added after " + FramePointerPhase.class.getSimpleName() + ": " + String.valueOf(op));
            }
        }
    }
}

