/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.graal.meta.SubstrateBasicLoweringProvider;
import com.oracle.svm.core.graal.nodes.aarch64.AArch64ISBNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.nodes.CodeSynchronizationNode;
import jdk.graal.compiler.core.aarch64.AArch64LoweringProviderMixin;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.calc.FloatConvertNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.PlatformConfigurationProvider;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.MetaAccessProvider;

public class SubstrateAArch64LoweringProvider
extends SubstrateBasicLoweringProvider
implements AArch64LoweringProviderMixin {
    public SubstrateAArch64LoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        super(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, target);
    }

    @Override
    public void lower(Node n, LoweringTool tool) {
        NodeLoweringProvider<?> lowering = this.getLowerings().get(n.getClass());
        if (lowering != null) {
            lowering.lower(n, tool);
        } else if (!(n instanceof FloatConvertNode)) {
            if (n instanceof CodeSynchronizationNode) {
                this.lowerCodeSynchronizationNode((CodeSynchronizationNode)n);
            } else {
                super.lower(n, tool);
            }
        }
    }

    public void lowerCodeSynchronizationNode(CodeSynchronizationNode node) {
        StructuredGraph graph = node.graph();
        try (DebugCloseable position = node.withNodeSourcePosition();){
            AArch64ISBNode replacement = (AArch64ISBNode)graph.add((Node)new AArch64ISBNode());
            graph.replaceFixed((FixedWithNextNode)node, (Node)replacement);
        }
    }
}

