/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.thread;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.nodes.ReadReservedRegister;
import com.oracle.svm.core.graal.thread.AddressOfVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.CompareAndSetVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.LoadVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.StoreVMThreadLocalNode;
import com.oracle.svm.core.heap.InstanceReferenceMapEncoder;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfos;
import com.oracle.svm.core.threadlocal.VMThreadLocalSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.thread.VMThreadLocalCollector;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredFeature
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
public class VMThreadFeature
implements InternalFeature {
    private final VMThreadLocalCollector threadLocalCollector = new VMThreadLocalCollector();
    private final VMThreadLocalSupport threadLocalSupport = new VMThreadLocalSupport();

    public void duringSetup(Feature.DuringSetupAccess config) {
        ImageSingletons.add(VMThreadLocalSupport.class, (Object)this.threadLocalSupport);
        config.registerObjectReplacer((Function)this.threadLocalCollector);
    }

    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        Class[] typesWithGetAddress;
        for (Class<? extends FastThreadLocal> threadLocalClass : VMThreadLocalInfo.THREAD_LOCAL_CLASSES) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), threadLocalClass);
            Class<?> valueClass = VMThreadLocalInfo.getValueClass(threadLocalClass);
            this.registerAccessors(r, valueClass, false);
            this.registerAccessors(r, valueClass, true);
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("compareAndSet", new Type[]{InvocationPlugin.Receiver.class, valueClass, valueClass}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode expect, ValueNode update) {
                    ValueNode threadNode = VMThreadFeature.currentThread(b);
                    return VMThreadFeature.this.handleCompareAndSet(b, targetMethod, receiver, threadNode, expect, update);
                }
            });
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("compareAndSet", new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class, valueClass, valueClass}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode expect, ValueNode update) {
                    return VMThreadFeature.this.handleCompareAndSet(b, targetMethod, receiver, threadNode, expect, update);
                }
            });
        }
        for (Class type : typesWithGetAddress = new Class[]{FastThreadLocalBytes.class, FastThreadLocalWord.class}) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), (Type)type);
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getAddress", new Type[]{InvocationPlugin.Receiver.class}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode threadNode = VMThreadFeature.currentThread(b);
                    return VMThreadFeature.this.handleGetAddress(b, targetMethod, receiver, threadNode);
                }
            });
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getAddress", new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode) {
                    return VMThreadFeature.this.handleGetAddress(b, targetMethod, receiver, threadNode);
                }
            });
        }
    }

    private void registerAccessors(InvocationPlugins.Registration r, Class<?> valueClass, final boolean isVolatile) {
        String suffix = isVolatile ? "Volatile" : "";
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "get" + suffix, new Type[]{InvocationPlugin.Receiver.class}){
            final /* synthetic */ VMThreadFeature this$0;
            {
                this.this$0 = this$0;
                super(name, argumentTypes);
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode threadNode = VMThreadFeature.currentThread(b);
                return this.this$0.handleGet(b, targetMethod, receiver, threadNode, isVolatile);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "get" + suffix, new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class}){
            final /* synthetic */ VMThreadFeature this$0;
            {
                this.this$0 = this$0;
                super(name, argumentTypes);
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode) {
                return this.this$0.handleGet(b, targetMethod, receiver, threadNode, isVolatile);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "set" + suffix, new Type[]{InvocationPlugin.Receiver.class, valueClass}){
            final /* synthetic */ VMThreadFeature this$0;
            {
                this.this$0 = this$0;
                super(name, argumentTypes);
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode valueNode) {
                ValueNode threadNode = VMThreadFeature.currentThread(b);
                return this.this$0.handleSet(b, receiver, threadNode, valueNode, isVolatile);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "set" + suffix, new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class, valueClass}){
            final /* synthetic */ VMThreadFeature this$0;
            {
                this.this$0 = this$0;
                super(name, argumentTypes);
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode valueNode) {
                return this.this$0.handleSet(b, receiver, threadNode, valueNode, isVolatile);
            }
        });
    }

    private static ValueNode currentThread(GraphBuilderContext b) {
        return (ValueNode)b.add((Node)ReadReservedRegister.createReadIsolateThreadNode(b.getGraph()));
    }

    private boolean handleGet(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, boolean isVolatile) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, receiver.get(true));
        LoadVMThreadLocalNode node = new LoadVMThreadLocalNode(b.getMetaAccess(), threadLocalInfo, threadNode, BarrierType.NONE, isVolatile ? MemoryOrderMode.VOLATILE : MemoryOrderMode.PLAIN);
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)node);
        return true;
    }

    private boolean handleSet(GraphBuilderContext b, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode valueNode, boolean isVolatile) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, receiver.get(true));
        StoreVMThreadLocalNode store = (StoreVMThreadLocalNode)b.add((Node)new StoreVMThreadLocalNode(threadLocalInfo, threadNode, valueNode, BarrierType.NONE, isVolatile ? MemoryOrderMode.VOLATILE : MemoryOrderMode.PLAIN));
        assert (store.stateAfter() != null) : String.valueOf(store) + " has no state after with graph builder context " + String.valueOf(b);
        return true;
    }

    private boolean handleCompareAndSet(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode expect, ValueNode update) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, receiver.get(true));
        CompareAndSetVMThreadLocalNode cas = new CompareAndSetVMThreadLocalNode(threadLocalInfo, threadNode, expect, update);
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)cas);
        assert (cas.stateAfter() != null) : String.valueOf(cas) + " has no state after with graph builder context " + String.valueOf(b);
        return true;
    }

    private boolean handleGetAddress(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, receiver.get(true));
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)new AddressOfVMThreadLocalNode(threadLocalInfo, threadNode));
        return true;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess config) {
        List<VMThreadLocalInfo> sortedThreadLocalInfos = this.threadLocalCollector.sortThreadLocals();
        SubstrateReferenceMap referenceMap = new SubstrateReferenceMap();
        int nextOffset = 0;
        for (VMThreadLocalInfo info : sortedThreadLocalInfos) {
            int alignment = Math.min(8, info.sizeInBytes);
            nextOffset = NumUtil.roundUp((int)nextOffset, (int)alignment);
            if (info.isObject) {
                referenceMap.markReferenceAtOffset(nextOffset, true);
            }
            info.offset = nextOffset;
            nextOffset += info.sizeInBytes;
            if (info.offset <= info.maxOffset) continue;
            VMError.shouldNotReachHere("Too many thread local variables with maximum offset " + info.maxOffset + " defined");
        }
        InstanceReferenceMapEncoder encoder = new InstanceReferenceMapEncoder();
        encoder.add(referenceMap);
        NonmovableArray<Byte> referenceMapEncoding = encoder.encodeAll();
        this.threadLocalSupport.vmThreadReferenceMapEncoding = (byte[])NonmovableArrays.getHostedArray(referenceMapEncoding);
        this.threadLocalSupport.vmThreadReferenceMapIndex = encoder.lookupEncoding(referenceMap);
        this.threadLocalSupport.vmThreadSize = nextOffset;
        VMThreadLocalInfos.setInfos(sortedThreadLocalInfos);
    }

    public int offsetOf(FastThreadLocal threadLocal) {
        return this.threadLocalCollector.getInfo((FastThreadLocal)threadLocal).offset;
    }
}

