/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public class EarlyConstantFoldLoadFieldPlugin
implements NodePlugin {
    private final Map<ResolvedJavaType, ResolvedJavaType> primitiveTypes = new HashMap<ResolvedJavaType, ResolvedJavaType>();
    private static final String SYNTHETIC_ASSERTIONS_DISABLED_FIELD_NAME = "$assertionsDisabled";

    public EarlyConstantFoldLoadFieldPlugin(MetaAccessProvider metaAccess) {
        for (JavaKind kind : JavaKind.values()) {
            if (kind.toBoxedJavaClass() == null) continue;
            this.primitiveTypes.put(metaAccess.lookupJavaType(kind.toBoxedJavaClass()), metaAccess.lookupJavaType(kind.toJavaClass()));
        }
    }

    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField field) {
        ResolvedJavaType primitiveType;
        if (field.isSynthetic() && field.getName().startsWith(SYNTHETIC_ASSERTIONS_DISABLED_FIELD_NAME)) {
            Class javaClass = OriginalClassProvider.getJavaClass((JavaType)field.getDeclaringClass());
            boolean assertionsEnabled = RuntimeAssertionsSupport.singleton().desiredAssertionStatus(javaClass);
            b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((!assertionsEnabled ? 1 : 0) != 0));
            return true;
        }
        if (field.getName().equals("TYPE") && (primitiveType = this.primitiveTypes.get(field.getDeclaringClass())) != null) {
            b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getConstantReflection().asJavaClass(primitiveType), (MetaAccessProvider)b.getMetaAccess()));
            return true;
        }
        return false;
    }
}

