/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class HostedSnippetReflectionProvider
implements SnippetReflectionProvider {
    private ImageHeapScanner heapScanner;
    private final WordTypes wordTypes;

    public HostedSnippetReflectionProvider(ImageHeapScanner heapScanner, WordTypes wordTypes) {
        this.heapScanner = heapScanner;
        this.wordTypes = wordTypes;
    }

    public void setHeapScanner(ImageHeapScanner heapScanner) {
        this.heapScanner = heapScanner;
    }

    public JavaConstant forObject(Object object) {
        return this.heapScanner.createImageHeapConstant(object, ObjectScanner.OtherReason.UNKNOWN);
    }

    public JavaConstant forBoxed(JavaKind kind, Object value) {
        if (kind == JavaKind.Object) {
            return this.forObject(value);
        }
        return JavaConstant.forBoxedPrimitive((Object)value);
    }

    public <T> T asObject(Class<T> type, JavaConstant c) {
        Object object;
        ImageHeapConstant imageHeapConstant;
        JavaConstant constant = c;
        if (constant instanceof ImageHeapConstant && (constant = (imageHeapConstant = (ImageHeapConstant)constant).getHostedObject()) == null) {
            return null;
        }
        if (type == Class.class && constant instanceof HotSpotObjectConstant && (object = this.heapScanner.getHostedValuesProvider().asObject(Object.class, constant)) instanceof DynamicHub) {
            DynamicHub hub = (DynamicHub)object;
            return type.cast(hub.getHostedJavaClass());
        }
        VMError.guarantee(!(constant instanceof SubstrateObjectConstant));
        return (T)this.heapScanner.getHostedValuesProvider().asObject(type, constant);
    }

    public <T> T getInjectedNodeIntrinsicParameter(Class<T> type) {
        if (type.isAssignableFrom(WordTypes.class)) {
            return type.cast(this.wordTypes);
        }
        return null;
    }

    public Class<?> originalClass(ResolvedJavaType type) {
        throw VMError.intentionallyUnimplemented();
    }

    public Executable originalMethod(ResolvedJavaMethod method) {
        throw VMError.intentionallyUnimplemented();
    }

    public Field originalField(ResolvedJavaField field) {
        throw VMError.intentionallyUnimplemented();
    }
}

