/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.lambda;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.graal.pointsto.phases.NoClassInitializationPlugin;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.hosted.lambda.LambdaSubstitutionType;
import com.oracle.svm.hosted.lambda.LambdaSubstrateGraphBuilderPhase;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.vm.ci.meta.ResolvedJavaType;

public class LambdaProxyRenamingSubstitutionProcessor
extends SubstitutionProcessor {
    private final BigBang bb;
    private final ConcurrentHashMap<ResolvedJavaType, LambdaSubstitutionType> typeSubstitutions = new ConcurrentHashMap();
    private final Set<String> uniqueLambdaProxyNames = new HashSet<String>();

    LambdaProxyRenamingSubstitutionProcessor(BigBang bb) {
        this.bb = bb;
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (LambdaUtils.isLambdaType((ResolvedJavaType)type) && !type.getClass().equals(LambdaSubstitutionType.class) && !type.getClass().equals(BaseLayerType.class)) {
            return this.getSubstitution(type);
        }
        return type;
    }

    private LambdaSubstitutionType getSubstitution(ResolvedJavaType original) {
        return this.typeSubstitutions.computeIfAbsent(original, key -> {
            OptionValues options = this.bb.getOptions();
            DebugContext debug = new DebugContext.Builder(options, (DebugHandlersFactory)new GraalDebugHandlersFactory(this.bb.getSnippetReflectionProvider())).build();
            Providers providers = GraalAccess.getOriginalProviders();
            String lambdaTargetName = LambdaUtils.findStableLambdaName((ClassInitializationPlugin)new NoClassInitializationPlugin(), (Providers)providers, (ResolvedJavaType)key, (OptionValues)options, (DebugContext)debug, (Object)((Object)this), config -> new LambdaSubstrateGraphBuilderPhase.LambdaSubstrateGraphBuilderInstance((CoreProviders)providers, (GraphBuilderConfiguration)config, OptimisticOptimizations.NONE, null));
            return new LambdaSubstitutionType((ResolvedJavaType)key, this.findUniqueLambdaProxyName(lambdaTargetName));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findUniqueLambdaProxyName(String lambdaTargetName) {
        Set<String> set = this.uniqueLambdaProxyNames;
        synchronized (set) {
            String stableNameBase = lambdaTargetName.substring(0, lambdaTargetName.length() - 1);
            String newStableName = stableNameBase + "0;";
            int i = 1;
            while (this.uniqueLambdaProxyNames.contains(newStableName)) {
                newStableName = stableNameBase + i + ";";
                ++i;
            }
            this.uniqueLambdaProxyNames.add(newStableName);
            return newStableName;
        }
    }

    public boolean isNameAlwaysStable(String lambdaTargetName) {
        return !this.uniqueLambdaProxyNames.contains(lambdaTargetName.substring(0, lambdaTargetName.length() - 1) + "1;");
    }
}

