/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jdk.management.ManagementAgentStartupHook;
import com.oracle.svm.core.jdk.management.ManagementSupport;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.management.PlatformManagedObject;
import java.lang.reflect.Executable;
import java.util.Set;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

@AutomaticallyRegisteredFeature
public class JmxServerFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return VMInspectionOptions.hasJmxServerSupport();
    }

    private static void handleNativeLibraries(Feature.BeforeAnalysisAccess access) {
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("management_agent");
        FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccess = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        beforeAnalysisAccess.getNativeLibraries().addStaticJniLibrary("management_agent", new String[0]);
        PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("jdk_internal_agent");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        JmxServerFeature.handleNativeLibraries(access);
        JmxServerFeature.registerJMXAgentResources();
        JmxServerFeature.configureReflection(access);
        JmxServerFeature.configureProxy(access);
        RuntimeSupport.getRuntimeSupport().addStartupHook(new ManagementAgentStartupHook());
    }

    private static void registerJMXAgentResources() {
        ResourcesRegistry<ConfigurationCondition> resourcesRegistry = ResourcesRegistry.singleton();
        resourcesRegistry.addResourceBundles(ConfigurationCondition.alwaysTrue(), "jdk.internal.agent.resources.agent");
        resourcesRegistry.addResourceBundles(ConfigurationCondition.alwaysTrue(), "sun.security.util.Resources");
    }

    private static void configureProxy(Feature.BeforeAnalysisAccess access) {
        DynamicProxyRegistry dynamicProxySupport = (DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class);
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.rmi.Remote"), access.findClassByName("java.rmi.registry.Registry")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("javax.management.remote.rmi.RMIServer")});
    }

    private static void configureReflection(Feature.BeforeAnalysisAccess access) {
        Set<PlatformManagedObject> platformManagedObjects = ManagementSupport.getSingleton().getPlatformManagedObjects();
        for (PlatformManagedObject p : platformManagedObjects) {
            if (p instanceof ManagementSupport.PlatformManagedObjectSupplier) continue;
            Class<?> clazz = p.getClass();
            RuntimeReflection.register((Class[])new Class[]{clazz});
        }
        RuntimeReflection.register((Class[])new Class[]{access.findClassByName("com.sun.jmx.remote.protocol.rmi.ServerProvider")});
        RuntimeReflection.register((Executable[])access.findClassByName("com.sun.jmx.remote.protocol.rmi.ServerProvider").getConstructors());
    }
}

