/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.hosted.heap.SVMImageLayerLoader;
import com.oracle.svm.hosted.heap.SVMImageLayerWriter;
import org.graalvm.nativeimage.ImageSingletons;

public final class HostedImageLayerBuildingSupport
extends ImageLayerBuildingSupport {
    private final SVMImageLayerLoader loader;
    private final SVMImageLayerWriter writer;

    private HostedImageLayerBuildingSupport(SVMImageLayerLoader loader, SVMImageLayerWriter writer, boolean buildingImageLayer, boolean buildingInitialLayer, boolean buildingApplicationLayer) {
        super(buildingImageLayer, buildingInitialLayer, buildingApplicationLayer);
        this.loader = loader;
        this.writer = writer;
    }

    public static HostedImageLayerBuildingSupport singleton() {
        return (HostedImageLayerBuildingSupport)ImageSingletons.lookup(ImageLayerBuildingSupport.class);
    }

    public SVMImageLayerLoader getLoader() {
        return this.loader;
    }

    public SVMImageLayerWriter getWriter() {
        return this.writer;
    }

    public static HostedImageLayerBuildingSupport initialize(HostedOptionValues values) {
        SVMImageLayerWriter writer = null;
        if (((Boolean)SubstrateOptions.ImageLayer.getValue(values)).booleanValue()) {
            writer = new SVMImageLayerWriter();
        }
        SVMImageLayerLoader loader = null;
        if (SubstrateOptions.LoadImageLayer.hasBeenSet(values)) {
            loader = new SVMImageLayerLoader(((LocatableMultiOptionValue.Paths)SubstrateOptions.LoadImageLayer.getValue(values)).values());
        }
        boolean buildingImageLayer = loader != null || writer != null;
        boolean buildingInitialLayer = buildingImageLayer && loader == null;
        boolean buildingFinalLayer = buildingImageLayer && writer == null;
        return new HostedImageLayerBuildingSupport(loader, writer, buildingImageLayer, buildingInitialLayer, buildingFinalLayer);
    }
}

