/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.imagelayer.DynamicImageLayerInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.debug.Assertions;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.PointerBase;

public class HostedDynamicLayerInfo
extends DynamicImageLayerInfo
implements LayeredImageSingleton {
    private final Map<Integer, Integer> methodIdToOffsetMap;
    private final CGlobalData<PointerBase> cGlobalData;

    HostedDynamicLayerInfo() {
        this(0, null, new HashMap<Integer, Integer>());
    }

    public static HostedDynamicLayerInfo singleton() {
        return (HostedDynamicLayerInfo)ImageSingletons.lookup(DynamicImageLayerInfo.class);
    }

    private HostedDynamicLayerInfo(int layerNumber, String codeSectionStartSymbol, Map<Integer, Integer> methodIdToOffsetMap) {
        super(layerNumber);
        this.methodIdToOffsetMap = methodIdToOffsetMap;
        this.cGlobalData = codeSectionStartSymbol == null ? null : CGlobalDataFactory.forSymbol(codeSectionStartSymbol);
    }

    @Override
    public Pair<CGlobalDataInfo, Integer> getPriorLayerMethodLocation(SharedMethod sMethod) {
        assert (ImageLayerBuildingSupport.buildingExtensionLayer()) : "This should only be called within extension images. Within the initial layer the direct calls can be performed";
        HostedMethod method = (HostedMethod)sMethod;
        assert (method.wrapped.isInBaseLayer() && this.methodIdToOffsetMap.containsKey(method.getWrapped().getId())) : method;
        CGlobalDataInfo basePointer = CGlobalDataFeature.singleton().registerAsAccessedOrGet(this.cGlobalData);
        Integer offset = this.methodIdToOffsetMap.get(method.getWrapped().getId());
        return Pair.create((Object)basePointer, (Object)offset);
    }

    void registerOffset(HostedMethod method) {
        int offset = method.getCodeAddressOffset();
        int methodID = method.getWrapped().getId();
        assert (!this.methodIdToOffsetMap.containsKey(methodID)) : Assertions.errorMessage((Object[])new Object[]{"Duplicate entry", methodID, offset});
        this.methodIdToOffsetMap.put(methodID, offset);
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    boolean verifyUniqueOffsets(Collection<? extends SharedMethod> methods) {
        BitSet seenOffsets = new BitSet();
        for (Map.Entry<Integer, Integer> entry : this.methodIdToOffsetMap.entrySet()) {
            if (seenOffsets.get(entry.getValue())) {
                Optional<SharedMethod> method = methods.stream().filter(m -> ((HostedMethod)m).getWrapped().getId() == ((Integer)entry.getKey()).intValue()).findAny();
                assert (false) : Assertions.errorMessage((Object[])new Object[]{"Value has already been found", method, entry.getKey(), entry.getValue()});
            }
            seenOffsets.set(entry.getValue());
        }
        return true;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        assert (ImageLayerBuildingSupport.buildingInitialLayer()) : "This code must be adjusted to support multiple shared layers";
        writer.writeInt("nextLayerNumber", this.nextLayerNumber);
        writer.writeString("codeSectionStartSymbol", NativeImage.getTextSectionStartSymbol());
        ArrayList<Integer> offsets = new ArrayList<Integer>(this.methodIdToOffsetMap.size());
        ArrayList<Integer> methodIDs = new ArrayList<Integer>(this.methodIdToOffsetMap.size());
        this.methodIdToOffsetMap.forEach((key, value) -> {
            methodIDs.add((Integer)key);
            offsets.add((Integer)value);
        });
        writer.writeIntList("methodIDs", methodIDs);
        writer.writeIntList("offsets", offsets);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        assert (loader.readIntList("offsets").size() == loader.readIntList("methodIDs").size()) : Assertions.errorMessage((Object[])new Object[]{"Offsets and methodIDs are incompatible", loader.readIntList("offsets"), loader.readIntList("methodIDs")});
        int layerNumber = loader.readInt("nextLayerNumber");
        String codeSectionStartSymbol = loader.readString("codeSectionStartSymbol");
        Iterator<Integer> offsets = loader.readIntList("offsets").iterator();
        Iterator<Integer> methodIDs = loader.readIntList("methodIDs").iterator();
        HashMap<Integer, Integer> initialMethodIdToOffsetMap = new HashMap<Integer, Integer>();
        while (offsets.hasNext()) {
            int methodId = methodIDs.next();
            int offset = offsets.next();
            initialMethodIdToOffsetMap.put(methodId, offset);
        }
        return new HostedDynamicLayerInfo(layerNumber, codeSectionStartSymbol, initialMethodIdToOffsetMap);
    }
}

