/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.config.DynamicHubLayout;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.meta.RelocatableConstant;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.stream.Stream;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.Indent;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.word.WordBase;

public final class NativeImageHeapWriter {
    private final NativeImageHeap heap;
    private final ImageHeapLayoutInfo heapLayout;
    private long sectionOffsetOfARelocatablePointer;
    private final boolean useHeapBase = NativeImageHeap.useHeapBase();
    private final CompressEncoding compressEncoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);

    public NativeImageHeapWriter(NativeImageHeap heap, ImageHeapLayoutInfo heapLayout) {
        this.heap = heap;
        this.heapLayout = heapLayout;
        this.sectionOffsetOfARelocatablePointer = -1L;
    }

    public long writeHeap(DebugContext debug, RelocatableBuffer buffer) {
        try (Indent perHeapIndent = debug.logAndIndent("NativeImageHeap.writeHeap:");){
            for (NativeImageHeap.ObjectInfo info : this.heap.getObjects()) {
                assert (!this.heap.isBlacklisted(info.getObject()));
                if (info.getConstant().isInBaseLayer()) continue;
                this.writeObject(info, buffer);
            }
            this.writeStaticFields(buffer);
            this.heap.getLayouter().writeMetadata(buffer.getByteBuffer(), 0L);
        }
        return this.sectionOffsetOfARelocatablePointer;
    }

    private void writeStaticFields(RelocatableBuffer buffer) {
        NativeImageHeap.ObjectInfo primitiveFields = this.heap.getObjectInfo(StaticFieldsSupport.getStaticPrimitiveFields());
        NativeImageHeap.ObjectInfo objectFields = this.heap.getObjectInfo(StaticFieldsSupport.getStaticObjectFields());
        for (HostedField field : this.heap.hUniverse.getFields()) {
            if (field.wrapped.isInBaseLayer() || !Modifier.isStatic(field.getModifiers()) || !field.hasLocation() || !field.isRead()) continue;
            assert (field.isWritten() || !field.isValueAvailable() || MaterializedConstantFields.singleton().contains(field.wrapped));
            NativeImageHeap.ObjectInfo fields = field.getStorageKind() == JavaKind.Object ? objectFields : primitiveFields;
            this.writeField(buffer, fields, field, null, null);
        }
    }

    private int referenceSize() {
        return this.heap.objectLayout.getReferenceSize();
    }

    private void mustBeReferenceAligned(int index) {
        assert (index % this.heap.objectLayout.getReferenceSize() == 0) : "index " + index + " must be reference-aligned.";
    }

    private static void verifyTargetDidNotChange(Object target, Object reason, Object targetInfo) {
        if (targetInfo == null) {
            throw NativeImageHeap.reportIllegalType(target, reason, "Inconsistent image heap.");
        }
    }

    private void writeField(RelocatableBuffer buffer, NativeImageHeap.ObjectInfo fields, HostedField field, JavaConstant receiver, NativeImageHeap.ObjectInfo info) {
        JavaConstant value;
        int index = this.getIndexInBuffer(fields, field.getLocation());
        try {
            value = this.heap.hConstantReflection.readFieldValue(field, receiver);
        }
        catch (AnalysisError.TypeNotFoundError ex) {
            throw NativeImageHeap.reportIllegalType(ex.getType(), info);
        }
        if (value instanceof RelocatableConstant) {
            this.addNonDataRelocation(buffer, index, this.prepareRelocatable(info, value));
        } else {
            this.write(buffer, index, value, info != null ? info : field);
        }
    }

    private void write(RelocatableBuffer buffer, int index, JavaConstant con, Object reason) {
        if (con.getJavaKind() == JavaKind.Object) {
            this.writeReference(buffer, index, con, reason);
        } else {
            NativeImageHeapWriter.writePrimitive(buffer, index, con);
        }
    }

    void writeReference(RelocatableBuffer buffer, int index, JavaConstant target, Object reason) {
        assert (!this.heap.hMetaAccess.isInstanceOf(target, WordBase.class)) : "word values are not references";
        this.mustBeReferenceAligned(index);
        if (target.isNonNull()) {
            NativeImageHeap.ObjectInfo targetInfo = this.heap.getConstantInfo(target);
            NativeImageHeapWriter.verifyTargetDidNotChange(target, reason, targetInfo);
            if (this.useHeapBase) {
                int shift = this.compressEncoding.getShift();
                this.writeReferenceValue(buffer, index, targetInfo.getOffset() >>> shift);
            } else {
                this.addDirectRelocationWithoutAddend(buffer, index, this.referenceSize(), target);
            }
        }
    }

    private void writeConstant(RelocatableBuffer buffer, int index, JavaKind kind, JavaConstant constant, NativeImageHeap.ObjectInfo info) {
        Object con;
        if (constant instanceof RelocatableConstant) {
            this.addNonDataRelocation(buffer, index, this.prepareRelocatable(info, constant));
            return;
        }
        if (this.heap.hMetaAccess.isInstanceOf(constant, WordBase.class)) {
            Object value = this.snippetReflection().asObject(Object.class, constant);
            con = JavaConstant.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)((WordBase)value).rawValue());
        } else {
            con = constant.isNull() && kind == ConfigurationValues.getWordKind() ? JavaConstant.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)0L) : constant;
        }
        this.write(buffer, index, (JavaConstant)con, info);
    }

    private RelocatedPointer prepareRelocatable(NativeImageHeap.ObjectInfo info, JavaConstant value) {
        return (RelocatedPointer)this.maybeReplace(this.snippetReflection().asObject(RelocatedPointer.class, value), info);
    }

    private void writeConstant(RelocatableBuffer buffer, int index, JavaKind kind, Object value, NativeImageHeap.ObjectInfo info) {
        PrimitiveConstant con;
        if (value instanceof RelocatedPointer) {
            this.addNonDataRelocation(buffer, index, (RelocatedPointer)value);
            return;
        }
        if (value instanceof WordBase) {
            con = JavaConstant.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)((WordBase)value).rawValue());
        } else if (value == null && kind == ConfigurationValues.getWordKind()) {
            con = JavaConstant.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)0L);
        } else {
            assert (kind == JavaKind.Object || value != null) : "primitive value must not be null";
            con = this.snippetReflection().forBoxed(kind, value);
        }
        this.write(buffer, index, (JavaConstant)con, info);
    }

    private void writeObjectHeader(RelocatableBuffer buffer, int index, NativeImageHeap.ObjectInfo obj) {
        this.mustBeReferenceAligned(index);
        DynamicHub hub = obj.getClazz().getHub();
        assert (hub != null) : "Null DynamicHub found during native image generation.";
        NativeImageHeap.ObjectInfo hubInfo = this.heap.getObjectInfo(hub);
        assert (hubInfo != null) : "Unknown object " + hub.toString() + " found. Static field or an object referenced from a static field changed during native image generation?";
        ObjectHeader objectHeader = Heap.getHeap().getObjectHeader();
        if (NativeImageHeap.useHeapBase()) {
            long targetOffset = hubInfo.getOffset();
            long headerBits = objectHeader.encodeAsImageHeapObjectHeader(obj, targetOffset);
            this.writeReferenceValue(buffer, index, headerBits);
        } else {
            long headerBits = objectHeader.encodeAsImageHeapObjectHeader(obj, 0L);
            this.addDirectRelocationWithAddend(buffer, index, hub, headerBits);
        }
    }

    private void addDirectRelocationWithoutAddend(RelocatableBuffer buffer, int index, int size, Object target) {
        assert (size == 4 || size == 8);
        assert (!NativeImageHeap.spawnIsolates() || this.isReadOnlyRelocatable(index));
        buffer.addRelocationWithoutAddend(index, size == 8 ? ObjectFile.RelocationKind.DIRECT_8 : ObjectFile.RelocationKind.DIRECT_4, target);
        if (this.sectionOffsetOfARelocatablePointer == -1L) {
            this.sectionOffsetOfARelocatablePointer = index;
        }
    }

    private void addDirectRelocationWithAddend(RelocatableBuffer buffer, int index, DynamicHub target, long objectHeaderBits) {
        assert (!NativeImageHeap.spawnIsolates() || this.isReadOnlyRelocatable(index));
        buffer.addRelocationWithAddend(index, this.referenceSize() == 8 ? ObjectFile.RelocationKind.DIRECT_8 : ObjectFile.RelocationKind.DIRECT_4, objectHeaderBits, this.snippetReflection().forObject((Object)target));
        if (this.sectionOffsetOfARelocatablePointer == -1L) {
            this.sectionOffsetOfARelocatablePointer = index;
        }
    }

    private void addNonDataRelocation(RelocatableBuffer buffer, int index, RelocatedPointer pointer) {
        this.mustBeReferenceAligned(index);
        assert (pointer instanceof CFunctionPointer) : "unknown relocated pointer " + String.valueOf(pointer);
        assert (pointer instanceof MethodPointer) : "cannot create relocation for unknown FunctionPointer " + String.valueOf(pointer);
        int pointerSize = ConfigurationValues.getTarget().wordSize;
        this.addDirectRelocationWithoutAddend(buffer, index, pointerSize, pointer);
    }

    private static void writePrimitive(RelocatableBuffer buffer, int index, JavaConstant con) {
        ByteBuffer bb = buffer.getByteBuffer();
        switch (con.getJavaKind()) {
            case Boolean: {
                bb.put(index, (byte)con.asInt());
                break;
            }
            case Byte: {
                bb.put(index, (byte)con.asInt());
                break;
            }
            case Char: {
                bb.putChar(index, (char)con.asInt());
                break;
            }
            case Short: {
                bb.putShort(index, (short)con.asInt());
                break;
            }
            case Int: {
                bb.putInt(index, con.asInt());
                break;
            }
            case Long: {
                bb.putLong(index, con.asLong());
                break;
            }
            case Float: {
                bb.putFloat(index, con.asFloat());
                break;
            }
            case Double: {
                bb.putDouble(index, con.asDouble());
                break;
            }
            default: {
                throw VMError.shouldNotReachHere(con.getJavaKind().toString());
            }
        }
    }

    private void writeReferenceValue(RelocatableBuffer buffer, int index, long value) {
        if (this.referenceSize() == 8) {
            buffer.getByteBuffer().putLong(index, value);
        } else if (this.referenceSize() == 4) {
            buffer.getByteBuffer().putInt(index, NumUtil.safeToInt((long)value));
        } else {
            throw VMError.shouldNotReachHere("Unsupported reference size: " + this.referenceSize());
        }
    }

    private void writeObject(NativeImageHeap.ObjectInfo info, RelocatableBuffer buffer) {
        ObjectLayout objectLayout = this.heap.objectLayout;
        DynamicHubLayout dynamicHubLayout = this.heap.dynamicHubLayout;
        assert (objectLayout.isAligned(this.getIndexInBuffer(info, 0L)));
        this.writeObjectHeader(buffer, this.getIndexInBuffer(info, objectLayout.getHubOffset()), info);
        ByteBuffer bufferBytes = buffer.getByteBuffer();
        HostedClass clazz = info.getClazz();
        if (clazz.isInstanceClass()) {
            long idHashOffset;
            ImageHeapConstant con = info.getConstant();
            HostedInstanceClass instanceClazz = (HostedInstanceClass)clazz;
            Stream<HostedField> instanceFields = Arrays.stream(clazz.getInstanceFields(true)).filter(HostedField::isRead);
            if (dynamicHubLayout.isDynamicHub(clazz)) {
                if (SubstrateOptions.closedTypeWorld()) {
                    short[] typeIDSlots = (short[])this.heap.readInlinedField(dynamicHubLayout.closedTypeWorldTypeCheckSlotsField, (JavaConstant)con);
                    int typeIDSlotsLength = typeIDSlots.length;
                    for (int i = 0; i < typeIDSlotsLength; ++i) {
                        int index2 = this.getIndexInBuffer(info, dynamicHubLayout.getClosedTypeWorldTypeCheckSlotsOffset(i));
                        short value = typeIDSlots[i];
                        bufferBytes.putShort(index2, value);
                    }
                }
                Object vTable = this.heap.readInlinedField(dynamicHubLayout.vTableField, (JavaConstant)con);
                int vtableLength = Array.getLength(vTable);
                bufferBytes.putInt(this.getIndexInBuffer(info, dynamicHubLayout.getVTableLengthOffset()), vtableLength);
                JavaKind elementStorageKind = dynamicHubLayout.getVTableSlotStorageKind();
                for (int i = 0; i < vtableLength; ++i) {
                    Object vtableSlot = Array.get(vTable, i);
                    int elementIndex = this.getIndexInBuffer(info, dynamicHubLayout.getVTableSlotOffset(i));
                    this.writeConstant(buffer, elementIndex, elementStorageKind, vtableSlot, info);
                }
                idHashOffset = dynamicHubLayout.getIdentityHashOffset(vtableLength);
                instanceFields = instanceFields.filter(field -> !dynamicHubLayout.isIgnoredField((HostedField)field));
            } else if (this.heap.getHybridLayout(clazz) != null) {
                HybridLayout hybridLayout = this.heap.getHybridLayout(clazz);
                HostedField hybridArrayField = hybridLayout.getArrayField();
                Object hybridArray = this.heap.readInlinedField(hybridArrayField, (JavaConstant)con);
                int length = Array.getLength(hybridArray);
                bufferBytes.putInt(this.getIndexInBuffer(info, objectLayout.getArrayLengthOffset()), length);
                for (int i = 0; i < length; ++i) {
                    int elementIndex = this.getIndexInBuffer(info, hybridLayout.getArrayElementOffset(i));
                    JavaKind elementStorageKind = hybridLayout.getArrayElementStorageKind();
                    Object array = Array.get(hybridArray, i);
                    this.writeConstant(buffer, elementIndex, elementStorageKind, array, info);
                }
                idHashOffset = hybridLayout.getIdentityHashOffset(length);
                instanceFields = instanceFields.filter(field -> !field.equals(hybridArrayField));
            } else {
                idHashOffset = instanceClazz.getIdentityHashOffset();
            }
            instanceFields.forEach(field -> {
                assert (field.getLocation() >= 0 && field.getLocation() >= instanceClazz.getFirstInstanceFieldOffset() && field.getLocation() < instanceClazz.getAfterFieldsOffset()) : Assertions.errorMessage((Object[])new Object[]{field, instanceClazz.getFirstInstanceFieldOffset(), instanceClazz.getAfterFieldsOffset()});
                this.writeField(buffer, info, (HostedField)field, (JavaConstant)con, info);
            });
            assert (idHashOffset > 0L);
            bufferBytes.putInt(this.getIndexInBuffer(info, idHashOffset), info.getIdentityHashCode());
        } else if (clazz.isArray()) {
            JavaKind kind = clazz.getComponentType().getStorageKind();
            ImageHeapConstant constant = info.getConstant();
            int length = this.heap.hConstantReflection.readArrayLength((JavaConstant)constant);
            bufferBytes.putInt(this.getIndexInBuffer(info, objectLayout.getArrayLengthOffset()), length);
            bufferBytes.putInt(this.getIndexInBuffer(info, objectLayout.getArrayIdentityHashOffset(kind, length)), info.getIdentityHashCode());
            if (clazz.getComponentType().isPrimitive()) {
                ImageHeapPrimitiveArray imageHeapArray = (ImageHeapPrimitiveArray)constant;
                this.writePrimitiveArray(info, buffer, objectLayout, kind, imageHeapArray.getArray(), length);
            } else {
                this.heap.hConstantReflection.forEachArrayElement((JavaConstant)constant, (element, index) -> {
                    int elementIndex = this.getIndexInBuffer(info, objectLayout.getArrayElementOffset(kind, index));
                    this.writeConstant(buffer, elementIndex, kind, (JavaConstant)element, info);
                });
            }
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput(clazz);
        }
    }

    private int getIndexInBuffer(NativeImageHeap.ObjectInfo objInfo, long offset) {
        long index = objInfo.getOffset() + offset - this.heapLayout.getStartOffset();
        return NumUtil.safeToInt((long)index);
    }

    private boolean isReadOnlyRelocatable(int indexInBuffer) {
        long offset = (long)indexInBuffer + this.heapLayout.getStartOffset();
        return this.heapLayout.isReadOnlyRelocatable(offset);
    }

    private void writePrimitiveArray(NativeImageHeap.ObjectInfo info, RelocatableBuffer buffer, ObjectLayout objectLayout, JavaKind kind, Object array, int length) {
        int elementIndex = this.getIndexInBuffer(info, objectLayout.getArrayElementOffset(kind, 0));
        int elementTypeSize = Unsafe.getUnsafe().arrayIndexScale(array.getClass());
        assert (elementTypeSize == kind.getByteCount());
        Unsafe.getUnsafe().copyMemory(array, Unsafe.getUnsafe().arrayBaseOffset(array.getClass()), buffer.getBackingArray(), Unsafe.ARRAY_BYTE_BASE_OFFSET + elementIndex, length * elementTypeSize);
    }

    private Object maybeReplace(Object object, Object reason) {
        try {
            return this.heap.aUniverse.replaceObject(object);
        }
        catch (AnalysisError.TypeNotFoundError ex) {
            throw NativeImageHeap.reportIllegalType(ex.getType(), reason);
        }
    }

    private SnippetReflectionProvider snippetReflection() {
        return this.heap.hUniverse.getSnippetReflection();
    }
}

