/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.UniqueShortNameProvider;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.meta.HostedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.collections.EconomicMap;

class NativeImageBFDNameProvider
implements UniqueShortNameProvider {
    private NativeLibraries nativeLibs;
    private final List<ClassLoader> ignoredLoaders;
    private static final String BUILTIN_CLASSLOADER_NAME = "jdk.internal.loader.BuiltinClassLoader";

    NativeImageBFDNameProvider(List<ClassLoader> ignore) {
        this.ignoredLoaders = ignore;
        this.nativeLibs = null;
    }

    @Override
    public String uniqueShortName(ClassLoader loader, ResolvedJavaType declaringClass, String methodName, Signature methodSignature, boolean isConstructor) {
        String loaderName = this.uniqueShortLoaderName(loader);
        return this.bfdMangle(loaderName, declaringClass, methodName, methodSignature, isConstructor);
    }

    @Override
    public String uniqueShortName(Member m) {
        return this.bfdMangle(m);
    }

    @Override
    public String uniqueShortLoaderName(ClassLoader loader) {
        if (NativeImageBFDNameProvider.isBuiltinLoader(loader)) {
            return "";
        }
        if (this.isGraalImageLoader(loader)) {
            return "";
        }
        String name = SubstrateUtil.classLoaderNameAndId(loader);
        name = SubstrateUtil.stripPackage(name);
        name = NativeImageBFDNameProvider.stripOuterClass(name);
        name = name.replace(" @", "_").replace("'", "").replace("\"", "");
        return name;
    }

    private String classLoaderNameAndId(ResolvedJavaType type) {
        return this.uniqueShortLoaderName(NativeImageBFDNameProvider.getClassLoader(type));
    }

    private static String stripOuterClass(String name) {
        return name.substring(name.lastIndexOf(36) + 1);
    }

    private static ClassLoader getClassLoader(ResolvedJavaType type) {
        if (type.isPrimitive()) {
            return null;
        }
        if (type.isArray()) {
            return NativeImageBFDNameProvider.getClassLoader(type.getElementalType());
        }
        if (type instanceof HostedType) {
            HostedType hostedType = (HostedType)type;
            return hostedType.getJavaClass().getClassLoader();
        }
        return null;
    }

    private static boolean isBuiltinLoader(ClassLoader loader) {
        if (loader == null) {
            return true;
        }
        Class<?> loaderClazz = loader.getClass();
        do {
            if (!loaderClazz.getName().equals(BUILTIN_CLASSLOADER_NAME)) continue;
            return true;
        } while ((loaderClazz = loaderClazz.getSuperclass()) != Object.class);
        return false;
    }

    private boolean isGraalImageLoader(ClassLoader loader) {
        return this.ignoredLoaders.contains(loader);
    }

    public String bfdMangle(String loaderName, ResolvedJavaType declaringClass, String memberName, Signature methodSignature, boolean isConstructor) {
        return new BFDMangler(this).mangle(loaderName, declaringClass, memberName, methodSignature, isConstructor);
    }

    public String bfdMangle(Member m) {
        return new BFDMangler(this).mangle(m);
    }

    public void setNativeLibs(NativeLibraries nativeLibs) {
        this.nativeLibs = nativeLibs;
    }

    private boolean needsPointerPrefix(ResolvedJavaType type) {
        ResolvedJavaType target = type;
        if (type instanceof HostedType) {
            target = ((HostedType)target).getWrapped();
        }
        if (target instanceof AnalysisType) {
            assert (this.nativeLibs != null) : "No native libs during or after analysis!";
            return !this.nativeLibs.isWordBase(target);
        }
        return true;
    }

    private static class BFDMangler {
        final NativeImageBFDNameProvider nameProvider;
        final StringBuilder sb;
        EconomicMap<LookupName, Integer> bindings;

        BFDMangler(NativeImageBFDNameProvider provider) {
            this.nameProvider = provider;
            this.sb = new StringBuilder("_Z");
            this.bindings = EconomicMap.create();
        }

        public String mangle(String loaderName, ResolvedJavaType declaringClass, String memberName, Signature methodSignature, boolean isConstructor) {
            String fqn = declaringClass.toJavaName();
            String selector = memberName;
            if (isConstructor) {
                assert (methodSignature != null);
                assert (selector.startsWith("<init>"));
                String replacement = fqn;
                int index = replacement.lastIndexOf(46);
                if (index >= 0) {
                    replacement = fqn.substring(index + 1);
                }
                selector = selector.replace("<init>", replacement);
            }
            this.mangleClassAndMemberName(loaderName, fqn, selector);
            if (methodSignature != null) {
                if (!isConstructor) {
                    this.mangleReturnType(methodSignature, declaringClass);
                }
                this.mangleParams(methodSignature, declaringClass);
            }
            return this.sb.toString();
        }

        public String mangle(Member member) {
            Class<?> declaringClass = member.getDeclaringClass();
            String loaderName = this.nameProvider.uniqueShortLoaderName(declaringClass.getClassLoader());
            String className = declaringClass.getName();
            String selector = member.getName();
            boolean isConstructor = member instanceof Constructor;
            boolean isMethod = member instanceof Method;
            if (isConstructor) {
                assert (selector.equals("<init>"));
                selector = SubstrateUtil.stripPackage(className);
            }
            this.mangleClassAndMemberName(loaderName, className, selector);
            if (isMethod) {
                Method method = (Method)member;
                this.mangleReturnType(method.getReturnType());
            }
            if (isConstructor || isMethod) {
                Executable executable = (Executable)member;
                this.mangleParams(executable.getParameters());
            }
            return this.sb.toString();
        }

        private void mangleWriteSimpleName(String s) {
            assert (!s.startsWith("[0-9]"));
            this.sb.append(s.length());
            this.sb.append(s);
        }

        private void mangleWriteSubstitutableNameRecord(String name) {
            SimpleLookupName lookupName = new SimpleLookupName(name);
            if (!this.substituteName(new SimpleLookupName(name))) {
                this.mangleWriteSimpleName(name);
                this.recordName(lookupName);
            }
        }

        private void mangleWriteSubstitutableNameNoRecord(String name) {
            SimpleLookupName lookupName = new SimpleLookupName(name);
            if (!this.substituteName(lookupName)) {
                this.mangleWriteSimpleName(name);
            }
        }

        private void mangleWriteSubstitutablePrefixedName(String prefix, String name) {
            assert (this.sb.charAt(this.sb.length() - 1) == 'N');
            this.mangleWriteSubstitutableNameRecord(prefix);
            this.mangleWriteSimpleName(name);
        }

        private void mangleWriteSubstitutablePrefixedName(String prefix1, String prefix2, String name) {
            assert (this.sb.charAt(this.sb.length() - 1) == 'N');
            SimpleLookupName simpleLookupName = new SimpleLookupName(prefix2);
            NamespaceLookupName namespaceLookupName = new NamespaceLookupName(prefix1, simpleLookupName);
            if (!this.substituteName(namespaceLookupName)) {
                this.mangleWriteSubstitutableNameRecord(prefix1);
                this.mangleWriteSubstitutableNameNoRecord(prefix2);
                this.recordName(namespaceLookupName);
            }
            this.mangleWriteSimpleName(name);
        }

        private boolean substituteName(LookupName name) {
            Integer index = (Integer)this.bindings.get((Object)name);
            if (index != null) {
                this.writeSubstitution(index);
                return true;
            }
            return false;
        }

        private static boolean encodeLoaderName(String loaderName) {
            return loaderName != null && !loaderName.isEmpty();
        }

        private void mangleClassAndMemberName(String loaderName, String className, String methodName) {
            this.sb.append('N');
            if (BFDMangler.encodeLoaderName(loaderName)) {
                this.mangleWriteSubstitutablePrefixedName(loaderName, className, methodName);
            } else {
                this.mangleWriteSubstitutablePrefixedName(className, methodName);
            }
            this.sb.append('E');
        }

        private void mangleClassName(String loaderName, String className) {
            boolean encodeLoaderName = BFDMangler.encodeLoaderName(loaderName);
            if (encodeLoaderName) {
                this.sb.append('N');
                this.mangleWriteSubstitutablePrefixedName(loaderName, className);
                this.sb.append('E');
            } else {
                this.mangleWriteSubstitutableNameRecord(className);
            }
        }

        private void mangleClassPointer(String loaderName, String className) {
            PointerLookupName pointerLookup;
            SimpleLookupName classLookup;
            boolean encodeLoaderName = BFDMangler.encodeLoaderName(loaderName);
            Record lookup = classLookup = new SimpleLookupName(className);
            if (encodeLoaderName) {
                lookup = new NamespaceLookupName(loaderName, classLookup);
            }
            if (!this.substituteName(pointerLookup = new PointerLookupName((LookupName)((Object)lookup)))) {
                this.sb.append("P");
                this.mangleClassName(loaderName, className);
                this.recordName(pointerLookup);
            }
        }

        private void mangleReturnType(Signature methodSignature, ResolvedJavaType owner) {
            this.sb.append('J');
            this.mangleType(methodSignature.getReturnType(owner));
        }

        private void mangleReturnType(Class<?> type) {
            this.sb.append('J');
            this.mangleType(type);
        }

        private void mangleParams(Signature methodSignature, ResolvedJavaType owner) {
            int count = methodSignature.getParameterCount(false);
            if (count == 0) {
                this.mangleTypeChar('V');
            } else {
                for (int i = 0; i < count; ++i) {
                    this.mangleType(methodSignature.getParameterType(i, owner));
                }
            }
        }

        private void mangleParams(Parameter[] params) {
            if (params.length == 0) {
                this.mangleTypeChar('V');
            } else {
                for (int i = 0; i < params.length; ++i) {
                    this.mangleType(params[i].getType());
                }
            }
        }

        private void mangleType(JavaType type) {
            if (type instanceof ResolvedJavaType) {
                this.mangleType((ResolvedJavaType)type);
            } else if (type instanceof UnresolvedJavaType) {
                this.mangleType((UnresolvedJavaType)type);
            } else {
                throw VMError.shouldNotReachHere("Unexpected JavaType for " + String.valueOf(type));
            }
        }

        private void mangleType(ResolvedJavaType type) {
            if (type.isPrimitive()) {
                this.manglePrimitiveType(type);
            } else if (type.isArray()) {
                this.mangleArrayType(type);
            } else {
                String loaderName = this.nameProvider.classLoaderNameAndId(type);
                String className = type.toJavaName();
                if (this.nameProvider.needsPointerPrefix(type)) {
                    this.mangleClassPointer(loaderName, className);
                } else {
                    this.mangleClassName(loaderName, className);
                }
            }
        }

        private void mangleType(UnresolvedJavaType type) {
            if (type.isArray()) {
                this.mangleArrayType(type);
            } else {
                this.mangleClassPointer("", type.toJavaName());
            }
        }

        private void mangleType(Class<?> type) {
            if (type.isPrimitive()) {
                this.manglePrimitiveType(type);
            } else if (type.isArray()) {
                this.mangleArrayType(type);
            } else {
                this.mangleClassPointer(this.nameProvider.uniqueShortLoaderName(type.getClassLoader()), type.getName());
            }
        }

        private void mangleArrayType(ResolvedJavaType arrayType) {
            int count = 1;
            ResolvedJavaType baseType = arrayType.getComponentType();
            while (baseType.isArray()) {
                ++count;
                baseType = baseType.getComponentType();
            }
            String loaderName = this.nameProvider.classLoaderNameAndId(baseType);
            this.mangleArrayPointer(loaderName, baseType.toJavaName(), count);
        }

        private void mangleArrayType(UnresolvedJavaType arrayType) {
            int count = 1;
            JavaType baseType = arrayType.getComponentType();
            while (baseType.isArray()) {
                ++count;
                baseType = baseType.getComponentType();
            }
            this.mangleArrayPointer("", baseType.toJavaName(), count);
        }

        private void mangleArrayType(Class<?> arrayType) {
            int count = 1;
            Class<?> baseType = arrayType.getComponentType();
            while (baseType.isArray()) {
                baseType = baseType.getComponentType();
            }
            String loaderName = this.nameProvider.uniqueShortLoaderName(baseType.getClassLoader());
            this.mangleArrayPointer(loaderName, baseType.getName(), count);
        }

        private void mangleArrayPointer(String loaderName, String baseName, int dims) {
            this.mangleClassPointer(loaderName, BFDMangler.makeArrayName(baseName, dims));
        }

        private static String makeArrayName(String baseName, int dims) {
            StringBuilder sb1 = new StringBuilder();
            sb1.append(baseName);
            for (int i = 0; i < dims; ++i) {
                sb1.append("[]");
            }
            return sb1.toString();
        }

        private void manglePrimitiveType(ResolvedJavaType type) {
            char c = type.getJavaKind().getTypeChar();
            this.mangleTypeChar(c);
        }

        private void manglePrimitiveType(Class<?> type) {
            char c = JavaKind.fromJavaClass(type).getTypeChar();
            this.mangleTypeChar(c);
        }

        private void mangleTypeChar(char c) {
            switch (c) {
                case 'Z': {
                    this.mangleWriteSubstitutableNameRecord("boolean");
                    return;
                }
                case 'B': {
                    this.mangleWriteSubstitutableNameRecord("byte");
                    return;
                }
                case 'S': {
                    this.sb.append("s");
                    return;
                }
                case 'C': {
                    this.mangleWriteSubstitutableNameRecord("char");
                    return;
                }
                case 'I': {
                    this.sb.append("i");
                    return;
                }
                case 'J': {
                    this.sb.append("l");
                    return;
                }
                case 'F': {
                    this.sb.append("f");
                    return;
                }
                case 'D': {
                    this.sb.append("d");
                    return;
                }
                case 'V': {
                    this.sb.append("v");
                    return;
                }
            }
            assert (false) : "invalid kind for primitive type " + c;
        }

        private void writeSubstitution(int i) {
            this.sb.append('S');
            if (i > 36) {
                this.sb.append(BFDMangler.b36((i - 1) / 36));
                this.sb.append(BFDMangler.b36((i - 1) % 36));
            } else if (i > 0) {
                this.sb.append(BFDMangler.b36(i - 1));
            }
            this.sb.append('_');
        }

        private static char b36(int i) {
            if (i < 10) {
                return (char)(48 + i);
            }
            return (char)(65 + (i - 10));
        }

        private void recordName(LookupName name) {
            this.bindings.put((Object)name, (Object)this.bindings.size());
        }

        private record SimpleLookupName(String value) implements LookupName
        {
            @Override
            public String toString() {
                return this.value;
            }
        }

        private static sealed interface LookupName
        permits SimpleLookupName, CompositeLookupName {
        }

        private record NamespaceLookupName(String prefix, LookupName tail) implements CompositeLookupName
        {
            @Override
            public String toString() {
                return this.prefix + "::" + this.tail.toString();
            }
        }

        private record PointerLookupName(LookupName tail) implements CompositeLookupName
        {
            @Override
            public String toString() {
                return this.tail.toString() + "*";
            }
        }

        private static sealed interface CompositeLookupName
        extends LookupName
        permits NamespaceLookupName, PointerLookupName {
        }
    }
}

