/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageLayerSnapshotUtil;
import com.oracle.graal.pointsto.heap.ImageLayerWriter;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.heap.ImageSingletonWriterImpl;
import com.oracle.svm.hosted.heap.SVMImageLayerSnapshotUtil;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.lambda.LambdaSubstitutionType;
import com.oracle.svm.hosted.lambda.StableLambdaProxyNameFeature;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.RelocatableConstant;
import com.oracle.svm.hosted.methodhandles.MethodHandleFeature;
import com.oracle.svm.hosted.methodhandles.MethodHandleInvokerSubstitutionType;
import com.oracle.svm.hosted.reflect.proxy.ProxyRenamingSubstitutionProcessor;
import com.oracle.svm.hosted.reflect.proxy.ProxySubstitutionType;
import com.oracle.svm.util.LogUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;

public class SVMImageLayerWriter
extends ImageLayerWriter {
    private NativeImageHeap nativeImageHeap;

    public SVMImageLayerWriter() {
        super((ImageLayerSnapshotUtil)new SVMImageLayerSnapshotUtil());
    }

    public void setNativeImageHeap(NativeImageHeap nativeImageHeap) {
        this.nativeImageHeap = nativeImageHeap;
    }

    protected void persistHook(Universe universe, AnalysisUniverse analysisUniverse) {
        HostedUniverse hostedUniverse = (HostedUniverse)universe;
        ImageHeapConstant staticPrimitiveFields = (ImageHeapConstant)hostedUniverse.getSnippetReflection().forObject(StaticFieldsSupport.getStaticPrimitiveFields());
        ImageHeapConstant staticObjectFields = (ImageHeapConstant)hostedUniverse.getSnippetReflection().forObject(StaticFieldsSupport.getStaticObjectFields());
        this.jsonMap.put((Object)"static primitive fields", (Object)this.getConstantId(staticPrimitiveFields));
        this.jsonMap.put((Object)"static object fields", (Object)this.getConstantId(staticObjectFields));
    }

    protected void persistType(AnalysisType type, AnalysisUniverse analysisUniverse, EconomicMap<String, Object> typeMap) {
        HostVM hostVM = analysisUniverse.hostVM();
        SVMHost svmHost = (SVMHost)hostVM;
        DynamicHub hub = svmHost.dynamicHub((ResolvedJavaType)type);
        typeMap.put((Object)"hub identityHashCode", (Object)System.identityHashCode(hub));
        super.persistType(type, analysisUniverse, typeMap);
    }

    public void checkTypeStability(AnalysisType type) {
        ProxySubstitutionType proxySubstitutionType;
        Object methodHandleFeature;
        String message;
        Object stableLambdaProxyNameFeature;
        ResolvedJavaType resolvedJavaType = type.getWrapped();
        if (resolvedJavaType instanceof LambdaSubstitutionType) {
            LambdaSubstitutionType lambdaSubstitutionType = (LambdaSubstitutionType)resolvedJavaType;
            stableLambdaProxyNameFeature = (StableLambdaProxyNameFeature)ImageSingletons.lookup(StableLambdaProxyNameFeature.class);
            if (!((StableLambdaProxyNameFeature)stableLambdaProxyNameFeature).getLambdaSubstitutionProcessor().isNameAlwaysStable(lambdaSubstitutionType.getName())) {
                message = "The lambda method " + lambdaSubstitutionType.getName() + " might not have a stable name in the extension image.";
                SVMImageLayerWriter.handleNameConflict(message);
            }
        }
        if ((stableLambdaProxyNameFeature = type.getWrapped()) instanceof MethodHandleInvokerSubstitutionType) {
            MethodHandleInvokerSubstitutionType methodHandleSubstitutionType = (MethodHandleInvokerSubstitutionType)stableLambdaProxyNameFeature;
            methodHandleFeature = (MethodHandleFeature)ImageSingletons.lookup(MethodHandleFeature.class);
            if (!((MethodHandleFeature)methodHandleFeature).getMethodHandleSubstitutionProcessor().isNameAlwaysStable(methodHandleSubstitutionType.getName())) {
                message = "The method handle " + methodHandleSubstitutionType.getName() + " might not have a stable name in the extension image.";
                SVMImageLayerWriter.handleNameConflict(message);
            }
        }
        if ((methodHandleFeature = type.getWrapped()) instanceof ProxySubstitutionType && !ProxyRenamingSubstitutionProcessor.isNameAlwaysStable((proxySubstitutionType = (ProxySubstitutionType)methodHandleFeature).getName())) {
            String message2 = "The Proxy type " + proxySubstitutionType.getName() + " might not have a stable name in the extension image.";
            SVMImageLayerWriter.handleNameConflict(message2);
        }
    }

    private static void handleNameConflict(String message) {
        if (SubstrateOptions.AbortOnNameConflict.getValue().booleanValue()) {
            throw VMError.shouldNotReachHere(message);
        }
        LogUtils.warning((String)message);
    }

    protected void persistField(AnalysisField field, Universe universe, EconomicMap<String, Object> fieldMap) {
        HostedUniverse hostedUniverse = (HostedUniverse)universe;
        HostedField hostedField = hostedUniverse.lookup((JavaField)field);
        int location = hostedField.getLocation();
        if (hostedField.isStatic() && location > 0) {
            fieldMap.put((Object)"location", (Object)location);
        }
        super.persistField(field, universe, fieldMap);
    }

    protected void persistConstant(AnalysisUniverse analysisUniverse, ImageHeapConstant imageHeapConstant, EconomicMap<String, Object> constantMap, EconomicMap<String, Object> constantsMap) {
        NativeImageHeap.ObjectInfo objectInfo = this.nativeImageHeap.getConstantInfo((JavaConstant)imageHeapConstant);
        if (objectInfo != null) {
            constantMap.put((Object)"object offset", (Object)String.valueOf(objectInfo.getOffset()));
        }
        super.persistConstant(analysisUniverse, imageHeapConstant, constantMap, constantsMap);
    }

    public void persistConstantRelinkingInfo(EconomicMap<String, Object> constantMap, BigBang bb, Class<?> clazz, JavaConstant hostedObject, int id) {
        ResolvedJavaType type = bb.getConstantReflectionProvider().asJavaType((Constant)hostedObject);
        if (type instanceof AnalysisType) {
            AnalysisType analysisType = (AnalysisType)type;
            if (!SVMImageLayerWriter.isTypeSwitch((AnalysisType)analysisType)) {
                constantMap.put((Object)"class id", (Object)analysisType.getId());
                this.constantsToRelink.add(id);
            }
        } else {
            super.persistConstantRelinkingInfo(constantMap, bb, clazz, hostedObject, id);
        }
    }

    protected boolean delegateProcessing(List<List<Object>> data, Object constant) {
        if (constant instanceof RelocatableConstant) {
            RelocatableConstant relocatableConstant = (RelocatableConstant)constant;
            data.add(List.of("M", Integer.valueOf(SVMImageLayerWriter.getRelocatableConstantMethodId(relocatableConstant))));
            return true;
        }
        return super.delegateProcessing(data, constant);
    }

    private static int getRelocatableConstantMethodId(RelocatableConstant relocatableConstant) {
        ResolvedJavaMethod method = ((MethodPointer)relocatableConstant.getPointer()).getMethod();
        if (method instanceof HostedMethod) {
            HostedMethod hostedMethod = (HostedMethod)method;
            return SVMImageLayerWriter.getMethodId(hostedMethod.wrapped);
        }
        return SVMImageLayerWriter.getMethodId((AnalysisMethod)method);
    }

    private static int getMethodId(AnalysisMethod analysisMethod) {
        if (!analysisMethod.isReachable()) {
            return -1;
        }
        return analysisMethod.getId();
    }

    public void writeImageSingletonInfo(List<Map.Entry<Class<?>, Object>> layeredImageSingletons) {
        SingletonPersistInfo info;
        ArrayList<List<Integer>> singletonsList = new ArrayList<List<Integer>>();
        HashMap<LayeredImageSingleton, SingletonPersistInfo> singletonInfoMap = new HashMap<LayeredImageSingleton, SingletonPersistInfo>();
        int nextID = 1;
        for (Map.Entry<Class<?>, Object> singletonInfo : layeredImageSingletons) {
            LayeredImageSingleton singleton = (LayeredImageSingleton)singletonInfo.getValue();
            String key = singletonInfo.getKey().getName();
            if (!singletonInfoMap.containsKey(singleton)) {
                ImageSingletonWriterImpl writer = new ImageSingletonWriterImpl();
                LayeredImageSingleton.PersistFlags flags = singleton.preparePersist(writer);
                boolean persistData = flags == LayeredImageSingleton.PersistFlags.CREATE;
                SingletonPersistInfo info2 = new SingletonPersistInfo(flags, persistData ? nextID++ : -1, persistData ? writer.getKeyValueStore() : null);
                singletonInfoMap.put(singleton, info2);
            }
            info = (SingletonPersistInfo)singletonInfoMap.get(singleton);
            singletonsList.add(List.of(key, Integer.valueOf(info.flags.ordinal()), Integer.valueOf(info.id)));
        }
        this.jsonMap.put((Object)"image singleton keys", singletonsList);
        ArrayList<List<EconomicMap<String, Object>>> objectList = new ArrayList<List<EconomicMap<String, Object>>>();
        List<Map.Entry> sortedByIDs = singletonInfoMap.entrySet().stream().filter(e -> ((SingletonPersistInfo)e.getValue()).flags == LayeredImageSingleton.PersistFlags.CREATE).sorted(Comparator.comparingInt(e -> ((SingletonPersistInfo)e.getValue()).id)).toList();
        for (Map.Entry entry : sortedByIDs) {
            info = (SingletonPersistInfo)entry.getValue();
            objectList.add(List.of(Integer.valueOf(info.id), ((LayeredImageSingleton)entry.getKey()).getClass().getName(), info.keyStore));
        }
        this.jsonMap.put((Object)"image singleton objects", objectList);
    }

    record SingletonPersistInfo(LayeredImageSingleton.PersistFlags flags, int id, EconomicMap<String, Object> keyStore) {
    }
}

