/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.hosted.code.CompilationGraph;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphDecoder;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class CompilationInfo {
    protected final HostedMethod method;
    protected final AtomicBoolean inParseQueue = new AtomicBoolean(false);
    protected boolean inCompileQueue;
    private volatile CompilationGraph compilationGraph;
    protected boolean isTrivialMethod;
    protected boolean trivialInliningDisabled;
    protected boolean canDeoptForTesting;
    protected ConstantNode[] specializedArguments;
    protected CompileQueue.ParseFunction customParseFunction;
    protected CompileQueue.CompileFunction customCompileFunction;
    protected CompileQueue.ParseHooks customParseHooks;
    protected long numNodesAfterParsing;
    protected long numNodesBeforeCompilation;
    protected long numNodesAfterCompilation;
    protected long numDeoptEntryPoints;
    protected long numDuringCallEntryPoints;
    protected final AtomicLong numDirectCalls = new AtomicLong();
    protected final AtomicLong numVirtualCalls = new AtomicLong();
    protected final AtomicLong numEntryPointCalls = new AtomicLong();

    public CompilationInfo(HostedMethod method) {
        this.method = method;
    }

    public boolean isDeoptEntry(int bci, FrameState.StackState stackState) {
        return this.method.isDeoptTarget() && (this.method.getMultiMethod((MultiMethod.MultiMethodKey)MultiMethod.ORIGINAL_METHOD).compilationInfo.canDeoptForTesting || SubstrateCompilationDirectives.singleton().isRegisteredDeoptEntry(this.method, bci, stackState));
    }

    public boolean canDeoptForTesting() {
        return this.canDeoptForTesting;
    }

    public CompilationGraph getCompilationGraph() {
        return this.compilationGraph;
    }

    public StructuredGraph createGraph(DebugContext debug, OptionValues options, CompilationIdentifier compilationId, boolean decode) {
        EncodedGraph encodedGraph = this.getCompilationGraph().getEncodedGraph();
        StructuredGraph graph = new StructuredGraph.Builder(options, debug).method((ResolvedJavaMethod)this.method).trackNodeSourcePosition(encodedGraph.trackNodeSourcePosition()).recordInlinedMethods(encodedGraph.isRecordingInlinedMethods()).compilationId(compilationId).build();
        if (decode) {
            try (DebugContext.Scope s = debug.scope((Object)"CreateGraph", (Object)graph, (Object)this.method);){
                GraphDecoder decoder = new GraphDecoder(AnalysisParsedGraph.HOST_ARCHITECTURE, graph);
                decoder.decode(encodedGraph);
            }
            catch (Throwable ex) {
                throw debug.handle(ex);
            }
        }
        return graph;
    }

    public void encodeGraph(StructuredGraph graph) {
        this.compilationGraph = CompilationGraph.encode(graph);
    }

    public void setCompilationGraph(CompilationGraph graph) {
        this.compilationGraph = graph;
    }

    public void clear() {
        this.compilationGraph = null;
        this.specializedArguments = null;
    }

    public boolean isTrivialMethod() {
        return this.isTrivialMethod;
    }

    public void setTrivialMethod(boolean trivial) {
        this.isTrivialMethod = trivial;
    }

    public boolean isTrivialInliningDisabled() {
        return this.trivialInliningDisabled;
    }

    public void setTrivialInliningDisabled(boolean trivialInliningDisabled) {
        this.trivialInliningDisabled = trivialInliningDisabled;
    }

    public void setCustomParseFunction(CompileQueue.ParseFunction parseFunction) {
        this.customParseFunction = parseFunction;
    }

    public CompileQueue.ParseFunction getCustomParseFunction() {
        return this.customParseFunction;
    }

    public void setCustomCompileFunction(CompileQueue.CompileFunction compileFunction) {
        this.customCompileFunction = compileFunction;
    }

    public CompileQueue.CompileFunction getCustomCompileFunction() {
        return this.customCompileFunction;
    }

    public void setCustomParseHooks(CompileQueue.ParseHooks parseHooks) {
        this.customParseHooks = parseHooks;
    }

    public CompileQueue.ParseHooks getCustomParseHooks() {
        return this.customParseHooks;
    }
}

