/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import java.nio.file.Path;
import java.util.Locale;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredFeature
public class VMFeature
implements InternalFeature {
    private NativeLibraries nativeLibraries;
    private static final String STATIC_BINARY_MARKER_SYMBOL_NAME = "__svm_vm_is_static_binary";
    private static final String VERSION_INFO_SYMBOL_NAME = "__svm_version_info";
    private static final String valueSeparator = "=";

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(VM.class, (Object)new VM(this.determineVMInfo()));
    }

    protected String determineVMInfo() {
        return VMFeature.getSelectedGCName();
    }

    protected static final String getSelectedGCName() {
        if (SubstrateOptions.UseSerialGC.getValue().booleanValue()) {
            return "serial gc";
        }
        if (SubstrateOptions.UseEpsilonGC.getValue().booleanValue()) {
            return "epsilon gc";
        }
        return "unknown gc";
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        if (SubstrateOptions.DumpTargetInfo.getValue().booleanValue()) {
            ReportUtils.report((String)"compilation-target information", (String)SubstrateOptions.reportsPath(), (String)"target_info", (String)"txt", out -> {
                out.println("Building image for target platform: " + ((Platform)ImageSingletons.lookup(Platform.class)).getClass().getName());
                if (ImageSingletons.contains(CCompilerInvoker.class)) {
                    out.println("Using native toolchain:");
                    ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).compilerInfo.dump(x -> out.println("   " + x));
                }
                out.println("Using CLibrary: " + ((LibCBase)ImageSingletons.lookup(LibCBase.class)).getClass().getName());
            });
        }
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        this.nativeLibraries = access.getNativeLibraries();
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        CGlobalDataFeature.singleton().registerWithGlobalSymbol(CGlobalDataFactory.createCString(VM.class.getName() + valueSeparator + ((VM)ImageSingletons.lookup(VM.class)).vendorVersion, VERSION_INFO_SYMBOL_NAME));
        VMFeature.addCGlobalDataString("Target.Platform", ((Platform)ImageSingletons.lookup(Platform.class)).getClass().getName());
        VMFeature.addCGlobalDataString("Target.LibC", ((LibCBase)ImageSingletons.lookup(LibCBase.class)).getClass().getName());
        VMFeature.addCGlobalDataString("Java.Version", System.getProperty("java.version"));
        VMFeature.addCGlobalDataString("Target.Libraries", String.join((CharSequence)"|", this.nativeLibraries.getLibraries()));
        VMFeature.addCGlobalDataString("Target.StaticLibraries", this.nativeLibraries.getStaticLibraries().stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining("|")));
        if (ImageSingletons.contains(CCompilerInvoker.class)) {
            VMFeature.addCGlobalDataString("Target.CCompiler", ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).compilerInfo.toCGlobalDataString());
        }
        if (SubstrateOptions.DumpTargetInfo.getValue().booleanValue()) {
            ReportUtils.report((String)"native-library information", (String)SubstrateOptions.reportsPath(), (String)"native_library_info", (String)"txt", out -> {
                out.println("Static libraries:");
                this.nativeLibraries.getStaticLibraries().stream().map(ReportUtils::getCWDRelativePath).map(Path::toString).forEach(x -> out.println("   " + x));
                out.println("Other libraries: " + String.join((CharSequence)",", this.nativeLibraries.getLibraries()));
            });
        }
        if (!Platform.includedIn(Platform.WINDOWS.class)) {
            CGlobalData isStaticBinaryMarker = CGlobalDataFactory.createWord((WordBase)WordFactory.unsigned((int)(SubstrateOptions.StaticExecutable.getValue() != false ? 1 : 0)), STATIC_BINARY_MARKER_SYMBOL_NAME);
            CGlobalDataFeature.singleton().registerWithGlobalHiddenSymbol(isStaticBinaryMarker);
        }
    }

    private static void addCGlobalDataString(String infoType, String content) {
        String data = VM.class.getName() + "." + infoType + valueSeparator + content;
        String symbolName = "__svm_vm_" + infoType.toLowerCase(Locale.ROOT).replace(".", "_");
        CGlobalDataFeature.singleton().registerWithGlobalSymbol(CGlobalDataFactory.createCString(data, symbolName));
    }
}

