/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Policy;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;
import sun.security.jca.ProviderList;
import sun.security.provider.NativePRNG;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;

@AutomaticallyRegisteredFeature
public class SecurityServicesFeature
extends JNIRegistrationUtil
implements InternalFeature {
    private static final String SECURE_RANDOM_SERVICE = "SecureRandom";
    private static final String SIGNATURE_SERVICE = "Signature";
    private static final String CIPHER_SERVICE = "Cipher";
    private static final String KEY_AGREEMENT_SERVICE = "KeyAgreement";
    private static final String KEY_STORE = "KeyStore";
    private static final String CERTIFICATE_FACTORY = "CertificateFactory";
    private static final String JKS = "JKS";
    private static final String X509 = "X.509";
    private static final String[] emptyStringArray = new String[0];
    private static final List<Class<?>> knownServices;
    private static final boolean isMscapiModulePresent;
    private ImageClassLoader loader;
    private Function<String, Class<?>> ctrParamClassAccessor;
    private Method getSpiClassMethod;
    private Map<String, Set<Provider.Service>> availableServices;
    private final Set<Provider> usedProviders = ConcurrentHashMap.newKeySet();
    private final Set<String> manuallyMarkedUsedProviderClassNames = new HashSet<String>();
    private Field verificationResultsField;
    private Field providerListField;
    private Field oidTableField;
    private Field oidMapField;
    private Field classCacheField;
    private Field constructorCacheField;
    private ConcurrentHashMap<WeakReference<Provider>, Object> cachedVerificationCache;
    private ProviderList cachedProviders;
    private Class<?> jceSecurityClass;
    private Class<?> classSaslClient;
    private Class<?> classSaslServer;
    ConcurrentHashMap<String, Boolean> processedServiceClasses = new ConcurrentHashMap();

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, this.getClass(), (boolean)false, (String)"java.base", (String[])new String[]{"sun.security.x509"});
        ModuleSupport.accessModuleByClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, this.getClass(), Security.class);
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).initializeAtBuildTime("javax.security.auth.kerberos.KeyTab", "Force initialization of sun.security.krb5.KerberosSecrets.javaxSecurityAuthKerberosAccess");
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.addManuallyConfiguredUsedProviders(a);
        this.verificationResultsField = access.findField("javax.crypto.JceSecurity", "verificationResults");
        this.providerListField = access.findField("sun.security.jca.Providers", "providerList");
        this.oidTableField = access.findField("sun.security.util.ObjectIdentifier", "oidTable");
        this.oidMapField = access.findField((Class)OIDMap.class, "oidMap");
        this.classCacheField = access.findField((Class)Provider.Service.class, "classCache");
        this.constructorCacheField = access.findField((Class)Provider.Service.class, "constructorCache");
        RuntimeClassInitializationSupport rci = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        rci.initializeAtRunTime(NativePRNG.class, "for substitutions");
        rci.initializeAtRunTime(NativePRNG.Blocking.class, "for substitutions");
        rci.initializeAtRunTime(NativePRNG.NonBlocking.class, "for substitutions");
        rci.initializeAtRunTime(SecurityServicesFeature.clazz(access, "sun.security.provider.SeedGenerator"), "for substitutions");
        rci.initializeAtRunTime(SecurityServicesFeature.clazz(access, "sun.security.provider.SecureRandom$SeederHolder"), "for substitutions");
        rci.initializeAtRunTime(SecurityServicesFeature.clazz(access, "sun.security.provider.AbstractDrbg$SeederHolder"), "for substitutions");
        if (isMscapiModulePresent) {
            rci.initializeAtRunTime(SecurityServicesFeature.clazz(access, "sun.security.mscapi.PRNG"), "for substitutions");
        }
        rci.initializeAtRunTime(SecurityServicesFeature.clazz(access, "sun.security.provider.FileInputStreamPool"), "for substitutions");
        rci.initializeAtRunTime(SecurityServicesFeature.clazz(access, "java.util.UUID$Holder"), "for substitutions");
        rci.initializeAtRunTime(SecurityServicesFeature.clazz(access, "sun.security.jca.JCAUtil$CachedSecureRandomHolder"), "for substitutions");
        rci.initializeAtRunTime(SecurityServicesFeature.clazz(access, "com.sun.crypto.provider.SunJCE$SecureRandomHolder"), "for substitutions");
        SecurityServicesFeature.optionalClazz(access, "sun.security.krb5.Confounder").ifPresent(clazz -> rci.initializeAtRunTime(clazz, "for substitutions"));
        SecurityServicesFeature.optionalClazz(access, "sun.security.krb5.Config").ifPresent(clazz -> rci.initializeAtRunTime(clazz, "Reset the value of lazily initialized field sun.security.krb5.Config#singleton"));
        rci.initializeAtRunTime(SecurityServicesFeature.clazz(access, "sun.security.jca.JCAUtil"), "JCAUtil.def holds a SecureRandom.");
        rci.initializeAtRunTime(SecurityServicesFeature.clazz(access, "sun.security.ssl.SSLContextImpl$DefaultManagersHolder"), "for reading properties at run time");
        rci.initializeAtRunTime(SecurityServicesFeature.clazz(access, "sun.security.ssl.SSLLogger"), "for reading properties at run time");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        this.loader = access.getImageClassLoader();
        this.jceSecurityClass = this.loader.findClassOrFail("javax.crypto.JceSecurity");
        access.ensureInitialized("java.security.cert.TrustAnchor");
        access.ensureInitialized("javax.crypto.spec.SecretKeySpec");
        access.ensureInitialized("javax.crypto.SealedObject");
        access.ensureInitialized("java.security.Signature");
        access.ensureInitialized("sun.security.util.AnchorCertificates");
        if (Options.EnableSecurityServicesFeature.getValue().booleanValue()) {
            this.registerServiceReachabilityHandlers(access);
        }
        if (SecurityServicesFeature.isPosix()) {
            Optional<Method> optMethodGetUnixInfo = SecurityServicesFeature.optionalMethod(access, "com.sun.security.auth.module.UnixSystem", "getUnixInfo", new Class[0]);
            optMethodGetUnixInfo.ifPresent(m -> {
                access.registerReachabilityHandler(SecurityServicesFeature::linkJaas, m);
                PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("com_sun_security_auth_module_UnixSystem");
            });
        }
        if (isMscapiModulePresent) {
            access.registerReachabilityHandler(SecurityServicesFeature::registerSunMSCAPIConfig, SecurityServicesFeature.clazz(access, "sun.security.mscapi.SunMSCAPI"));
            PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_security_mscapi");
        }
        access.registerFieldValueTransformer(this.providerListField, new FieldValueTransformerWithAvailability(){

            @Override
            public FieldValueTransformerWithAvailability.ValueAvailability valueAvailability() {
                return FieldValueTransformerWithAvailability.ValueAvailability.AfterAnalysis;
            }

            public Object transform(Object receiver, Object originalValue) {
                if (SecurityServicesFeature.this.cachedProviders != null) {
                    if (SubstrateUtil.assertionsEnabled()) {
                        List<Provider> filteredProviders = SecurityServicesFeature.this.filterProviderList(originalValue);
                        assert (SecurityServicesFeature.this.cachedProviders.providers().equals(filteredProviders)) : Assertions.errorMessage((Object[])new Object[]{SecurityServicesFeature.this.cachedProviders.providers(), filteredProviders});
                    }
                    if (Options.TraceSecurityServices.getValue().booleanValue()) {
                        ProviderList providerList = (ProviderList)originalValue;
                        List<Provider> removedProviders = providerList.providers().stream().filter(p -> SecurityServicesFeature.this.shouldRemoveProvider((Provider)p)).toList();
                        SecurityServicesFeature.traceRemovedProviders(removedProviders);
                    }
                }
                return SecurityServicesFeature.this.cachedProviders;
            }
        });
        access.registerFieldValueTransformer(this.verificationResultsField, new FieldValueTransformerWithAvailability(){

            @Override
            public FieldValueTransformerWithAvailability.ValueAvailability valueAvailability() {
                return FieldValueTransformerWithAvailability.ValueAvailability.AfterAnalysis;
            }

            public Object transform(Object receiver, Object originalValue) {
                if (SecurityServicesFeature.this.cachedVerificationCache != null && SubstrateUtil.assertionsEnabled()) {
                    ConcurrentHashMap<WeakReference<Provider>, Object> filteredCache = SecurityServicesFeature.this.filterVerificationCache(originalValue);
                    assert (SecurityServicesFeature.this.cachedVerificationCache.equals(filteredCache)) : Assertions.errorMessage((Object[])new Object[]{SecurityServicesFeature.this.cachedVerificationCache, filteredCache});
                }
                return SecurityServicesFeature.this.cachedVerificationCache;
            }
        });
    }

    private ConcurrentHashMap<WeakReference<Provider>, Object> filterVerificationCache(Object originalValue) {
        ConcurrentHashMap<WeakReference<Provider>, Object> cleanedCache = new ConcurrentHashMap<WeakReference<Provider>, Object>((ConcurrentHashMap)originalValue);
        cleanedCache.keySet().removeIf(key -> this.shouldRemoveProvider((Provider)key.get()));
        return cleanedCache;
    }

    private List<Provider> filterProviderList(Object originalValue) {
        return ((ProviderList)originalValue).providers().stream().filter(p -> !this.shouldRemoveProvider((Provider)p)).toList();
    }

    private void addManuallyConfiguredUsedProviders(Feature.DuringSetupAccess access) {
        for (String value : Options.AdditionalSecurityProviders.getValue().values()) {
            for (String className : value.split(",")) {
                Class classByName = access.findClassByName(className);
                UserError.guarantee(classByName != null, "Manually marked security provider class doesn't exist: %s. Make sure that the class name is correct and that the class is on the image builder classpath.", className);
                SecurityServicesFeature.trace("Marked provider %s as used", className);
                this.manuallyMarkedUsedProviderClassNames.add(className);
            }
        }
    }

    public boolean shouldRemoveProvider(Provider p) {
        if (p == null) {
            return true;
        }
        if (this.usedProviders.contains(p)) {
            return false;
        }
        return !this.manuallyMarkedUsedProviderClassNames.contains(p.getClass().getName());
    }

    private static void traceRemovedProviders(List<Provider> removedProviders) {
        if (removedProviders == null || removedProviders.isEmpty()) {
            SecurityServicesFeature.trace("No security providers have been removed.", new Object[0]);
        } else {
            SecurityServicesFeature.trace("The following security providers were deemed to be unused and removed:", new Object[0]);
            SecurityServicesPrinter.indent();
            SecurityServicesFeature.trace("ProviderName - ProviderClass", new Object[0]);
            for (Provider p : removedProviders) {
                SecurityServicesFeature.trace("%s - %s", p.getName(), p.getClass().getName());
            }
            SecurityServicesPrinter.dedent();
        }
    }

    private static void registerSunMSCAPIConfig(Feature.BeforeAnalysisAccess a) {
        NativeLibraries nativeLibraries = ((FeatureImpl.DuringAnalysisAccessImpl)a).getNativeLibraries();
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("sunmscapi");
        nativeLibraries.addStaticJniLibrary("sunmscapi", new String[0]);
        nativeLibraries.addDynamicNonJniLibrary("ncrypt");
        nativeLibraries.addDynamicNonJniLibrary("crypt32");
        SecurityServicesFeature.registerForThrowNew((Feature.FeatureAccess)a, "java.security.cert.CertificateParsingException", "java.security.InvalidKeyException", "java.security.KeyException", "java.security.KeyStoreException", "java.security.ProviderException", "java.security.SignatureException", "java.lang.OutOfMemoryError");
        if (isMscapiModulePresent) {
            a.registerReachabilityHandler(SecurityServicesFeature::registerLoadKeysOrCertificateChains, new Object[]{SecurityServicesFeature.optionalMethod((Feature.FeatureAccess)a, "sun.security.mscapi.CKeyStore", "loadKeysOrCertificateChains", String.class, Integer.TYPE).orElseGet(() -> SecurityServicesFeature.method((Feature.FeatureAccess)a, "sun.security.mscapi.CKeyStore", "loadKeysOrCertificateChains", String.class))});
            a.registerReachabilityHandler(SecurityServicesFeature::registerGenerateCKeyPair, new Object[]{SecurityServicesFeature.method((Feature.FeatureAccess)a, "sun.security.mscapi.CKeyPairGenerator$RSA", "generateCKeyPair", String.class, Integer.TYPE, String.class)});
            a.registerReachabilityHandler(SecurityServicesFeature::registerCPrivateKeyOf, new Object[]{SecurityServicesFeature.method((Feature.FeatureAccess)a, "sun.security.mscapi.CKeyStore", "storePrivateKey", String.class, byte[].class, String.class, Integer.TYPE)});
            a.registerReachabilityHandler(SecurityServicesFeature::registerCPublicKeyOf, new Object[]{SecurityServicesFeature.method((Feature.FeatureAccess)a, "sun.security.mscapi.CSignature", "importECPublicKey", String.class, byte[].class, Integer.TYPE), SecurityServicesFeature.method((Feature.FeatureAccess)a, "sun.security.mscapi.CSignature", "importPublicKey", String.class, byte[].class, Integer.TYPE)});
        }
    }

    private static void registerLoadKeysOrCertificateChains(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Executable[])new Executable[]{SecurityServicesFeature.constructor((Feature.FeatureAccess)a, "java.util.ArrayList", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{SecurityServicesFeature.method((Feature.FeatureAccess)a, "sun.security.mscapi.CKeyStore", "generateCertificate", byte[].class, Collection.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{SecurityServicesFeature.method((Feature.FeatureAccess)a, "sun.security.mscapi.CKeyStore", "generateCertificateChain", String.class, Collection.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{SecurityServicesFeature.method((Feature.FeatureAccess)a, "sun.security.mscapi.CKeyStore", "generateKeyAndCertificateChain", Boolean.TYPE, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, Collection.class)});
    }

    private static void registerGenerateCKeyPair(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Executable[])new Executable[]{SecurityServicesFeature.constructor((Feature.FeatureAccess)a, "sun.security.mscapi.CKeyPair", String.class, Long.TYPE, Long.TYPE, Integer.TYPE)});
    }

    private static void registerCPrivateKeyOf(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Executable[])new Executable[]{SecurityServicesFeature.method((Feature.FeatureAccess)a, "sun.security.mscapi.CPrivateKey", "of", String.class, Long.TYPE, Long.TYPE, Integer.TYPE)});
    }

    private static void registerCPublicKeyOf(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Executable[])new Executable[]{SecurityServicesFeature.method((Feature.FeatureAccess)a, "sun.security.mscapi.CPublicKey", "of", String.class, Long.TYPE, Long.TYPE, Integer.TYPE)});
    }

    private static void linkJaas(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Field[])SecurityServicesFeature.fields((Feature.FeatureAccess)a, "com.sun.security.auth.module.UnixSystem", "username", "uid", "gid", "groups"));
        NativeLibraries nativeLibraries = ((FeatureImpl.DuringAnalysisAccessImpl)a).getNativeLibraries();
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("jaas");
        nativeLibraries.addStaticJniLibrary("jaas", new String[0]);
    }

    private static Set<Class<?>> computeKnownServices(Feature.BeforeAnalysisAccess access) {
        HashSet allKnownServices = new HashSet(knownServices);
        for (String value : Options.AdditionalSecurityServiceTypes.getValue().values()) {
            for (String serviceClazzName : value.split(",")) {
                Class serviceClazz = access.findClassByName(serviceClazzName);
                UserError.guarantee(serviceClazz != null, "Unable to find additional security service class %s", serviceClazzName);
                allKnownServices.add(serviceClazz);
            }
        }
        return allKnownServices;
    }

    private void registerSASLReachabilityHandlers(Feature.BeforeAnalysisAccess access) {
        String saslRegistrationFailureMessage = "Failed to enable automatic SASL provider registration: %s";
        String saslClassName = "javax.security.sasl.Sasl";
        try {
            TypeResult<Class<?>> saslClassLookup = this.loader.findClass(saslClassName);
            if (!saslClassLookup.isPresent()) {
                SecurityServicesFeature.trace(saslRegistrationFailureMessage, saslClassName);
                return;
            }
            Class<?> saslClass = saslClassLookup.getOrFail();
            this.classSaslClient = ReflectionUtil.lookupClass((boolean)false, (String)"javax.security.sasl.SaslClient");
            this.classSaslServer = ReflectionUtil.lookupClass((boolean)false, (String)"javax.security.sasl.SaslServer");
            Method createSaslClient = ReflectionUtil.lookupMethod(saslClass, (String)"createSaslClient", (Class[])new Class[]{String[].class, String.class, String.class, String.class, Map.class, CallbackHandler.class});
            access.registerReachabilityHandler(a -> this.registerServices((Feature.DuringAnalysisAccess)a, (Object)createSaslClient, this.classSaslClient), new Object[]{createSaslClient});
            Method createSaslServer = ReflectionUtil.lookupMethod(saslClass, (String)"createSaslServer", (Class[])new Class[]{String.class, String.class, String.class, Map.class, CallbackHandler.class});
            access.registerReachabilityHandler(a -> this.registerServices((Feature.DuringAnalysisAccess)a, (Object)createSaslServer, this.classSaslServer), new Object[]{createSaslServer});
        }
        catch (ReflectionUtil.ReflectionUtilError e) {
            SecurityServicesFeature.trace(saslRegistrationFailureMessage, new Object[]{e});
        }
    }

    private void registerServiceReachabilityHandlers(Feature.BeforeAnalysisAccess access) {
        this.ctrParamClassAccessor = SecurityServicesFeature.getConstructorParameterClassAccessor(this.loader);
        this.getSpiClassMethod = SecurityServicesFeature.getSpiClassMethod();
        this.availableServices = SecurityServicesFeature.computeAvailableServices();
        for (Class<?> serviceClass : SecurityServicesFeature.computeKnownServices(access)) {
            BiConsumer<Feature.DuringAnalysisAccess, Executable> handler = (a, t) -> this.registerServices((Feature.DuringAnalysisAccess)a, t, serviceClass);
            for (Method method : serviceClass.getMethods()) {
                if (!method.getName().equals("getInstance")) continue;
                SecurityServicesFeature.checkGetInstanceMethod(method);
                access.registerMethodOverrideReachabilityHandler(handler, (Executable)method);
            }
        }
        if (ModuleLayer.boot().findModule("java.security.sasl").isPresent()) {
            this.registerSASLReachabilityHandlers(access);
        }
        Optional<Method> defaultSecureRandomService = SecurityServicesFeature.optionalMethod((Feature.FeatureAccess)access, "java.security.Provider", "getDefaultSecureRandomService", new Class[0]);
        defaultSecureRandomService.ifPresent(m -> access.registerMethodOverrideReachabilityHandler((a, t) -> this.registerServices((Feature.DuringAnalysisAccess)a, t, SECURE_RANDOM_SERVICE), (Executable)m));
    }

    private void registerServices(Feature.DuringAnalysisAccess access, Object trigger, Class<?> serviceClass) {
        String serviceType = this.getServiceType(serviceClass);
        if (serviceClass.getPackage().getName().equals("java.security")) {
            SecurityServicesFeature.registerSpiClass(this.getSpiClassMethod, serviceType);
        }
        this.registerServices(access, trigger, serviceType);
    }

    private String getServiceType(Class<?> serviceClass) {
        Objects.requireNonNull(serviceClass);
        if (serviceClass == this.classSaslClient || serviceClass == this.classSaslServer) {
            return serviceClass.getSimpleName() + "Factory";
        }
        return serviceClass.getSimpleName();
    }

    private void registerServices(Feature.DuringAnalysisAccess access, Object trigger, String serviceType) {
        this.processedServiceClasses.computeIfAbsent(serviceType, k -> {
            this.doRegisterServices(access, trigger, serviceType);
            return true;
        });
    }

    private void doRegisterServices(Feature.DuringAnalysisAccess access, Object trigger, String serviceType) {
        try (TracingAutoCloseable ignored = SecurityServicesFeature.trace(access, trigger, serviceType);){
            Set<Provider.Service> services = this.availableServices.get(serviceType);
            for (Provider.Service service : services) {
                this.registerService(access, service);
            }
        }
    }

    private static void checkGetInstanceMethod(Method method) {
        VMError.guarantee(Modifier.isPublic(method.getModifiers()));
        VMError.guarantee(Modifier.isStatic(method.getModifiers()));
        VMError.guarantee(method.getReturnType().equals(method.getDeclaringClass()));
    }

    private static Map<String, Set<Provider.Service>> computeAvailableServices() {
        HashMap<String, Set<Provider.Service>> availableServices = new HashMap<String, Set<Provider.Service>>();
        for (Provider provider : Security.getProviders()) {
            for (Provider.Service s : provider.getServices()) {
                if (!SecurityServicesFeature.isValid(s)) continue;
                availableServices.computeIfAbsent(s.getType(), t -> new HashSet()).add(s);
            }
        }
        return availableServices;
    }

    private static boolean isValid(Provider.Service s) {
        return s.getType() != null && s.getAlgorithm() != null && s.getClassName() != null;
    }

    private static Function<String, Class<?>> getConstructorParameterClassAccessor(ImageClassLoader loader) {
        Map knownEngines = (Map)ReflectionUtil.readStaticField(Provider.class, (String)"knownEngines");
        Class<?> clazz = loader.findClassOrFail("java.security.Provider$EngineDescription");
        Field consParamClassField = ReflectionUtil.lookupField(clazz, (String)(JavaVersionUtil.JAVA_SPEC >= 23 ? "constructorParameterClass" : "constructorParameterClassName"));
        return serviceType -> {
            try {
                Object engineDescription = knownEngines.get(serviceType);
                if (engineDescription == null) {
                    return null;
                }
                if (JavaVersionUtil.JAVA_SPEC >= 23) {
                    return (Class)consParamClassField.get(engineDescription);
                }
                String constrParamClassName = (String)consParamClassField.get(engineDescription);
                if (constrParamClassName != null) {
                    return loader.findClass(constrParamClassName).get();
                }
            }
            catch (IllegalAccessException e) {
                VMError.shouldNotReachHere(e);
            }
            return null;
        };
    }

    private static Method getSpiClassMethod() {
        try {
            Method method = Security.class.getDeclaredMethod("getSpiClass", String.class);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private static void registerSpiClass(Method getSpiClassMethod, String serviceType) {
        try {
            Class spiClass = (Class)getSpiClassMethod.invoke(null, serviceType);
            RuntimeReflection.register((Class[])new Class[]{spiClass});
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void registerProvider(Provider provider) {
        if (this.usedProviders.add(provider)) {
            SecurityServicesFeature.registerForReflection(provider.getClass());
            provider.entrySet();
            try {
                Method getVerificationResult = ReflectionUtil.lookupMethod(this.jceSecurityClass, (String)"getVerificationResult", (Class[])new Class[]{Provider.class});
                getVerificationResult.invoke(null, provider);
            }
            catch (ReflectiveOperationException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }

    private void registerService(Feature.DuringAnalysisAccess a, Provider.Service service) {
        TypeResult<Class<?>> serviceClassResult = this.loader.findClass(service.getClassName());
        if (serviceClassResult.isPresent()) {
            try (TracingAutoCloseable ignored = SecurityServicesFeature.trace(service);){
                SecurityServicesFeature.registerForReflection(serviceClassResult.get());
                Class<?> ctrParamClass = this.ctrParamClassAccessor.apply(service.getType());
                if (ctrParamClass != null) {
                    SecurityServicesFeature.registerForReflection(ctrParamClass);
                    SecurityServicesFeature.trace("Registered service constructor parameter class: %s", ctrParamClass.getName());
                }
                if (SecurityServicesFeature.isSignature(service) || SecurityServicesFeature.isCipher(service) || SecurityServicesFeature.isKeyAgreement(service)) {
                    for (String keyClassName : SecurityServicesFeature.getSupportedKeyClasses(service)) {
                        this.loader.findClass(keyClassName).ifPresent(SecurityServicesFeature::registerForReflection);
                    }
                }
                if (SecurityServicesFeature.isKeyStore(service) && service.getAlgorithm().equals(JKS)) {
                    SecurityServicesFeature.registerJks(this.loader);
                }
                if (SecurityServicesFeature.isCertificateFactory(service) && service.getAlgorithm().equals(X509)) {
                    this.registerX509Extensions(a);
                }
                this.registerProvider(service.getProvider());
            }
        } else {
            SecurityServicesFeature.trace("Cannot register service %s. Reason: %s.", SecurityServicesFeature.asString(service), serviceClassResult.getException());
        }
    }

    private static void registerJks(ImageClassLoader loader) {
        Class<?> javaKeyStoreJks = loader.findClassOrFail("sun.security.provider.JavaKeyStore$JKS");
        SecurityServicesFeature.registerForReflection(javaKeyStoreJks);
        SecurityServicesFeature.trace("Registered KeyStore.JKS implementation class: %s", javaKeyStoreJks.getName());
    }

    private void registerX509Extensions(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        Map map = (Map)ReflectionUtil.readStaticField(OIDMap.class, (String)"nameMap");
        for (String name : map.keySet()) {
            try {
                Class<?> extensionClass = OIDMap.getClass(name);
                assert (Extension.class.isAssignableFrom(extensionClass));
                SecurityServicesFeature.registerForReflection(extensionClass);
                SecurityServicesFeature.trace("Registered X.509 extension class: %s", extensionClass.getName());
            }
            catch (CertificateException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        access.rescanRoot(this.oidMapField);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        this.maybeScanVerificationResultsField(access);
        this.maybeScanProvidersField(access);
        access.rescanRoot(this.oidTableField);
        if (this.cachedProviders != null) {
            for (Provider provider : this.cachedProviders.providers()) {
                for (Provider.Service service : provider.getServices()) {
                    access.rescanField(service, this.classCacheField);
                    access.rescanField(service, this.constructorCacheField);
                }
            }
        }
    }

    private void maybeScanVerificationResultsField(FeatureImpl.DuringAnalysisAccessImpl access) {
        if (access.getMetaAccess().lookupJavaField(this.verificationResultsField).isRead()) {
            try {
                ConcurrentHashMap<WeakReference<Provider>, Object> filteredVerificationCache = this.filterVerificationCache(this.verificationResultsField.get(null));
                if (this.cachedVerificationCache == null || !this.cachedVerificationCache.equals(filteredVerificationCache)) {
                    this.cachedVerificationCache = filteredVerificationCache;
                    access.rescanObject(this.cachedVerificationCache);
                }
            }
            catch (IllegalAccessException ex) {
                throw VMError.shouldNotReachHere("Cannot access field: " + this.verificationResultsField.getName(), ex);
            }
        }
    }

    private void maybeScanProvidersField(FeatureImpl.DuringAnalysisAccessImpl access) {
        if (access.getMetaAccess().lookupJavaField(this.providerListField).isRead()) {
            try {
                List<Provider> filteredProviders = this.filterProviderList(this.providerListField.get(null));
                if (this.cachedProviders == null || !this.cachedProviders.providers().equals(filteredProviders)) {
                    this.cachedProviders = ProviderList.newList(filteredProviders.toArray(new Provider[0]));
                    access.rescanObject(this.cachedProviders);
                }
            }
            catch (IllegalAccessException ex) {
                throw VMError.shouldNotReachHere("Cannot access field: " + this.providerListField.getName(), ex);
            }
        }
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
        SecurityServicesPrinter.endTracing();
    }

    private static void registerForReflection(Class<?> clazz) {
        RuntimeReflection.register((Class[])new Class[]{clazz});
        RuntimeReflection.register((Executable[])clazz.getConstructors());
    }

    private static boolean isSignature(Provider.Service s) {
        return s.getType().equals(SIGNATURE_SERVICE);
    }

    private static boolean isCipher(Provider.Service s) {
        return s.getType().equals(CIPHER_SERVICE);
    }

    private static boolean isKeyAgreement(Provider.Service s) {
        return s.getType().equals(KEY_AGREEMENT_SERVICE);
    }

    private static boolean isKeyStore(Provider.Service s) {
        return s.getType().equals(KEY_STORE);
    }

    private static boolean isCertificateFactory(Provider.Service s) {
        return s.getType().equals(CERTIFICATE_FACTORY);
    }

    private static String[] getSupportedKeyClasses(Provider.Service s) {
        assert (SecurityServicesFeature.isSignature(s) || SecurityServicesFeature.isCipher(s) || SecurityServicesFeature.isKeyAgreement(s));
        String supportedKeyClasses = s.getAttribute("SupportedKeyClasses");
        if (supportedKeyClasses != null) {
            return supportedKeyClasses.split("\\|");
        }
        return emptyStringArray;
    }

    private static void trace(String format, Object ... args) {
        SecurityServicesPrinter.trace((String indent) -> indent + String.format(format + "%n", args));
    }

    private static TracingAutoCloseable trace(final Provider.Service service) {
        return new TracingAutoCloseable(){
            {
                SecurityServicesPrinter.trace(indent -> String.format("%s%s%n", indent, SecurityServicesFeature.asString(service)));
                SecurityServicesPrinter.indent();
            }

            @Override
            public void close() {
                SecurityServicesPrinter.dedent();
            }
        };
    }

    private static TracingAutoCloseable trace(final Feature.DuringAnalysisAccess a, final Object trigger, final String serviceType) {
        return new TracingAutoCloseable(){
            {
                SecurityServicesPrinter.indent();
                SecurityServicesPrinter.trace(indent -> {
                    Method method = (Method)trigger;
                    FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
                    AnalysisMethod analysisMethod = access.getMetaAccess().lookupJavaMethod((Executable)method);
                    Object msg = String.format("Service factory method %s is reachable.%n", analysisMethod.asStackTraceElement(0));
                    msg = (String)msg + String.format("%sAnalysis parsing context: %s", indent, ReportUtils.parsingContext((AnalysisMethod)analysisMethod, (String)(indent + "    ")));
                    msg = (String)msg + String.format("%sReachability of %s service type API triggers registration of following services:%n", indent, serviceType);
                    return msg;
                });
                SecurityServicesPrinter.indent();
            }

            @Override
            public void close() {
                SecurityServicesPrinter.dedent();
                SecurityServicesPrinter.dedent();
                SecurityServicesFeature.trace("", new Object[0]);
            }
        };
    }

    private static String asString(Provider.Service s) {
        Object str = "";
        str = (String)str + "Type: " + s.getType() + ", ";
        str = (String)str + "Provider: " + s.getProvider().getName() + ", ";
        str = (String)str + "Algorithm: " + s.getAlgorithm() + ", ";
        str = (String)str + "Class: " + s.getClassName();
        if (SecurityServicesFeature.isSignature(s) || SecurityServicesFeature.isCipher(s) || SecurityServicesFeature.isKeyAgreement(s)) {
            str = (String)str + ", SupportedKeyClasses: " + Arrays.toString(SecurityServicesFeature.getSupportedKeyClasses(s));
        }
        return str;
    }

    static {
        ArrayList<Class> classList = new ArrayList<Class>(List.of(AlgorithmParameterGenerator.class, AlgorithmParameters.class, CertPathBuilder.class, CertPathValidator.class, CertStore.class, CertificateFactory.class, Cipher.class, Configuration.class, KeyAgreement.class, KeyFactory.class, KeyGenerator.class, KeyManagerFactory.class, KeyPairGenerator.class, KeyStore.class, Mac.class, MessageDigest.class, Policy.class, SSLContext.class, SecretKeyFactory.class, SecureRandom.class, Signature.class, TrustManagerFactory.class));
        if (ModuleLayer.boot().findModule("java.security.sasl").isPresent()) {
            classList.add(ReflectionUtil.lookupClass((boolean)false, (String)"javax.security.sasl.SaslClientFactory"));
            classList.add(ReflectionUtil.lookupClass((boolean)false, (String)"javax.security.sasl.SaslServerFactory"));
        }
        if (ModuleLayer.boot().findModule("java.xml.crypto").isPresent()) {
            classList.add(ReflectionUtil.lookupClass((boolean)false, (String)"javax.xml.crypto.dsig.TransformService"));
            classList.add(ReflectionUtil.lookupClass((boolean)false, (String)"javax.xml.crypto.dsig.XMLSignatureFactory"));
            classList.add(ReflectionUtil.lookupClass((boolean)false, (String)"javax.xml.crypto.dsig.keyinfo.KeyInfoFactory"));
        }
        if (ModuleLayer.boot().findModule("java.smartcardio").isPresent()) {
            classList.add(ReflectionUtil.lookupClass((boolean)false, (String)"javax.smartcardio.TerminalFactory"));
        }
        isMscapiModulePresent = ModuleLayer.boot().findModule("jdk.crypto.mscapi").isPresent();
        knownServices = Collections.unmodifiableList(classList);
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> EnableSecurityServicesFeature = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> TraceSecurityServices = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> AdditionalSecurityServiceTypes = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> AdditionalSecurityProviders = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
    }

    static class SecurityServicesPrinter {
        private static final int INDENT = 4;
        private static final boolean enabled = Options.TraceSecurityServices.getValue();
        private static final SecurityServicesPrinter instance = enabled ? new SecurityServicesPrinter() : null;
        private final PrintWriter writer;
        private int indent = 0;

        SecurityServicesPrinter() {
            File reportFile = SecurityServicesPrinter.reportFile(SubstrateOptions.reportsPath());
            System.out.println("# Printing security services automatic registration to: " + String.valueOf(reportFile));
            try {
                this.writer = new PrintWriter(new FileWriter(reportFile));
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        static void trace(Function<String, String> strFunction) {
            if (enabled) {
                String indent = "";
                if (SecurityServicesPrinter.instance.indent > 0) {
                    indent = String.format("%" + SecurityServicesPrinter.instance.indent + "s", " ");
                }
                SecurityServicesPrinter.instance.writer.print(strFunction.apply(indent));
            }
        }

        static void indent() {
            if (enabled) {
                SecurityServicesPrinter.instance.indent += 4;
            }
        }

        static void dedent() {
            if (enabled) {
                SecurityServicesPrinter.instance.indent -= 4;
            }
        }

        static void endTracing() {
            if (enabled) {
                SecurityServicesPrinter.instance.writer.close();
            }
        }

        private static File reportFile(String reportsPath) {
            return ReportUtils.reportFile((String)reportsPath, (String)"security_services", (String)"txt");
        }
    }

    static abstract class TracingAutoCloseable
    implements AutoCloseable {
        TracingAutoCloseable() {
        }

        @Override
        public abstract void close();
    }
}

