/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.hosted.ResourcesFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class EmbeddedResourcesInfo {
    private final ConcurrentHashMap<Resources.ModuleResourceKey, List<String>> registeredResources = new ConcurrentHashMap();

    public ConcurrentHashMap<Resources.ModuleResourceKey, List<String>> getRegisteredResources() {
        return this.registeredResources;
    }

    public static EmbeddedResourcesInfo singleton() {
        return (EmbeddedResourcesInfo)ImageSingletons.lookup(EmbeddedResourcesInfo.class);
    }

    public void declareResourceAsRegistered(Module module, String resource, String source) {
        if (!((ResourcesFeature)ImageSingletons.lookup(ResourcesFeature.class)).collectEmbeddedResourcesInfo()) {
            return;
        }
        Resources.ModuleResourceKey key = Resources.createStorageKey(module, resource);
        this.registeredResources.compute(key, (k, v) -> {
            if (v == null) {
                ArrayList<String> newValue = new ArrayList<String>();
                newValue.add(source);
                return newValue;
            }
            if (!v.contains(source)) {
                v.add(source);
            }
            return v;
        });
    }
}

