/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.graal.code.SubstrateCompiledCode;
import com.oracle.svm.core.graal.meta.SharedCodeCacheProvider;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.RuntimeCodeInstaller;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;

public class SubstrateCodeCacheProvider
extends SharedCodeCacheProvider {
    protected SubstrateCodeCacheProvider(TargetDescription target, RegisterConfig registerConfig) {
        super(target, registerConfig);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="We know what we are doing.")
    public InstalledCode installCode(ResolvedJavaMethod method, CompiledCode compiledCode, InstalledCode predefinedInstalledCode, SpeculationLog log, boolean isDefault) {
        VMError.guarantee(!isDefault);
        SubstrateInstalledCode substrateInstalledCode = predefinedInstalledCode instanceof SubstrateInstalledCode.Factory ? ((SubstrateInstalledCode.Factory)predefinedInstalledCode).createSubstrateInstalledCode() : (SubstrateInstalledCode)predefinedInstalledCode;
        CompilationResult compResult = ((SubstrateCompiledCode)compiledCode).getCompilationResult();
        substrateInstalledCode.setCompilationId(compResult.getCompilationId());
        RuntimeCodeInstaller.install((SharedRuntimeMethod)method, compResult, substrateInstalledCode);
        return predefinedInstalledCode;
    }
}

