/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.thread.ThreadCpuTimeSupport;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={ThreadCpuTimeSupport.class})
final class WindowsThreadCpuTimeSupport
implements ThreadCpuTimeSupport {
    WindowsThreadCpuTimeSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCurrentThreadCpuTime(boolean includeSystemTime) {
        return this.getThreadCpuTime(CurrentIsolate.getCurrentThread(), includeSystemTime);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadCpuTime(IsolateThread isolateThread, boolean includeSystemTime) {
        WinBase.HANDLE hThread = (WinBase.HANDLE)((Object)VMThreads.getOSThreadHandle(isolateThread));
        return WindowsThreadCpuTimeSupport.getThreadCpuTime(hThread, includeSystemTime);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+26/src/hotspot/os/windows/os_windows.cpp#L4960-L4976")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long getThreadCpuTime(WinBase.HANDLE hThread, boolean includeSystemTime) {
        WinBase.FILETIME user;
        WinBase.FILETIME kernel;
        WinBase.FILETIME exit;
        WinBase.FILETIME create = (WinBase.FILETIME)StackValue.get(WinBase.FILETIME.class);
        if (Process.NoTransitions.GetThreadTimes(hThread, create, exit = (WinBase.FILETIME)StackValue.get(WinBase.FILETIME.class), kernel = (WinBase.FILETIME)StackValue.get(WinBase.FILETIME.class), user = (WinBase.FILETIME)StackValue.get(WinBase.FILETIME.class)) == 0) {
            return -1L;
        }
        UnsignedWord userNanos = WindowsThreadCpuTimeSupport.fileTimeToNanos(user);
        if (includeSystemTime) {
            UnsignedWord kernelNanos = WindowsThreadCpuTimeSupport.fileTimeToNanos(kernel);
            return userNanos.add(kernelNanos).rawValue();
        }
        return userNanos.rawValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord fileTimeToNanos(WinBase.FILETIME ft) {
        UnsignedWord value = WordFactory.unsigned((int)ft.dwHighDateTime()).shiftLeft(32).or(WordFactory.unsigned((int)ft.dwLowDateTime()));
        return value.multiply(100);
    }
}

