/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.Target_jdk_internal_misc_Signal;
import com.oracle.svm.core.windows.headers.WinBase;
import java.util.Locale;
import org.graalvm.nativeimage.c.function.CFunction;

class SignalDispatcher
implements Runnable {
    private static final int NEAR_MAX_PRIORITY = 9;
    private static final Thread signalDispatcherThread = new Thread(PlatformThreads.singleton().systemGroup, new SignalDispatcher(), "Signal Dispatcher");

    SignalDispatcher() {
    }

    @Override
    public void run() {
        int sig;
        while ((sig = SignalDispatcher.osSignalWait()) != SignalDispatcher.osSigexitnumPd()) {
            Target_jdk_internal_misc_Signal.dispatch(sig);
        }
        return;
    }

    @CFunction(value="os__signal_wait")
    private static native int osSignalWait();

    @CFunction(value="os__sigexitnum_pd", transition=CFunction.Transition.NO_TRANSITION)
    private static native int osSigexitnumPd();

    static void ensureInitialized() {
        if (signalDispatcherThread.getState() == Thread.State.NEW) {
            if (!SignalDispatcher.jdkMiscSignalInit()) {
                VMError.shouldNotReachHere("Native state initialization for jdk.internal.misc.Signal failed with error code: 0x" + Integer.toUnsignedString(WinBase.GetLastError(), 16).toUpperCase(Locale.ROOT));
            }
            RuntimeSupport.getRuntimeSupport().addTearDownHook(isFirstIsolate -> SignalDispatcher.osTerminateSignalThread());
            signalDispatcherThread.start();
        }
    }

    @CFunction(value="jdk_misc_signal_init", transition=CFunction.Transition.NO_TRANSITION)
    private static native boolean jdkMiscSignalInit();

    @CFunction(value="os__terminate_signal_thread", transition=CFunction.Transition.NO_TRANSITION)
    private static native void osTerminateSignalThread();

    static {
        signalDispatcherThread.setPriority(9);
        signalDispatcherThread.setDaemon(true);
    }
}

