/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.nodes.LoadOpenTypeWorldDispatchTableStartingOffset;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.reflect.MethodAccessorJDK19;
import com.oracle.svm.core.reflect.ReflectionAccessorHolder;
import com.oracle.svm.core.reflect.SubstrateAccessor;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.word.BarrieredAccess;
import jdk.internal.reflect.MethodAccessor;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@InternalVMMethod
public final class SubstrateMethodAccessor
extends SubstrateAccessor
implements MethodAccessor,
MethodAccessorJDK19 {
    public static final int STATICALLY_BOUND = -1;
    public static final int OFFSET_NOT_YET_COMPUTED = -559087615;
    public static final int INTERFACE_TYPEID_CLASS_TABLE = -1;
    private final Class<?> receiverType;
    private int vtableOffset;
    private int interfaceTypeID;
    private final boolean callerSensitiveAdapter;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateMethodAccessor(Executable member, Class<?> receiverType, CFunctionPointer expandSignature, CFunctionPointer directTarget, ResolvedJavaMethod targetMethod, int vtableOffset, DynamicHub initializeBeforeInvoke, boolean callerSensitiveAdapter) {
        super(member, expandSignature, directTarget, targetMethod, initializeBeforeInvoke);
        this.receiverType = receiverType;
        this.vtableOffset = vtableOffset;
        this.interfaceTypeID = -559087615;
        this.callerSensitiveAdapter = callerSensitiveAdapter;
    }

    public int getVTableOffset() {
        return this.vtableOffset;
    }

    public int getInterfaceTypeID() {
        return this.interfaceTypeID;
    }

    private void preInvoke(Object obj) {
        if (this.initializeBeforeInvoke != null) {
            EnsureClassInitializedNode.ensureClassInitialized(DynamicHub.toClass(this.initializeBeforeInvoke));
        }
        if (this.receiverType != null) {
            if (obj == null) {
                throw new NullPointerException();
            }
            if (!this.receiverType.isInstance(obj)) {
                throw new IllegalArgumentException("Receiver type " + obj.getClass().getTypeName() + " is not an instance of the declaring class " + this.receiverType.getTypeName());
            }
        }
    }

    private CFunctionPointer invokeTarget(Object obj) {
        CFunctionPointer target;
        if (SubstrateOptions.closedTypeWorld()) {
            if (this.vtableOffset == -559087615) {
                throw VMError.shouldNotReachHere("Missed vtableOffset recomputation at image build time");
            }
            CFunctionPointer target2 = this.vtableOffset != -1 ? (CFunctionPointer)BarrieredAccess.readWord(obj.getClass(), (int)this.vtableOffset, (LocationIdentity)NamedLocationIdentity.FINAL_LOCATION) : this.directTarget;
            return target2;
        }
        if (this.vtableOffset == -559087615) {
            throw VMError.shouldNotReachHere("Missed vtableOffset recomputation at image build time");
        }
        if (this.vtableOffset != -1) {
            long tableStartingOffset = LoadOpenTypeWorldDispatchTableStartingOffset.createOpenTypeWorldLoadDispatchTableStartingOffset(obj.getClass(), this.interfaceTypeID);
            long methodOffset = tableStartingOffset + (long)this.vtableOffset;
            target = (CFunctionPointer)BarrieredAccess.readWord(obj.getClass(), (WordBase)WordFactory.pointer((long)methodOffset), (LocationIdentity)NamedLocationIdentity.FINAL_LOCATION);
        } else {
            target = this.directTarget;
        }
        return target;
    }

    @Override
    public Object invoke(Object obj, Object[] args) {
        if (this.callerSensitiveAdapter) {
            throw VMError.shouldNotReachHere("Cannot invoke method that has a @CallerSensitiveAdapter without an explicit caller");
        }
        this.preInvoke(obj);
        return ((ReflectionAccessorHolder.MethodInvokeFunctionPointer)this.expandSignature).invoke(obj, args, this.invokeTarget(obj));
    }

    @Override
    public Object invoke(Object obj, Object[] args, Class<?> caller) {
        if (this.callerSensitiveAdapter) {
            this.preInvoke(obj);
            return ((ReflectionAccessorHolder.MethodInvokeFunctionPointerForCallerSensitiveAdapter)this.expandSignature).invoke(obj, args, this.invokeTarget(obj), caller);
        }
        return this.invoke(obj, args);
    }

    @Override
    public Object invokeSpecial(Object obj, Object[] args) {
        if (this.callerSensitiveAdapter) {
            throw VMError.shouldNotReachHere("Cannot invoke method that has a @CallerSensitiveAdapter without an explicit caller");
        }
        this.preInvoke(obj);
        return super.invokeSpecial(obj, args);
    }
}

