/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.access;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jni.MissingJNIRegistrationUtils;
import com.oracle.svm.core.jni.access.JNIAccessibleClass;
import com.oracle.svm.core.jni.access.JNIAccessibleField;
import com.oracle.svm.core.jni.access.JNIAccessibleMethod;
import com.oracle.svm.core.jni.access.JNIAccessibleMethodDescriptor;
import com.oracle.svm.core.jni.access.JNINativeLinkage;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.Utf8;
import com.oracle.svm.core.util.VMError;
import java.io.PrintStream;
import java.util.Map;
import java.util.function.Function;
import jdk.graal.compiler.util.SignatureUtil;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class JNIReflectionDictionary {
    static final Equivalence WRAPPED_CSTRING_EQUIVALENCE = new Equivalence(){

        public boolean equals(Object a, Object b) {
            return CharSequence.compare((CharSequence)a, (CharSequence)b) == 0;
        }

        public int hashCode(Object o) {
            assert (o instanceof String || o instanceof Utf8.WrappedAsciiCString);
            return o.hashCode();
        }
    };
    private static final JNIAccessibleClass NEGATIVE_CLASS_LOOKUP = new JNIAccessibleClass();
    private final EconomicMap<CharSequence, JNIAccessibleClass> classesByName = ImageHeapMap.create(WRAPPED_CSTRING_EQUIVALENCE);
    private final EconomicMap<Class<?>, JNIAccessibleClass> classesByClassObject = ImageHeapMap.create();
    private final EconomicMap<JNINativeLinkage, JNINativeLinkage> nativeLinkages = ImageHeapMap.create();

    public static void create() {
        ImageSingletons.add(JNIReflectionDictionary.class, (Object)new JNIReflectionDictionary());
    }

    public static JNIReflectionDictionary singleton() {
        return (JNIReflectionDictionary)ImageSingletons.lookup(JNIReflectionDictionary.class);
    }

    private JNIReflectionDictionary() {
    }

    private void dump(boolean condition, String label) {
        if (SubstrateOptions.JNIVerboseLookupErrors.getValue().booleanValue() && condition) {
            PrintStream ps = Log.logStream();
            ps.println(label);
            ps.println(" classesByName:");
            MapCursor nameCursor = this.classesByName.getEntries();
            while (nameCursor.advance()) {
                ps.print("  ");
                ps.println(nameCursor.getKey());
                JNIAccessibleClass clazz = (JNIAccessibleClass)nameCursor.getValue();
                ps.println("   methods:");
                MapCursor<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> methodsCursor = clazz.getMethods();
                while (methodsCursor.advance()) {
                    ps.print("      ");
                    ps.print(((JNIAccessibleMethodDescriptor)methodsCursor.getKey()).getName());
                    ps.println(((JNIAccessibleMethodDescriptor)methodsCursor.getKey()).getSignature());
                }
                ps.println("   fields:");
                UnmodifiableMapCursor<CharSequence, JNIAccessibleField> fieldsCursor = clazz.getFields();
                while (fieldsCursor.advance()) {
                    ps.print("      ");
                    ps.println(fieldsCursor.getKey());
                }
            }
            ps.println(" classesByClassObject:");
            MapCursor cursor = this.classesByClassObject.getEntries();
            while (cursor.advance()) {
                ps.print("  ");
                ps.println(cursor.getKey());
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JNIAccessibleClass addClassIfAbsent(Class<?> classObj, Function<Class<?>, JNIAccessibleClass> mappingFunction) {
        if (!this.classesByClassObject.containsKey(classObj)) {
            JNIAccessibleClass instance = mappingFunction.apply(classObj);
            this.classesByClassObject.put(classObj, (Object)instance);
            String name = instance.getInternalName();
            if (name.charAt(0) == 'L') {
                assert (name.charAt(name.length() - 1) == ';');
                name = name.substring(1, name.length() - 1);
            }
            this.classesByName.put((Object)name, (Object)instance);
        }
        return (JNIAccessibleClass)this.classesByClassObject.get(classObj);
    }

    public void addNegativeClassLookupIfAbsent(String typeName) {
        String internalName = MetaUtil.toInternalName((String)typeName);
        String queryName = internalName.startsWith("L") ? internalName.substring(1, internalName.length() - 1) : internalName;
        this.classesByName.putIfAbsent((Object)queryName, (Object)NEGATIVE_CLASS_LOOKUP);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addLinkages(Map<JNINativeLinkage, JNINativeLinkage> linkages) {
        this.nativeLinkages.putAll(EconomicMap.wrapMap(linkages));
    }

    public Iterable<JNIAccessibleClass> getClasses() {
        return this.classesByClassObject.getValues();
    }

    public Class<?> getClassObjectByName(CharSequence name) {
        JNIAccessibleClass clazz = (JNIAccessibleClass)this.classesByName.get((Object)name);
        this.dump((clazz = JNIReflectionDictionary.checkClass(clazz, name)) == null, "getClassObjectByName");
        return clazz != null ? clazz.getClassObject() : null;
    }

    private static JNIAccessibleClass checkClass(JNIAccessibleClass clazz, CharSequence name) {
        if (MissingRegistrationUtils.throwMissingRegistrationErrors() && clazz == null) {
            MissingJNIRegistrationUtils.forClass(name.toString());
        } else if (clazz != null && clazz.isNegative()) {
            return null;
        }
        return clazz;
    }

    public JNINativeLinkage getLinkage(CharSequence declaringClass, CharSequence name, CharSequence descriptor) {
        JNINativeLinkage key = new JNINativeLinkage(declaringClass, name, descriptor);
        return (JNINativeLinkage)this.nativeLinkages.get((Object)key);
    }

    public void unsetEntryPoints(String declaringClass) {
        for (JNINativeLinkage linkage : this.nativeLinkages.getKeys()) {
            if (!declaringClass.equals(linkage.getDeclaringClassName())) continue;
            linkage.unsetEntryPoint();
        }
    }

    private JNIAccessibleMethod findMethod(Class<?> clazz, JNIAccessibleMethodDescriptor descriptor, String dumpLabel) {
        JNIAccessibleMethod method = this.getDeclaredMethod(clazz, descriptor, dumpLabel);
        if (descriptor.isConstructor() || descriptor.isClassInitializer()) {
            return method;
        }
        if (method == null && clazz.getSuperclass() != null) {
            method = this.findMethod(clazz.getSuperclass(), descriptor, null);
        }
        if (method == null) {
            method = this.findSuperinterfaceMethod(clazz, descriptor);
        }
        return method;
    }

    private JNIAccessibleMethod findSuperinterfaceMethod(Class<?> clazz, JNIAccessibleMethodDescriptor descriptor) {
        for (Class<?> parent : clazz.getInterfaces()) {
            JNIAccessibleMethod method = this.getDeclaredMethod(parent, descriptor, null);
            if (method == null) {
                method = this.findSuperinterfaceMethod(parent, descriptor);
            }
            if (method == null || !method.isPublic() || method.isStatic()) continue;
            return method;
        }
        return null;
    }

    public JNIMethodId getDeclaredMethodID(Class<?> classObject, JNIAccessibleMethodDescriptor descriptor, boolean isStatic) {
        JNIAccessibleMethod method = this.getDeclaredMethod(classObject, descriptor, "getDeclaredMethodID");
        boolean match = method != null && method.isStatic() == isStatic;
        return JNIReflectionDictionary.toMethodID(match ? method : null);
    }

    private JNIAccessibleMethod getDeclaredMethod(Class<?> classObject, JNIAccessibleMethodDescriptor descriptor, String dumpLabel) {
        JNIAccessibleClass clazz = (JNIAccessibleClass)this.classesByClassObject.get(classObject);
        this.dump(clazz == null && dumpLabel != null, dumpLabel);
        JNIAccessibleMethod method = null;
        if (clazz != null) {
            method = clazz.getMethod(descriptor);
        }
        return method;
    }

    public JNIMethodId getMethodID(Class<?> classObject, CharSequence name, CharSequence signature, boolean isStatic) {
        JNIAccessibleMethod method = this.findMethod(classObject, new JNIAccessibleMethodDescriptor(name, signature), "getMethodID");
        boolean match = (method = JNIReflectionDictionary.checkMethod(method, classObject, name, signature)) != null && method.isStatic() == isStatic && method.isDiscoverableIn(classObject);
        return JNIReflectionDictionary.toMethodID(match ? method : null);
    }

    private static JNIMethodId toMethodID(JNIAccessibleMethod method) {
        SignedWord value = (SignedWord)WordFactory.zero();
        if (method != null) {
            value = Word.objectToUntrackedPointer((Object)method);
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                value = value.subtract((SignedWord)Isolates.getHeapBase(CurrentIsolate.getIsolate()));
            }
        }
        return (JNIMethodId)value;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static JNIAccessibleMethod getMethodByID(JNIMethodId method) {
        JNIAccessibleMethod jniMethod;
        Pointer p = (Pointer)method;
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            p = p.add((UnsignedWord)Isolates.getHeapBase(CurrentIsolate.getIsolate()));
        }
        VMError.guarantee((jniMethod = (JNIAccessibleMethod)p.toObject(JNIAccessibleMethod.class, false)) == null || !jniMethod.isNegative(), "Existing methods can't correspond to a negative query");
        return jniMethod;
    }

    private static JNIAccessibleMethod checkMethod(JNIAccessibleMethod method, Class<?> clazz, CharSequence name, CharSequence signature) {
        if (MissingRegistrationUtils.throwMissingRegistrationErrors() && method == null && SignatureUtil.isSignatureValid((String)signature.toString(), (boolean)false)) {
            MissingJNIRegistrationUtils.forMethod(clazz, name.toString(), signature.toString());
        } else if (method != null && method.isNegative()) {
            return null;
        }
        return method;
    }

    private JNIAccessibleField getDeclaredField(Class<?> classObject, CharSequence name, boolean isStatic, String dumpLabel) {
        JNIAccessibleField field;
        JNIAccessibleClass clazz = (JNIAccessibleClass)this.classesByClassObject.get(classObject);
        this.dump(clazz == null && dumpLabel != null, dumpLabel);
        if (clazz != null && (field = clazz.getField(name)) != null && (field.isStatic() == isStatic || field.isNegative())) {
            return field;
        }
        return null;
    }

    public JNIFieldId getDeclaredFieldID(Class<?> classObject, String name, boolean isStatic) {
        JNIAccessibleField field = this.getDeclaredField(classObject, name, isStatic, "getDeclaredFieldID");
        return (field = JNIReflectionDictionary.checkField(field, classObject, name)) != null ? field.getId() : (JNIFieldId)WordFactory.nullPointer();
    }

    private JNIAccessibleField findField(Class<?> clazz, CharSequence name, boolean isStatic, String dumpLabel) {
        JNIAccessibleField field = this.getDeclaredField(clazz, name, isStatic, dumpLabel);
        if (field == null && isStatic) {
            field = this.findSuperinterfaceField(clazz, name);
        }
        if (field == null && clazz.getSuperclass() != null) {
            field = this.findField(clazz.getSuperclass(), name, isStatic, null);
        }
        return field;
    }

    private JNIAccessibleField findSuperinterfaceField(Class<?> clazz, CharSequence name) {
        for (Class<?> parent : clazz.getInterfaces()) {
            JNIAccessibleField field = this.getDeclaredField(parent, name, true, null);
            if (field == null) {
                field = this.findSuperinterfaceField(parent, name);
            }
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public JNIFieldId getFieldID(Class<?> clazz, CharSequence name, boolean isStatic) {
        JNIAccessibleField field = this.findField(clazz, name, isStatic, "getFieldID");
        return (field = JNIReflectionDictionary.checkField(field, clazz, name)) != null && field.isDiscoverableIn(clazz) ? field.getId() : (JNIFieldId)WordFactory.nullPointer();
    }

    public String getFieldNameByID(Class<?> classObject, JNIFieldId id) {
        JNIAccessibleClass clazz = (JNIAccessibleClass)this.classesByClassObject.get(classObject);
        if (clazz != null) {
            UnmodifiableMapCursor<CharSequence, JNIAccessibleField> fieldsCursor = clazz.getFields();
            while (fieldsCursor.advance()) {
                JNIAccessibleField field = (JNIAccessibleField)fieldsCursor.getValue();
                if (!id.equal((ComparableWord)field.getId())) continue;
                VMError.guarantee(!field.isNegative(), "Existing fields can't correspond to a negative query");
                return (String)fieldsCursor.getKey();
            }
        }
        return null;
    }

    private static JNIAccessibleField checkField(JNIAccessibleField field, Class<?> clazz, CharSequence name) {
        if (MissingRegistrationUtils.throwMissingRegistrationErrors() && field == null) {
            MissingJNIRegistrationUtils.forField(clazz, name.toString());
        } else if (field != null && field.isNegative()) {
            return null;
        }
        return field;
    }

    public static JNIAccessibleMethodDescriptor getMethodDescriptor(JNIAccessibleMethod method) {
        if (method != null) {
            JNIAccessibleClass clazz = method.getDeclaringClass();
            MapCursor<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> cursor = clazz.getMethods();
            while (cursor.advance()) {
                if (cursor.getValue() != method) continue;
                return (JNIAccessibleMethodDescriptor)cursor.getKey();
            }
        }
        return null;
    }
}

