/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.configure.ConditionalRuntimeValue;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ByteArrayChannel;
import com.oracle.svm.core.jdk.resources.NativeImageResourceFileAttributes;
import com.oracle.svm.core.jdk.resources.NativeImageResourceFileStore;
import com.oracle.svm.core.jdk.resources.NativeImageResourceFileSystemException;
import com.oracle.svm.core.jdk.resources.NativeImageResourceFileSystemProvider;
import com.oracle.svm.core.jdk.resources.NativeImageResourceFileSystemUtil;
import com.oracle.svm.core.jdk.resources.NativeImageResourcePath;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntryBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.graalvm.collections.MapCursor;

public class NativeImageResourceFileSystem
extends FileSystem {
    private static final String GLOB_SYNTAX = "glob";
    private static final String REGEX_SYNTAX = "regex";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final Set<String> supportedFileAttributeViews = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic", "resource")));
    private final Set<InputStream> inputStreams = Collections.synchronizedSet(new HashSet());
    private final Set<OutputStream> outputStreams = Collections.synchronizedSet(new HashSet());
    private final Set<Path> tmpPaths = Collections.synchronizedSet(new HashSet());
    private final long defaultTimestamp = System.currentTimeMillis();
    private final NativeImageResourceFileSystemProvider provider;
    private final Path resourcePath;
    private final NativeImageResourcePath root;
    private boolean isOpen = true;
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private static final byte[] ROOT_PATH = new byte[]{47};
    private final IndexNode lookupKey = new IndexNode(null, true, false);
    private final LinkedHashMap<IndexNode, IndexNode> inodes = new LinkedHashMap(10);

    public NativeImageResourceFileSystem(NativeImageResourceFileSystemProvider provider, Path resourcePath, Map<String, ?> env) {
        this.provider = provider;
        this.resourcePath = resourcePath;
        this.root = new NativeImageResourcePath(this, new byte[]{47});
        if (!NativeImageResourceFileSystem.isTrue(env)) {
            throw new FileSystemNotFoundException(resourcePath.toString());
        }
        this.readAllEntries();
    }

    private static boolean isTrue(Map<String, ?> env) {
        return env.isEmpty() || "true".equals(env.get("create")) || Boolean.TRUE.equals(env.get("create"));
    }

    private void ensureOpen() {
        if (!this.isOpen) {
            throw new ClosedFileSystemException();
        }
    }

    private void beginWrite() {
        this.rwlock.writeLock().lock();
    }

    private void endWrite() {
        this.rwlock.writeLock().unlock();
    }

    private void beginRead() {
        this.rwlock.readLock().lock();
    }

    private void endRead() {
        this.rwlock.readLock().unlock();
    }

    byte[] getBytes(String path) {
        return path.getBytes(StandardCharsets.UTF_8);
    }

    String getString(byte[] path) {
        return new String(path, StandardCharsets.UTF_8);
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        HashSet<Closeable> copy;
        this.beginWrite();
        try {
            if (!this.isOpen) {
                return;
            }
            this.isOpen = false;
        }
        finally {
            this.endWrite();
        }
        if (!this.inputStreams.isEmpty()) {
            copy = new HashSet<InputStream>(this.inputStreams);
            for (InputStream inputStream : copy) {
                inputStream.close();
            }
        }
        if (!this.outputStreams.isEmpty()) {
            copy = new HashSet<OutputStream>(this.outputStreams);
            for (OutputStream outputStream : copy) {
                outputStream.close();
            }
        }
        this.provider.removeFileSystem();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(this.root);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections.singleton(new NativeImageResourceFileStore(this.root));
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return supportedFileAttributeViews;
    }

    Path getResourcePath() {
        return this.resourcePath;
    }

    public String toString() {
        return this.resourcePath.toString();
    }

    @Override
    public Path getPath(String first, String ... more) {
        String path;
        if (more.length == 0) {
            path = first;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(first);
            for (String segment : more) {
                if (segment.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(segment);
            }
            path = sb.toString();
        }
        return new NativeImageResourcePath(this, this.getBytes(path));
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        String expr;
        int pos = syntaxAndPattern.indexOf(58);
        if (pos <= 0 || pos == syntaxAndPattern.length()) {
            throw new IllegalArgumentException();
        }
        String syntax = syntaxAndPattern.substring(0, pos);
        String input = syntaxAndPattern.substring(pos + 1);
        if (syntax.equals(GLOB_SYNTAX)) {
            expr = NativeImageResourceFileSystemUtil.toRegexPattern(input);
        } else if (syntax.equals(REGEX_SYNTAX)) {
            expr = input;
        } else {
            throw new UnsupportedOperationException("Syntax '" + syntax + "' not recognized");
        }
        Pattern pattern = Pattern.compile(expr);
        return path -> pattern.matcher(path.toString()).matches();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NativeImageResourceFileAttributes getFileAttributes(byte[] path) {
        Entry entry;
        this.beginRead();
        try {
            this.ensureOpen();
            entry = this.getEntry(path);
            if (entry == null) {
                IndexNode inode = this.getInode(path);
                if (inode == null) {
                    NativeImageResourceFileAttributes nativeImageResourceFileAttributes = null;
                    return nativeImageResourceFileAttributes;
                }
                entry = new Entry(inode.name, inode.isDir, inode.isComplete);
                entry.lastAccessTime = entry.createTime = this.defaultTimestamp;
                entry.lastModifiedTime = entry.createTime;
            }
        }
        finally {
            this.endRead();
        }
        return new NativeImageResourceFileAttributes(this, entry);
    }

    static void checkOptions(Set<? extends OpenOption> options) {
        for (OpenOption openOption : options) {
            if (openOption == null) {
                throw new NullPointerException();
            }
            if (openOption instanceof StandardOpenOption) continue;
            throw new IllegalArgumentException();
        }
        if (options.contains(StandardOpenOption.APPEND) && options.contains(StandardOpenOption.TRUNCATE_EXISTING)) {
            throw new IllegalArgumentException("APPEND + TRUNCATE_EXISTING are not allowed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SeekableByteChannel newByteChannel(byte[] path, Set<? extends OpenOption> options) throws IOException {
        NativeImageResourceFileSystem.checkOptions(options);
        if (options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.APPEND)) {
            this.beginRead();
            try {
                Entry e = this.getEntry(path);
                if (e != null) {
                    if (e.isDir() || options.contains(StandardOpenOption.CREATE_NEW)) {
                        throw new FileAlreadyExistsException(this.getString(path));
                    }
                    EntryOutputChannel sbc = new EntryOutputChannel(new Entry(e, 1));
                    if (options.contains(StandardOpenOption.APPEND)) {
                        try (InputStream is = this.getInputStream(e);){
                            sbc.write(ByteBuffer.wrap(NativeImageResourceFileSystemUtil.inputStreamToByteArray(is)));
                        }
                    }
                    EntryOutputChannel entryOutputChannel = sbc;
                    return entryOutputChannel;
                }
                if (!options.contains(StandardOpenOption.CREATE) && !options.contains(StandardOpenOption.CREATE_NEW)) {
                    throw new NoSuchFileException(this.getString(path));
                }
                this.checkParents(path);
                EntryOutputChannel sbc = new EntryOutputChannel(new Entry(path, false, false));
                return sbc;
            }
            finally {
                this.endRead();
            }
        }
        this.beginRead();
        try {
            ByteArrayChannel byteArrayChannel;
            block26: {
                this.ensureOpen();
                Entry e = this.getEntry(path);
                if (e == null || e.isDir()) {
                    throw new NoSuchFileException(this.getString(path));
                }
                InputStream is = this.getInputStream(e);
                try {
                    byteArrayChannel = new ByteArrayChannel(NativeImageResourceFileSystemUtil.inputStreamToByteArray(is), true);
                    if (is == null) break block26;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return byteArrayChannel;
        }
        finally {
            this.endRead();
        }
    }

    boolean exists(byte[] path) {
        this.beginRead();
        try {
            this.ensureOpen();
            boolean bl = this.getInode(path) != null;
            return bl;
        }
        finally {
            this.endRead();
        }
    }

    static FileStore getFileStore(NativeImageResourcePath path) {
        return new NativeImageResourceFileStore(path);
    }

    void checkAccess(byte[] path) throws NoSuchFileException {
        this.beginRead();
        try {
            this.ensureOpen();
            if (this.getInode(path) == null) {
                throw new NoSuchFileException(this.toString());
            }
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimes(byte[] path, FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws NoSuchFileException {
        this.beginWrite();
        try {
            this.ensureOpen();
            Entry e = this.getEntry(path);
            if (e == null) {
                throw new NoSuchFileException(this.getString(path));
            }
            if (lastModifiedTime != null) {
                e.lastModifiedTime = lastModifiedTime.toMillis();
            }
            if (lastAccessTime != null) {
                e.lastAccessTime = lastAccessTime.toMillis();
            }
            if (createTime != null) {
                e.createTime = createTime.toMillis();
            }
            this.update(e);
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirectory(byte[] path) {
        this.beginRead();
        try {
            IndexNode n = this.getInode(path);
            boolean bl = n != null && n.isDir();
            return bl;
        }
        finally {
            this.endRead();
        }
    }

    void createDirectory(byte[] dir) throws IOException {
        this.beginWrite();
        try {
            this.ensureOpen();
            if (dir.length == 0 || this.exists(dir)) {
                throw new FileAlreadyExistsException(this.getString(dir));
            }
            this.checkParents(dir);
            Entry e = new Entry(dir, true, false);
            this.update(e);
        }
        finally {
            this.endWrite();
        }
    }

    boolean deleteFile(byte[] path, boolean failIfNotExists) throws IOException {
        IndexNode inode = this.getInode(path);
        if (inode == null) {
            if (path.length == 0) {
                throw new NativeImageResourceFileSystemException("Root directory </> can't be deleted!");
            }
            if (failIfNotExists) {
                throw new NoSuchFileException(this.getString(path));
            }
            return false;
        }
        if (inode.isDir() && inode.child != null) {
            throw new DirectoryNotEmptyException(this.getString(path));
        }
        this.updateDelete(inode);
        return true;
    }

    private Path createTempFileInSameDirectoryAs() throws IOException {
        Path tmpPath = Files.createTempFile("rfs_tmp", null, new FileAttribute[0]);
        this.tmpPaths.add(tmpPath);
        return tmpPath;
    }

    private Path getTempPathForEntry(byte[] path) throws IOException {
        Entry e;
        Path tmpPath = this.createTempFileInSameDirectoryAs();
        if (path != null && (e = this.getEntry(path)) != null) {
            try (InputStream is = this.newInputStream(path);){
                Files.copy(is, tmpPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return tmpPath;
    }

    private void removeTempPathForEntry(Path path) throws IOException {
        Files.delete(path);
        this.tmpPaths.remove(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyFile(boolean deleteSource, byte[] src, byte[] dst, CopyOption[] options) throws IOException {
        if (Arrays.equals(src, dst)) {
            return;
        }
        this.beginWrite();
        try {
            this.ensureOpen();
            Entry eSrc = this.getEntry(src);
            if (eSrc == null) {
                throw new NoSuchFileException(this.getString(src));
            }
            if (eSrc.isDir()) {
                this.createDirectory(dst);
                return;
            }
            boolean hasReplace = false;
            boolean hasCopyAttrs = false;
            for (CopyOption opt : options) {
                if (opt == StandardCopyOption.REPLACE_EXISTING) {
                    hasReplace = true;
                    continue;
                }
                if (opt != StandardCopyOption.COPY_ATTRIBUTES) continue;
                hasCopyAttrs = true;
            }
            Entry eDst = this.getEntry(dst);
            if (eDst != null) {
                if (!hasReplace) {
                    throw new FileAlreadyExistsException(this.getString(dst));
                }
            } else {
                this.checkParents(dst);
            }
            Entry target = new Entry(eSrc, 3);
            target.name(dst);
            if (eSrc.type == 1 || eSrc.type == 2) {
                target.type = eSrc.type;
                if (deleteSource) {
                    target.bytes = eSrc.bytes;
                    target.file = eSrc.file;
                } else if (eSrc.bytes != null) {
                    target.bytes = Arrays.copyOf(eSrc.bytes, eSrc.bytes.length);
                } else if (eSrc.file != null) {
                    target.file = this.getTempPathForEntry(null);
                    Files.copy(eSrc.file, target.file, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            if (!hasCopyAttrs) {
                target.lastAccessTime = target.createTime = System.currentTimeMillis();
                target.lastModifiedTime = target.createTime;
            }
            this.update(target);
            if (deleteSource) {
                this.updateDelete(eSrc);
            }
        }
        finally {
            this.endWrite();
        }
    }

    private void checkParents(byte[] pathBytes) throws IOException {
        this.beginRead();
        try {
            byte[] path = pathBytes;
            while ((path = NativeImageResourceFileSystem.getParent(path)) != null && path != ROOT_PATH) {
                if (this.inodes.containsKey(IndexNode.keyOf(path))) continue;
                throw new NoSuchFileException(this.getString(path));
            }
        }
        finally {
            this.endRead();
        }
    }

    IndexNode getInode(byte[] path) {
        if (path == null) {
            throw new NullPointerException("Path is null!");
        }
        IndexNode indexNode = this.inodes.get(IndexNode.keyOf(path));
        if (indexNode == null && MissingRegistrationUtils.throwMissingRegistrationErrors()) {
            Resources.singleton().getAtRuntime(this.getString(path), true);
        }
        return indexNode;
    }

    Entry getEntry(byte[] path) {
        IndexNode inode = this.getInode(path);
        if (inode instanceof Entry) {
            return (Entry)inode;
        }
        if (inode == null) {
            return null;
        }
        return new Entry(inode.name, inode.isDir, inode.isComplete);
    }

    static byte[] getParent(byte[] path) {
        int off = NativeImageResourceFileSystem.getParentOff(path);
        if (off <= 1) {
            return ROOT_PATH;
        }
        return Arrays.copyOf(path, off);
    }

    private static int getParentOff(byte[] path) {
        int off = path.length - 1;
        if (off > 0 && path[off] == 47) {
            --off;
        }
        while (off > 0 && path[off] != 47) {
            --off;
        }
        return off;
    }

    private void removeFromTree(IndexNode inode) {
        IndexNode parent = this.inodes.get(this.lookupKey.as(NativeImageResourceFileSystem.getParent(inode.name)));
        IndexNode child = parent.child;
        if (child.equals(inode)) {
            parent.child = child.sibling;
        } else {
            IndexNode last = child;
            while ((child = child.sibling) != null) {
                if (child.equals(inode)) {
                    last.sibling = child.sibling;
                    break;
                }
                last = child;
            }
        }
    }

    private void updateDelete(IndexNode inode) {
        this.beginWrite();
        try {
            this.removeFromTree(inode);
            this.inodes.remove(inode);
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Entry e) {
        this.beginWrite();
        try {
            IndexNode old = this.inodes.put(e, e);
            if (old != null) {
                this.removeFromTree(old);
            }
            if (e.type == 1 || e.type == 2 || e.type == 3) {
                IndexNode parent = this.inodes.get(this.lookupKey.as(NativeImageResourceFileSystem.getParent(e.name)));
                e.sibling = parent.child;
                parent.child = e;
            }
        }
        finally {
            this.endWrite();
        }
    }

    private void readAllEntries() {
        MapCursor entries = Resources.singleton().getResourceStorage().getEntries();
        while (entries.advance()) {
            byte[] name = this.getBytes(((Resources.ModuleResourceKey)entries.getKey()).resource());
            ResourceStorageEntryBase entry = (ResourceStorageEntryBase)((ConditionalRuntimeValue)entries.getValue()).getValue();
            if (entry == null || !entry.hasData()) continue;
            IndexNode newIndexNode = new IndexNode(name, entry.isDirectory(), true);
            this.inodes.put(newIndexNode, newIndexNode);
        }
        this.buildNodeTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildNodeTree() {
        this.beginWrite();
        try {
            IndexNode rootIndex = this.inodes.get(this.lookupKey.as(ROOT_PATH));
            if (rootIndex == null) {
                rootIndex = new IndexNode(ROOT_PATH, true, false);
            } else {
                this.inodes.remove(rootIndex);
            }
            IndexNode[] nodes = this.inodes.keySet().toArray(new IndexNode[0]);
            this.inodes.put(rootIndex, rootIndex);
            ParentLookup lookup = new ParentLookup();
            IndexNode[] indexNodeArray = nodes;
            int n = indexNodeArray.length;
            block3: for (int i = 0; i < n; ++i) {
                IndexNode controlNode;
                IndexNode node = controlNode = indexNodeArray[i];
                while (true) {
                    IndexNode parent;
                    int off;
                    if ((off = NativeImageResourceFileSystem.getParentOff(node.name)) <= 1) {
                        node.sibling = rootIndex.child;
                        rootIndex.child = node;
                        continue block3;
                    }
                    if (this.inodes.containsKey(lookup = lookup.as(node.name, off))) {
                        parent = this.inodes.get(lookup);
                        node.sibling = parent.child;
                        parent.child = node;
                        continue block3;
                    }
                    parent = new IndexNode(Arrays.copyOf(node.name, off), true, false);
                    this.inodes.put(parent, parent);
                    node.sibling = parent.child;
                    parent.child = node;
                    node = parent;
                }
            }
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getInputStream(Entry e) throws IOException {
        void var2_7;
        Object var2_2 = null;
        if (e.type == 1 || e.type == 3) {
            byte[] bytes = e.getBytes(true);
            if (bytes != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            } else {
                if (e.file == null) throw new NativeImageResourceFileSystemException("Entry data is missing!");
                InputStream inputStream = Files.newInputStream(e.file, new OpenOption[0]);
            }
        } else if (e.type == 2) {
            return Files.newInputStream(e.file, new OpenOption[0]);
        }
        this.inputStreams.add((InputStream)var2_7);
        return var2_7;
    }

    private OutputStream getOutputStream(Entry e) {
        e.getBytes(false);
        if (e.lastModifiedTime == -1L) {
            e.lastModifiedTime = System.currentTimeMillis();
        }
        EntryOutputStream os = new EntryOutputStream(e, new ByteArrayOutputStream(e.size > 0 ? e.size : 8192));
        this.outputStreams.add(os);
        return os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream newInputStream(byte[] path) throws IOException {
        this.beginRead();
        try {
            this.ensureOpen();
            Entry entry = this.getEntry(path);
            if (entry == null) {
                throw new NoSuchFileException(this.getString(path));
            }
            if (entry.isDir()) {
                throw new FileSystemException(this.getString(path), "is a directory", null);
            }
            InputStream inputStream = this.getInputStream(entry);
            return inputStream;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream newOutputStream(byte[] path, OpenOption ... options) throws IOException {
        boolean hasCreateNew = false;
        boolean hasCreate = false;
        boolean hasAppend = false;
        boolean hasTruncate = false;
        for (OpenOption opt : options) {
            if (opt == StandardOpenOption.READ) {
                throw new IllegalArgumentException("READ not allowed!");
            }
            if (opt == StandardOpenOption.CREATE_NEW) {
                hasCreateNew = true;
            }
            if (opt == StandardOpenOption.CREATE) {
                hasCreate = true;
            }
            if (opt == StandardOpenOption.APPEND) {
                hasAppend = true;
            }
            if (opt != StandardOpenOption.TRUNCATE_EXISTING) continue;
            hasTruncate = true;
        }
        if (hasAppend && hasTruncate) {
            throw new IllegalArgumentException("APPEND + TRUNCATE_EXISTING are not allowed!");
        }
        this.beginRead();
        try {
            this.ensureOpen();
            Entry e = this.getEntry(path);
            if (e != null) {
                if (e.isDir() || hasCreateNew) {
                    throw new FileAlreadyExistsException(this.getString(path));
                }
                if (hasAppend) {
                    try (InputStream is = this.getInputStream(e);){
                        OutputStream os = this.getOutputStream(new Entry(e, 1));
                        byte[] bytes = NativeImageResourceFileSystemUtil.inputStreamToByteArray(is);
                        os.write(bytes, 0, bytes.length);
                        OutputStream outputStream = os;
                        return outputStream;
                    }
                }
                OutputStream outputStream = this.getOutputStream(new Entry(e, 1));
                return outputStream;
            }
            if (!hasCreate && !hasCreateNew) {
                throw new NoSuchFileException(this.getString(path));
            }
            this.checkParents(path);
            OutputStream outputStream = this.getOutputStream(new Entry(path, false, false));
            return outputStream;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileChannel newFileChannel(byte[] path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        NativeImageResourceFileSystem.checkOptions(options);
        final boolean forWrite = options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.APPEND);
        this.beginRead();
        try {
            this.ensureOpen();
            Entry e = this.getEntry(path);
            if (forWrite) {
                if (e == null) {
                    if (!options.contains(StandardOpenOption.CREATE) && !options.contains(StandardOpenOption.CREATE_NEW)) {
                        throw new NoSuchFileException(this.getString(path));
                    }
                } else {
                    if (options.contains(StandardOpenOption.CREATE_NEW)) {
                        throw new FileAlreadyExistsException(this.getString(path));
                    }
                    if (e.isDir()) {
                        throw new FileAlreadyExistsException("Directory <" + this.getString(path) + "> exists!");
                    }
                }
            } else if (e == null || e.isDir()) {
                throw new NoSuchFileException(this.getString(path));
            }
            final boolean isFCH = e != null && e.type == 2;
            final Path tmpFile = isFCH ? e.file : this.getTempPathForEntry(path);
            final FileChannel fch = tmpFile.getFileSystem().provider().newFileChannel(tmpFile, options, attrs);
            final Entry target = isFCH ? e : new Entry(path, tmpFile, 2, false);
            FileChannel fileChannel = new FileChannel(this){
                final /* synthetic */ NativeImageResourceFileSystem this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int write(ByteBuffer src) throws IOException {
                    return fch.write(src);
                }

                @Override
                public long write(ByteBuffer[] src, int offset, int length) throws IOException {
                    return fch.write(src, offset, length);
                }

                @Override
                public long position() throws IOException {
                    return fch.position();
                }

                @Override
                public FileChannel position(long newPosition) throws IOException {
                    fch.position(newPosition);
                    return this;
                }

                @Override
                public long size() throws IOException {
                    return fch.size();
                }

                @Override
                public FileChannel truncate(long size) throws IOException {
                    fch.truncate(size);
                    return this;
                }

                @Override
                public void force(boolean metaData) throws IOException {
                    fch.force(metaData);
                }

                @Override
                public long transferTo(long position, long count, WritableByteChannel byteChannel) throws IOException {
                    return fch.transferTo(position, count, byteChannel);
                }

                @Override
                public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
                    return fch.transferFrom(src, position, count);
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    return fch.read(dst);
                }

                @Override
                public int read(ByteBuffer dst, long position) throws IOException {
                    return fch.read(dst, position);
                }

                @Override
                public long read(ByteBuffer[] dst, int offset, int length) throws IOException {
                    return fch.read(dst, offset, length);
                }

                @Override
                public int write(ByteBuffer src, long position) throws IOException {
                    return fch.write(src, position);
                }

                @Override
                public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public FileLock lock(long position, long size, boolean shared) throws IOException {
                    return fch.lock(position, size, shared);
                }

                @Override
                public FileLock tryLock(long position, long size, boolean shared) throws IOException {
                    return fch.tryLock(position, size, shared);
                }

                @Override
                protected void implCloseChannel() throws IOException {
                    fch.close();
                    if (forWrite) {
                        target.lastModifiedTime = System.currentTimeMillis();
                        target.size = (int)Files.size(target.file);
                        this.this$0.update(target);
                    } else if (!isFCH) {
                        this.this$0.removeTempPathForEntry(tmpFile);
                    }
                }
            };
            return fileChannel;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<Path> iteratorOf(NativeImageResourcePath dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.beginWrite();
        try {
            this.ensureOpen();
            byte[] path = dir.getResolvedPath();
            IndexNode inode = this.getInode(path);
            if (inode == null) {
                throw new NotDirectoryException(this.getString(path));
            }
            ArrayList<Path> list = new ArrayList<Path>();
            IndexNode child = inode.child;
            while (child != null) {
                byte[] childName = child.name;
                NativeImageResourcePath childPath = new NativeImageResourcePath(this, childName, true);
                Path childFileName = childPath.getFileName();
                Path dirPath = null;
                if (childFileName != null) {
                    dirPath = dir.resolve(childFileName);
                }
                if (filter == null || dirPath != null && filter.accept(dirPath)) {
                    list.add(dirPath);
                }
                child = child.sibling;
            }
            Iterator<Path> iterator = list.iterator();
            return iterator;
        }
        finally {
            this.endWrite();
        }
    }

    private static class IndexNode {
        private static final ThreadLocal<IndexNode> cachedKey = new ThreadLocal();
        byte[] name;
        int hashcode;
        boolean isDir;
        boolean isComplete;
        IndexNode child;
        IndexNode sibling;

        IndexNode() {
        }

        IndexNode(byte[] n) {
            this.name(n);
        }

        IndexNode(byte[] n, boolean isDir, boolean isComplete) {
            this.name(n);
            this.isDir = isDir;
            this.isComplete = isComplete;
        }

        static IndexNode keyOf(byte[] n) {
            IndexNode key = cachedKey.get();
            if (key == null) {
                key = new IndexNode(n);
                cachedKey.set(key);
            }
            return key.as(n);
        }

        final void name(byte[] n) {
            this.name = n;
            this.hashcode = Arrays.hashCode(n);
        }

        final IndexNode as(byte[] n) {
            this.name(n);
            return this;
        }

        boolean isDir() {
            return this.isDir;
        }

        public boolean equals(Object other) {
            if (!(other instanceof IndexNode)) {
                return false;
            }
            if (other instanceof ParentLookup) {
                return other.equals(this);
            }
            return Arrays.equals(this.name, ((IndexNode)other).name);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    class Entry
    extends IndexNode {
        private static final int NEW = 1;
        private static final int FILE_CH = 2;
        private static final int COPY = 3;
        public int size;
        public int type;
        public long lastModifiedTime;
        public long lastAccessTime;
        public long createTime;
        private boolean copyOnWrite;
        private byte[] bytes;
        public Path file;

        Entry(byte[] name, Path file, int type, boolean isComplete) {
            this(name, type, false, isComplete);
            this.file = file;
        }

        void initTimes() {
            this.lastAccessTime = this.createTime = System.currentTimeMillis();
            this.lastModifiedTime = this.createTime;
        }

        void initData() {
            if (this.isComplete) {
                this.bytes = NativeImageResourceFileSystemUtil.getBytes(NativeImageResourceFileSystem.this.getString(this.name), true);
                this.size = !this.isDir ? this.bytes.length : 0;
            }
        }

        byte[] getBytes(boolean readOnly) {
            if (!readOnly && this.isComplete && !this.copyOnWrite) {
                this.copyOnWrite = true;
                this.bytes = NativeImageResourceFileSystemUtil.getBytes(NativeImageResourceFileSystem.this.getString(this.name), false);
            }
            return this.bytes;
        }

        Entry(byte[] name, boolean isDir, boolean isComplete) {
            this.name(name);
            this.type = 1;
            this.isDir = isDir;
            this.isComplete = isComplete;
            this.initData();
            this.initTimes();
        }

        Entry(byte[] name, int type, boolean isDir, boolean isComplete) {
            this.name(name);
            this.type = type;
            this.isDir = isDir;
            this.isComplete = isComplete;
            this.initData();
            this.initTimes();
        }

        Entry(Entry other, int type) {
            this.name(other.name);
            this.lastModifiedTime = other.lastModifiedTime;
            this.lastAccessTime = other.lastAccessTime;
            this.createTime = other.createTime;
            this.isDir = other.isDir;
            this.isComplete = other.isComplete;
            this.size = other.size;
            this.bytes = other.bytes;
            this.type = type;
            this.copyOnWrite = true;
        }

        boolean isDirectory() {
            return this.isDir;
        }

        long size() {
            return this.size;
        }
    }

    class EntryOutputChannel
    extends ByteArrayChannel {
        Entry e;

        EntryOutputChannel(Entry e) {
            super(e.size > 0 ? e.size : 8192, false);
            this.e = e;
            if (e.lastModifiedTime == -1L) {
                e.lastModifiedTime = System.currentTimeMillis();
            }
        }

        @Override
        public void close() throws IOException {
            try (OutputStream os = NativeImageResourceFileSystem.this.getOutputStream(this.e);){
                os.write(this.toByteArray());
            }
            super.close();
        }
    }

    private static class ParentLookup
    extends IndexNode {
        private int length;

        ParentLookup() {
        }

        ParentLookup as(byte[] n, int len) {
            this.name(n, len);
            return this;
        }

        void name(byte[] n, int len) {
            this.name = n;
            this.length = len;
            int result = 1;
            for (int i = 0; i < len; ++i) {
                result = 31 * result + n[i];
            }
            this.hashcode = result;
        }

        boolean isEquals(byte[] name1, int endIndex1, byte[] name2, int endIndex2) {
            if (name1.length < endIndex1 || name2.length < endIndex2) {
                return false;
            }
            int lenToCmp = Math.min(endIndex1, endIndex2);
            for (int index = 0; index < lenToCmp; ++index) {
                if (name1[index] == name2[index]) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof IndexNode)) {
                return false;
            }
            byte[] otherName = ((IndexNode)other).name;
            return this.isEquals(this.name, this.length, otherName, otherName.length);
        }
    }

    private class EntryOutputStream
    extends FilterOutputStream {
        private final Entry e;
        private int written;
        private boolean isClosed;

        EntryOutputStream(Entry e, OutputStream os) {
            super(os);
            this.e = Objects.requireNonNull(e, "Entry is null!");
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.written += len;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.e.size = this.written;
            if (this.out instanceof ByteArrayOutputStream) {
                this.e.bytes = ((ByteArrayOutputStream)this.out).toByteArray();
            }
            super.close();
            NativeImageResourceFileSystem.this.update(this.e);
        }
    }
}

