/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.jdk.resources.NativeImageResourceFileSystem;
import com.oracle.svm.core.jdk.resources.NativeImageResourcePath;
import java.io.IOException;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class NativeImageResourceDirectoryStream
implements DirectoryStream<Path> {
    private final NativeImageResourceFileSystem fileSystem;
    private final DirectoryStream.Filter<? super Path> filter;
    private final NativeImageResourcePath dir;
    private volatile boolean isClosed = false;
    private Iterator<Path> directoryIterator;

    public NativeImageResourceDirectoryStream(NativeImageResourcePath dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.fileSystem = dir.getFileSystem();
        this.dir = dir;
        this.filter = filter;
        if (!this.fileSystem.isDirectory(dir.getResolvedPath())) {
            throw new NotDirectoryException(dir.toString());
        }
    }

    @Override
    public Iterator<Path> iterator() {
        if (this.isClosed) {
            throw new ClosedDirectoryStreamException();
        }
        if (this.directoryIterator != null) {
            throw new IllegalStateException("Iterator has already been returned");
        }
        try {
            this.directoryIterator = this.fileSystem.iteratorOf(this.dir, this.filter);
        }
        catch (IOException ioException) {
            throw new DirectoryIteratorException(ioException);
        }
        return new Iterator<Path>(){

            @Override
            public boolean hasNext() {
                if (NativeImageResourceDirectoryStream.this.isClosed) {
                    return false;
                }
                return NativeImageResourceDirectoryStream.this.directoryIterator.hasNext();
            }

            @Override
            public Path next() {
                if (NativeImageResourceDirectoryStream.this.isClosed) {
                    throw new NoSuchElementException();
                }
                return NativeImageResourceDirectoryStream.this.directoryIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
        }
    }
}

