/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources.CompressedGlobTrie;

import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.DoubleStarNode;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.LiteralNode;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.StarTrieNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GlobTrieNode {
    protected static final String STAR = "*";
    protected static final String STAR_STAR = "**";
    protected static final String LEVEL_IDENTIFIER = "/";
    public static final String SAME_LEVEL_IDENTIFIER = "#";
    private String content = "";
    @UnknownObjectField(fullyQualifiedTypes={"java.util.HashMap", "java.util.ImmutableCollections$MapN", "java.util.ImmutableCollections$Map1"})
    private Map<String, GlobTrieNode> children = new HashMap<String, GlobTrieNode>();
    private boolean isLeaf = false;
    private boolean isNewLevel = false;
    @UnknownObjectField(fullyQualifiedTypes={"java.util.HashSet", "java.util.ImmutableCollections$SetN", "java.util.ImmutableCollections$Set12"})
    private Set<String> additionalContent = new HashSet<String>();

    protected GlobTrieNode() {
    }

    protected GlobTrieNode(String content) {
        this();
        this.content = content;
    }

    public boolean isNewLevel() {
        return this.isNewLevel;
    }

    protected void setNewLevel() {
        this.isNewLevel = true;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    protected void setLeaf() {
        this.isLeaf = true;
    }

    protected void makeNodeInternal() {
        this.isLeaf = false;
    }

    public String getContent() {
        return this.content;
    }

    protected Set<String> getAdditionalContent() {
        return this.additionalContent;
    }

    protected void removeAdditionalContent(List<String> ac) {
        this.additionalContent.removeAll(ac);
    }

    protected void addAdditionalContent(String ac) {
        this.additionalContent.add(ac);
    }

    public List<GlobTrieNode> getChildren() {
        return this.children.values().stream().toList();
    }

    protected GlobTrieNode getChild(String child) {
        return this.children.get(child);
    }

    protected void removeChildren(List<GlobTrieNode> childKeys) {
        for (GlobTrieNode child : childKeys) {
            String sameLevel = !child.isNewLevel() ? SAME_LEVEL_IDENTIFIER : "";
            String childKey = child.getContent() + sameLevel;
            this.children.remove(childKey);
        }
    }

    protected GlobTrieNode getChildFromSameLevel(String child) {
        return this.children.get(child + SAME_LEVEL_IDENTIFIER);
    }

    protected GlobTrieNode addChild(String child, GlobTrieNode childValue) {
        StringBuilder sb = new StringBuilder(child);
        if (!childValue.isNewLevel()) {
            sb.append(SAME_LEVEL_IDENTIFIER);
        }
        this.children.putIfAbsent(sb.toString(), childValue);
        return this.children.get(sb.toString());
    }

    protected List<StarTrieNode> getChildrenWithStar() {
        return this.getChildren().stream().filter(node -> node instanceof StarTrieNode).map(node -> (StarTrieNode)node).toList();
    }

    protected List<LiteralNode> getChildrenWithLiteral() {
        return this.getChildren().stream().filter(node -> node instanceof LiteralNode).map(node -> (LiteralNode)node).toList();
    }

    protected DoubleStarNode getDoubleStarNode() {
        return (DoubleStarNode)this.getChild(STAR_STAR);
    }

    protected void trim() {
        for (GlobTrieNode child : this.children.values()) {
            child.trim();
        }
        this.additionalContent = Set.copyOf(this.additionalContent);
        this.children = Map.copyOf(this.children);
    }
}

