/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization.compression.utils;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import jdk.graal.compiler.debug.GraalError;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class BundleSerializationUtils {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Map<String, Object> extractContent(ResourceBundle bundle) {
        bundle.keySet();
        for (Class<?> clazz = bundle.getClass().getSuperclass(); clazz != null && ResourceBundle.class.isAssignableFrom(clazz); clazz = clazz.getSuperclass()) {
            try {
                return (Map)ReflectionUtil.lookupField(clazz, (String)"lookup").get(bundle);
            }
            catch (ReflectionUtil.ReflectionUtilError | ReflectiveOperationException e) {
                continue;
            }
        }
        throw VMError.shouldNotReachHere("Failed to extract content for " + String.valueOf(bundle) + " of type " + String.valueOf(bundle.getClass()));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Pair<String, int[]> serializeContent(Map<String, Object> content) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : content.entrySet()) {
            String key = entry.getKey();
            builder.append(key);
            Object value = entry.getValue();
            if (value instanceof String) {
                builder.append(value);
                indices.add(-1);
                indices.add(key.length());
                indices.add(((String)value).length());
                continue;
            }
            if (value instanceof Object[]) {
                Object[] arr = (Object[])value;
                indices.add(arr.length);
                indices.add(key.length());
                for (Object o : arr) {
                    GraalError.guarantee((boolean)(o instanceof String), (String)"Bundle content can't be serialized.");
                    builder.append(o);
                    indices.add(((String)o).length());
                }
                continue;
            }
            GraalError.shouldNotReachHere((String)"Bundle content can't be serialized.");
        }
        int[] res = new int[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            res[i] = (Integer)indices.get(i);
        }
        return Pair.create((Object)builder.toString(), (Object)res);
    }

    public static Map<String, Object> deserializeContent(int[] indices, String text) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        int i = 0;
        int offset = 0;
        while (i < indices.length) {
            boolean isArray;
            int valueCnt = indices[i++];
            int keyLen = indices[i++];
            String key = text.substring(offset, offset + keyLen);
            offset += keyLen;
            boolean bl = isArray = valueCnt != -1;
            if (isArray) {
                String[] values = new String[valueCnt];
                for (int j = 0; j < valueCnt; ++j) {
                    int valueLen = indices[i++];
                    values[j] = text.substring(offset, offset + valueLen);
                    offset += valueLen;
                }
                content.put(key, values);
                continue;
            }
            int valueLen = indices[i++];
            String value = text.substring(offset, offset + valueLen);
            offset += valueLen;
            content.put(key, value);
        }
        return content;
    }
}

