/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap.dump;

import com.oracle.svm.core.SubstrateOptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.impl.HeapDumpSupport;

public abstract class HeapDumping
implements HeapDumpSupport {
    @Fold
    public static HeapDumping singleton() {
        return (HeapDumping)ImageSingletons.lookup(HeapDumping.class);
    }

    public abstract void initializeDumpHeapOnOutOfMemoryError();

    public abstract void teardownDumpHeapOnOutOfMemoryError();

    public static String getHeapDumpPath(String defaultFilename) {
        String heapDumpFilenameOrDirectory = SubstrateOptions.HeapDumpPath.getValue();
        if (heapDumpFilenameOrDirectory.isEmpty()) {
            return defaultFilename;
        }
        Path targetPath = Paths.get(heapDumpFilenameOrDirectory, new String[0]);
        if (Files.isDirectory(targetPath, new LinkOption[0])) {
            targetPath = targetPath.resolve(defaultFilename);
        }
        return targetPath.toFile().getAbsolutePath();
    }

    public void dumpHeap(boolean gcBefore) throws IOException {
        String suffix = Long.toString(System.currentTimeMillis());
        String defaultFilename = HeapDumping.getDefaultHeapDumpFilename(suffix);
        this.dumpHeap(HeapDumping.getHeapDumpPath(defaultFilename), gcBefore);
    }

    protected static String getDefaultHeapDumpFilename(String suffix) {
        return SubstrateOptions.HeapDumpDefaultFilenamePrefix.getValue() + ProcessProperties.getProcessID() + "-" + suffix + ".hprof";
    }

    public abstract void dumpHeapOnOutOfMemoryError();
}

