/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.graal.stackvalue.LateStackValueNode;
import com.oracle.svm.core.graal.stackvalue.LoweredStackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.JavaThreads;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractStateSplit;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;

final class StackValueSnippets
extends SubstrateTemplates
implements Snippets {
    private static final String EXCEPTION_MESSAGE = "StackValue must not be used in a virtual thread unless the method is annotated @" + Uninterruptible.class.getSimpleName() + ".";
    private static final IllegalThreadStateException CACHED_EXCEPTION = new IllegalThreadStateException(EXCEPTION_MESSAGE + " [no exception stack trace available because exception is thrown from code that must be allocation free]");
    static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_EXCEPTION = SnippetRuntime.findForeignCall(StackValueSnippets.class, "throwCachedException", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_EXCEPTION = SnippetRuntime.findForeignCall(StackValueSnippets.class, "throwNewException", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, new LocationIdentity[0]);
    static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{THROW_CACHED_EXCEPTION, THROW_NEW_EXCEPTION};
    private final SnippetTemplate.SnippetInfo stackValueSnippet;

    @Snippet
    private static WordBase stackValueSnippet(@Snippet.ConstantParameter int sizeInBytes, @Snippet.ConstantParameter int alignmentInBytes, @Snippet.ConstantParameter StackValueNode.StackSlotIdentity slotIdentifier, @Snippet.ConstantParameter boolean disallowVirtualThread, @Snippet.ConstantParameter boolean mustNotAllocate) {
        if (disallowVirtualThread && BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)JavaThreads.isCurrentThreadVirtual())) {
            if (mustNotAllocate) {
                StackValueSnippets.callSlowPath(THROW_CACHED_EXCEPTION);
            } else {
                StackValueSnippets.callSlowPath(THROW_NEW_EXCEPTION);
            }
        }
        return LoweredStackValueNode.loweredStackValue(sizeInBytes, alignmentInBytes, slotIdentifier);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPath(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwCachedException() {
        throw CACHED_EXCEPTION;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void throwNewException() {
        IllegalThreadStateException error = Heap.getHeap().isAllocationDisallowed() ? CACHED_EXCEPTION : new IllegalThreadStateException(EXCEPTION_MESSAGE);
        throw error;
    }

    StackValueSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.stackValueSnippet = this.snippet(providers, StackValueSnippets.class, "stackValueSnippet", new LocationIdentity[0]);
        lowerings.put(StackValueNode.class, new StackValueLowering());
        lowerings.put(LateStackValueNode.class, new LateStackValueLowering());
    }

    private void lower(LoweringTool tool, AbstractStateSplit node, int sizeInBytes, int alignmentInBytes, StackValueNode.StackSlotIdentity slotIdentity, boolean checkVirtualThread) {
        GraalError.guarantee((tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER ? 1 : 0) != 0, (String)"Must lower before mid-tier StackValueRecursionDepthPhase");
        StructuredGraph graph = node.graph();
        boolean mustNotAllocate = ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate(graph.method());
        SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.stackValueSnippet, graph.getGuardsStage(), tool.getLoweringStage());
        args.addConst("sizeInBytes", (Object)sizeInBytes);
        args.addConst("alignmentInBytes", (Object)alignmentInBytes);
        args.addConst("slotIdentifier", (Object)slotIdentity);
        args.addConst("disallowVirtualThread", (Object)checkVirtualThread);
        args.addConst("mustNotAllocate", (Object)mustNotAllocate);
        this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
    }

    final class StackValueLowering
    implements NodeLoweringProvider<StackValueNode> {
        StackValueLowering() {
        }

        @Override
        public void lower(StackValueNode node, LoweringTool tool) {
            StackValueSnippets.this.lower(tool, node, node.sizeInBytes, node.alignmentInBytes, node.slotIdentity, node.checkVirtualThread);
        }
    }

    final class LateStackValueLowering
    implements NodeLoweringProvider<LateStackValueNode> {
        LateStackValueLowering() {
        }

        @Override
        public void lower(LateStackValueNode node, LoweringTool tool) {
            ValueNode sizeNode = node.sizeInBytes;
            if (!sizeNode.isConstant()) {
                throw new PermanentBailoutException("%s has a size that is not a compile time constant.", new Object[]{node});
            }
            int sizeInBytes = NumUtil.safeToInt((long)sizeNode.asJavaConstant().asLong());
            GraalError.guarantee((sizeInBytes > 0 ? 1 : 0) != 0, (String)"%s: must allocate at least 1 byte.", (Object)((Object)node));
            StackValueSnippets.this.lower(tool, node, sizeInBytes, node.alignmentInBytes, node.slotIdentity, node.checkVirtualThread);
        }
    }
}

