/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.debug.ControlFlowAnchored;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VerificationMarkerNode
extends FixedWithNextNode
implements LIRLowerable,
ControlFlowAnchored {
    public static final NodeClass<VerificationMarkerNode> TYPE = NodeClass.create(VerificationMarkerNode.class);
    private final Object marker;

    public VerificationMarkerNode(Object marker) {
        super(TYPE, StampFactory.forVoid());
        this.marker = marker;
    }

    protected void afterClone(Node other) {
        if (((StructuredGraph)other.graph()).isSubstitution()) {
            return;
        }
        throw VMError.shouldNotReachHere("Marker must be unique, therefore the node cannot be cloned");
    }

    public void generate(NodeLIRBuilderTool generator) {
        SubstrateLIRGenerator sgenerator = (SubstrateLIRGenerator)generator.getLIRGeneratorTool();
        sgenerator.emitVerificationMarker(this.marker);
    }
}

