/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.graal.nodes.ReadReservedRegisterFixedNode;
import com.oracle.svm.core.graal.nodes.ReadReservedRegisterFloatingNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class ReadReservedRegister {
    public static ValueNode createReadStackPointerNode(StructuredGraph graph) {
        return ReadReservedRegister.createReadNode(graph, ReservedRegisters.singleton().getFrameRegister());
    }

    public static ValueNode createReadIsolateThreadNode(StructuredGraph graph) {
        return ReadReservedRegister.createReadNode(graph, ReservedRegisters.singleton().getThreadRegister());
    }

    public static ValueNode createReadHeapBaseNode(StructuredGraph graph) {
        return ReadReservedRegister.createReadNode(graph, ReservedRegisters.singleton().getHeapBaseRegister());
    }

    private static ValueNode createReadNode(StructuredGraph graph, Register register) {
        if (MultiMethod.isDeoptTarget((ResolvedJavaMethod)graph.method())) {
            return new ReadReservedRegisterFixedNode(register);
        }
        return new ReadReservedRegisterFloatingNode(register);
    }
}

