/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;

@Opcode
public class AMD64SafepointCheckOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64SafepointCheckOp> TYPE = LIRInstructionClass.create(AMD64SafepointCheckOp.class);

    public AMD64SafepointCheckOp() {
        super(TYPE);
    }

    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        int safepointRequestedOffset = Safepoint.getThreadLocalSafepointRequestedOffset();
        AMD64Address safepointRequested = new AMD64Address(ReservedRegisters.singleton().getThreadRegister(), safepointRequestedOffset);
        if (ThreadingSupportImpl.isRecurringCallbackSupported()) {
            masm.subl(safepointRequested, 1);
        } else {
            masm.cmpl(safepointRequested, 0);
        }
    }

    public AMD64Assembler.ConditionFlag getConditionFlag() {
        return AMD64Assembler.ConditionFlag.LessEqual;
    }
}

