/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.net.URI;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

final class LegacyResourceConfigurationParser<C>
extends ResourceConfigurationParser<C> {
    LegacyResourceConfigurationParser(ConfigurationConditionResolver<C> conditionResolver, ResourcesRegistry<C> registry, boolean strictConfiguration) {
        super(conditionResolver, registry, strictConfiguration);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        this.parseTopLevelObject(LegacyResourceConfigurationParser.asMap(json, "first level of document must be an object"));
    }

    private void parseTopLevelObject(EconomicMap<String, Object> obj) {
        Object resourcesObject = null;
        Object bundlesObject = null;
        Object globsObject = null;
        MapCursor cursor = obj.getEntries();
        while (cursor.advance()) {
            if ("resources".equals(cursor.getKey())) {
                resourcesObject = cursor.getValue();
                continue;
            }
            if ("bundles".equals(cursor.getKey())) {
                bundlesObject = cursor.getValue();
                continue;
            }
            if (!"globs".equals(cursor.getKey())) continue;
            globsObject = cursor.getValue();
        }
        if (resourcesObject != null) {
            this.parseResourcesObject(resourcesObject);
        }
        if (bundlesObject != null) {
            this.parseBundlesObject(bundlesObject);
        }
        if (globsObject != null) {
            this.parseGlobsObject(globsObject);
        }
    }
}

