/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.RuntimeMetadataEncoding;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.reflect.RuntimeMetadataDecoder;
import com.oracle.svm.core.reflect.target.ReflectionObjectFactory;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Executable;
import com.oracle.svm.core.util.ByteArrayReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.function.Function;
import jdk.graal.compiler.core.common.util.UnsafeArrayTypeReader;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredImageSingleton(value={RuntimeMetadataDecoder.class})
public class RuntimeMetadataDecoderImpl
implements RuntimeMetadataDecoder {
    public static final int FIRST_ERROR_INDEX = -2;
    public static final int NO_METHOD_METADATA = -1;
    public static final int NULL_OBJECT = -1;
    public static final int COMPLETE_FLAG_INDEX = 31;
    public static final int COMPLETE_FLAG_MASK = Integer.MIN_VALUE;
    public static final int IN_HEAP_FLAG_INDEX = 30;
    public static final int IN_HEAP_FLAG_MASK = 0x40000000;
    public static final int HIDING_FLAG_INDEX = 29;
    public static final int HIDING_FLAG_MASK = 0x20000000;
    public static final int NEGATIVE_FLAG_INDEX = 28;
    public static final int NEGATIVE_FLAG_MASK = 0x10000000;
    public static final int ALL_FLAGS_MASK = -268435456;
    public static final int ALL_FIELDS_FLAG = 65536;
    public static final int ALL_DECLARED_FIELDS_FLAG = 131072;
    public static final int ALL_METHODS_FLAG = 262144;
    public static final int ALL_DECLARED_METHODS_FLAG = 524288;
    public static final int ALL_CONSTRUCTORS_FLAG = 0x100000;
    public static final int ALL_DECLARED_CONSTRUCTORS_FLAG = 0x200000;
    public static final int ALL_CLASSES_FLAG = 0x400000;
    public static final int ALL_DECLARED_CLASSES_FLAG = 0x800000;
    public static final int ALL_RECORD_COMPONENTS_FLAG = 0x1000000;
    public static final int ALL_PERMITTED_SUBCLASSES_FLAG = 0x2000000;
    public static final int ALL_NEST_MEMBERS_FLAG = 0x4000000;
    public static final int ALL_SIGNERS_FLAG = 0x8000000;
    public static final int CLASS_ACCESS_FLAGS_MASK = 8191;

    static byte[] getEncoding() {
        return ((RuntimeMetadataEncoding)ImageSingletons.lookup(RuntimeMetadataEncoding.class)).getEncoding();
    }

    @Override
    public Field[] parseFields(DynamicHub declaringType, int index, boolean publicOnly) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])RuntimeMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return RuntimeMetadataDecoderImpl.decodeArray(reader, Field.class, i -> (Field)RuntimeMetadataDecoderImpl.decodeField(reader, DynamicHub.toClass(declaringType), publicOnly, true));
    }

    @Override
    public RuntimeMetadataDecoder.FieldDescriptor[] parseReachableFields(DynamicHub declaringType, int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])RuntimeMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return RuntimeMetadataDecoderImpl.decodeArray(reader, RuntimeMetadataDecoder.FieldDescriptor.class, i -> (RuntimeMetadataDecoder.FieldDescriptor)RuntimeMetadataDecoderImpl.decodeField(reader, DynamicHub.toClass(declaringType), false, false));
    }

    @Override
    public Method[] parseMethods(DynamicHub declaringType, int index, boolean publicOnly) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])RuntimeMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return RuntimeMetadataDecoderImpl.decodeArray(reader, Method.class, i -> (Method)RuntimeMetadataDecoderImpl.decodeExecutable(reader, DynamicHub.toClass(declaringType), publicOnly, true, true));
    }

    @Override
    public RuntimeMetadataDecoder.MethodDescriptor[] parseReachableMethods(DynamicHub declaringType, int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])RuntimeMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return RuntimeMetadataDecoderImpl.decodeArray(reader, RuntimeMetadataDecoder.MethodDescriptor.class, i -> (RuntimeMetadataDecoder.MethodDescriptor)RuntimeMetadataDecoderImpl.decodeExecutable(reader, DynamicHub.toClass(declaringType), false, false, true));
    }

    @Override
    public Constructor<?>[] parseConstructors(DynamicHub declaringType, int index, boolean publicOnly) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])RuntimeMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return RuntimeMetadataDecoderImpl.decodeArray(reader, Constructor.class, i -> (Constructor)RuntimeMetadataDecoderImpl.decodeExecutable(reader, DynamicHub.toClass(declaringType), publicOnly, true, false));
    }

    @Override
    public RuntimeMetadataDecoder.ConstructorDescriptor[] parseReachableConstructors(DynamicHub declaringType, int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])RuntimeMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return RuntimeMetadataDecoderImpl.decodeArray(reader, RuntimeMetadataDecoder.ConstructorDescriptor.class, i -> (RuntimeMetadataDecoder.ConstructorDescriptor)RuntimeMetadataDecoderImpl.decodeExecutable(reader, DynamicHub.toClass(declaringType), false, false, false));
    }

    @Override
    public Class<?>[] parseClasses(int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])RuntimeMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return RuntimeMetadataDecoderImpl.decodeArray(reader, Class.class, i -> RuntimeMetadataDecoderImpl.decodeType(reader));
    }

    @Override
    public RecordComponent[] parseRecordComponents(DynamicHub declaringType, int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])RuntimeMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return RuntimeMetadataDecoderImpl.decodeArray(reader, RecordComponent.class, i -> RuntimeMetadataDecoderImpl.decodeRecordComponent(reader, DynamicHub.toClass(declaringType)));
    }

    @Override
    public Object[] parseObjects(int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])RuntimeMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return RuntimeMetadataDecoderImpl.decodeArray(reader, Object.class, i -> RuntimeMetadataDecoderImpl.decodeObject(reader));
    }

    @Override
    public Parameter[] parseReflectParameters(Executable executable, byte[] encoding) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])encoding, (long)0L, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return RuntimeMetadataDecoderImpl.decodeArray(reader, Parameter.class, i -> RuntimeMetadataDecoderImpl.decodeReflectParameter(reader, executable, i));
    }

    @Override
    public Object[] parseEnclosingMethod(int index) {
        if (RuntimeMetadataDecoderImpl.isErrorIndex(index)) {
            RuntimeMetadataDecoderImpl.decodeAndThrowError(index);
        }
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])RuntimeMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        Class<?> declaringClass = RuntimeMetadataDecoderImpl.decodeType(reader);
        String name = RuntimeMetadataDecoderImpl.decodeMemberName(reader);
        String descriptor = RuntimeMetadataDecoderImpl.decodeOtherString(reader);
        return new Object[]{declaringClass, name, descriptor};
    }

    @Override
    public byte[] parseByteArray(int index) {
        UnsafeArrayTypeReader reader = UnsafeArrayTypeReader.create((byte[])RuntimeMetadataDecoderImpl.getEncoding(), (long)index, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        return RuntimeMetadataDecoderImpl.decodeByteArray(reader);
    }

    @Override
    public boolean isHiding(int modifiers) {
        return (modifiers & 0x20000000) != 0;
    }

    @Override
    public boolean isNegative(int modifiers) {
        return (modifiers & 0x10000000) != 0;
    }

    @Override
    public int getMetadataByteLength() {
        return ((RuntimeMetadataEncoding)ImageSingletons.lookup(RuntimeMetadataEncoding.class)).getEncoding().length;
    }

    public static boolean isErrorIndex(int index) {
        return index < -1;
    }

    private static <T extends Throwable> void decodeAndThrowError(int index) throws T {
        assert (RuntimeMetadataDecoderImpl.isErrorIndex(index));
        int decodedIndex = -2 - index;
        throw (Throwable)RuntimeMetadataDecoder.MetadataAccessor.singleton().getObject(decodedIndex);
    }

    private static Object decodeField(UnsafeArrayTypeReader buf, Class<?> declaringClass, boolean publicOnly, boolean reflectOnly) {
        Class<?> type;
        boolean negative;
        boolean hiding;
        int modifiers = buf.getUVInt();
        boolean inHeap = (modifiers & 0x40000000) != 0;
        boolean complete = (modifiers & Integer.MIN_VALUE) != 0;
        RuntimeConditionSet conditions = RuntimeMetadataDecoderImpl.decodeConditions(buf);
        if (inHeap) {
            Field field = (Field)RuntimeMetadataDecoderImpl.decodeObject(buf);
            if (publicOnly && !Modifier.isPublic(field.getModifiers())) {
                return ReflectionObjectFactory.newField(conditions, declaringClass, field.getName(), Object.class, field.getModifiers() | 0x10000000, false, null, null, 0, null, null);
            }
            if (reflectOnly) {
                return complete ? field : null;
            }
            return new RuntimeMetadataDecoder.FieldDescriptor(field);
        }
        boolean bl = hiding = (modifiers & 0x20000000) != 0;
        assert (!complete || !hiding);
        boolean bl2 = negative = (modifiers & 0x10000000) != 0;
        assert (!negative || !complete && !hiding);
        modifiers &= Integer.MAX_VALUE;
        String name = RuntimeMetadataDecoderImpl.decodeMemberName(buf);
        Class<Object> clazz = type = complete || hiding ? RuntimeMetadataDecoderImpl.decodeType(buf) : null;
        if (!complete) {
            if (reflectOnly != (hiding || negative)) {
                return null;
            }
            if (!reflectOnly) {
                return new RuntimeMetadataDecoder.FieldDescriptor(declaringClass, name);
            }
            return ReflectionObjectFactory.newField(conditions, declaringClass, name, negative ? Object.class : type, modifiers, false, null, null, 0, null, null);
        }
        boolean trustedFinal = buf.getU1() == 1;
        String signature = RuntimeMetadataDecoderImpl.decodeOtherString(buf);
        byte[] annotations = RuntimeMetadataDecoderImpl.decodeByteArray(buf);
        byte[] typeAnnotations = RuntimeMetadataDecoderImpl.decodeByteArray(buf);
        int offset = buf.getSVInt();
        String deletedReason = RuntimeMetadataDecoderImpl.decodeOtherString(buf);
        if (publicOnly && !Modifier.isPublic(modifiers)) {
            modifiers |= 0x10000000;
        }
        Field reflectField = ReflectionObjectFactory.newField(conditions, declaringClass, name, type, modifiers, trustedFinal, signature, annotations, offset, deletedReason, typeAnnotations);
        return reflectOnly ? reflectField : new RuntimeMetadataDecoder.FieldDescriptor(reflectField);
    }

    private static RuntimeConditionSet decodeConditions(UnsafeArrayTypeReader buf) {
        Object[] conditionTypes = RuntimeMetadataDecoderImpl.decodeArray(buf, Class.class, i -> RuntimeMetadataDecoderImpl.decodeType(buf));
        return RuntimeConditionSet.createDecoded(conditionTypes);
    }

    private static Object decodeExecutable(UnsafeArrayTypeReader buf, Class<?> declaringClass, boolean publicOnly, boolean reflectOnly, boolean isMethod) {
        Target_java_lang_reflect_Executable executable;
        Class<?> returnType;
        boolean negative;
        boolean hiding;
        int modifiers = buf.getUVInt();
        boolean inHeap = (modifiers & 0x40000000) != 0;
        boolean complete = (modifiers & Integer.MIN_VALUE) != 0;
        RuntimeConditionSet conditions = RuntimeMetadataDecoderImpl.decodeConditions(buf);
        if (inHeap) {
            Executable executable2 = (Constructor<?>)RuntimeMetadataDecoderImpl.decodeObject(buf);
            if (publicOnly && !Modifier.isPublic(((Executable)executable2).getModifiers())) {
                executable2 = isMethod ? ReflectionObjectFactory.newMethod(conditions, declaringClass, ((Executable)executable2).getName(), ((Executable)executable2).getParameterTypes(), Object.class, null, modifiers | 0x10000000, null, null, null, null, null, null, null) : ReflectionObjectFactory.newConstructor(conditions, declaringClass, ((Executable)executable2).getParameterTypes(), null, modifiers | 0x10000000, null, null, null, null, null, null);
            }
            if (reflectOnly) {
                return complete ? executable2 : null;
            }
            if (isMethod) {
                Method method = (Method)executable2;
                return new RuntimeMetadataDecoder.MethodDescriptor(method);
            }
            Constructor constructor = executable2;
            return new RuntimeMetadataDecoder.ConstructorDescriptor(constructor);
        }
        boolean bl = hiding = (modifiers & 0x20000000) != 0;
        assert (!complete || !hiding);
        boolean bl2 = negative = (modifiers & 0x10000000) != 0;
        assert (!negative || !complete && !hiding);
        modifiers &= Integer.MAX_VALUE;
        String name = isMethod ? RuntimeMetadataDecoderImpl.decodeMemberName(buf) : null;
        Object[] parameterTypes = complete || hiding || negative ? RuntimeMetadataDecoderImpl.decodeArray(buf, Class.class, i -> RuntimeMetadataDecoderImpl.decodeType(buf)) : RuntimeMetadataDecoderImpl.decodeArray(buf, String.class, i -> RuntimeMetadataDecoderImpl.decodeOtherString(buf));
        Class<?> clazz = returnType = isMethod && (complete || hiding) ? RuntimeMetadataDecoderImpl.decodeType(buf) : null;
        if (!complete) {
            if (reflectOnly != (hiding || negative)) {
                return null;
            }
            if (isMethod) {
                if (!reflectOnly) {
                    return new RuntimeMetadataDecoder.MethodDescriptor(declaringClass, name, (String[])parameterTypes);
                }
                return ReflectionObjectFactory.newMethod(conditions, declaringClass, name, (Class[])parameterTypes, negative ? Object.class : returnType, null, modifiers, null, null, null, null, null, null, null);
            }
            if (!reflectOnly) {
                return new RuntimeMetadataDecoder.ConstructorDescriptor(declaringClass, (String[])parameterTypes);
            }
            return ReflectionObjectFactory.newConstructor(conditions, declaringClass, (Class[])parameterTypes, null, modifiers, null, null, null, null, null, null);
        }
        Class[] exceptionTypes = RuntimeMetadataDecoderImpl.decodeArray(buf, Class.class, i -> RuntimeMetadataDecoderImpl.decodeType(buf));
        String signature = RuntimeMetadataDecoderImpl.decodeOtherString(buf);
        byte[] annotations = RuntimeMetadataDecoderImpl.decodeByteArray(buf);
        byte[] parameterAnnotations = RuntimeMetadataDecoderImpl.decodeByteArray(buf);
        byte[] annotationDefault = isMethod && declaringClass.isAnnotation() ? RuntimeMetadataDecoderImpl.decodeByteArray(buf) : null;
        byte[] typeAnnotations = RuntimeMetadataDecoderImpl.decodeByteArray(buf);
        byte[] reflectParameters = RuntimeMetadataDecoderImpl.decodeByteArray(buf);
        Object accessor = RuntimeMetadataDecoderImpl.decodeObject(buf);
        if (publicOnly && !Modifier.isPublic(modifiers)) {
            modifiers |= 0x10000000;
        }
        if (isMethod) {
            Method method = ReflectionObjectFactory.newMethod(conditions, declaringClass, name, (Class[])parameterTypes, returnType, exceptionTypes, modifiers, signature, annotations, parameterAnnotations, annotationDefault, accessor, reflectParameters, typeAnnotations);
            if (!reflectOnly) {
                return new RuntimeMetadataDecoder.MethodDescriptor(method);
            }
            executable = SubstrateUtil.cast(method, Target_java_lang_reflect_Executable.class);
        } else {
            Constructor<?> constructor = ReflectionObjectFactory.newConstructor(conditions, declaringClass, (Class[])parameterTypes, exceptionTypes, modifiers, signature, annotations, parameterAnnotations, accessor, reflectParameters, typeAnnotations);
            if (!reflectOnly) {
                return new RuntimeMetadataDecoder.ConstructorDescriptor(constructor);
            }
            executable = SubstrateUtil.cast(constructor, Target_java_lang_reflect_Executable.class);
        }
        return SubstrateUtil.cast(executable, Executable.class);
    }

    private static RecordComponent decodeRecordComponent(UnsafeArrayTypeReader buf, Class<?> declaringClass) {
        String name = RuntimeMetadataDecoderImpl.decodeMemberName(buf);
        Class<?> type = RuntimeMetadataDecoderImpl.decodeType(buf);
        String signature = RuntimeMetadataDecoderImpl.decodeOtherString(buf);
        byte[] annotations = RuntimeMetadataDecoderImpl.decodeByteArray(buf);
        byte[] typeAnnotations = RuntimeMetadataDecoderImpl.decodeByteArray(buf);
        return ReflectionObjectFactory.newRecordComponent(declaringClass, name, type, signature, annotations, typeAnnotations);
    }

    private static Parameter decodeReflectParameter(UnsafeArrayTypeReader buf, Executable executable, int i) {
        String name = RuntimeMetadataDecoderImpl.decodeOtherString(buf);
        int modifiers = buf.getUVInt();
        return ReflectionObjectFactory.newParameter(executable, i, name, modifiers);
    }

    private static Class<?> decodeType(UnsafeArrayTypeReader buf) {
        int classIndex = buf.getSVInt();
        if (classIndex == -1) {
            return null;
        }
        return RuntimeMetadataDecoder.MetadataAccessor.singleton().getClass(classIndex);
    }

    private static String decodeMemberName(UnsafeArrayTypeReader buf) {
        int nameIndex = buf.getSVInt();
        String name = RuntimeMetadataDecoder.MetadataAccessor.singleton().getMemberName(nameIndex);
        return name == null ? null : name.intern();
    }

    private static String decodeOtherString(UnsafeArrayTypeReader buf) {
        int nameIndex = buf.getSVInt();
        String name = RuntimeMetadataDecoder.MetadataAccessor.singleton().getOtherString(nameIndex);
        return name == null ? null : name.intern();
    }

    private static Object decodeObject(UnsafeArrayTypeReader buf) {
        int objectIndex = buf.getSVInt();
        if (objectIndex == -1) {
            return null;
        }
        return RuntimeMetadataDecoder.MetadataAccessor.singleton().getObject(objectIndex);
    }

    private static <T> T[] decodeArray(UnsafeArrayTypeReader buf, Class<T> elementType, Function<Integer, T> elementDecoder) {
        int length = buf.getSVInt();
        if (RuntimeMetadataDecoderImpl.isErrorIndex(length)) {
            RuntimeMetadataDecoderImpl.decodeAndThrowError(length);
        }
        Object[] result = (Object[])Array.newInstance(elementType, length);
        int valueCount = 0;
        for (int i = 0; i < length; ++i) {
            T element = elementDecoder.apply(i);
            if (element == null) continue;
            result[valueCount++] = element;
        }
        return Arrays.copyOf(result, valueCount);
    }

    private static byte[] decodeByteArray(UnsafeArrayTypeReader buf) {
        int length = buf.getUVInt();
        if (length == -1) {
            return null;
        }
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)buf.getS1();
        }
        return result;
    }

    @AutomaticallyRegisteredImageSingleton(value={RuntimeMetadataDecoder.MetadataAccessor.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    public static class MetadataAccessorImpl
    implements RuntimeMetadataDecoder.MetadataAccessor {
        @Override
        public <T> T getObject(int index) {
            CodeInfo info = MetadataAccessorImpl.getCodeInfo();
            return (T)NonmovableArrays.getObject(CodeInfoAccess.getObjectConstants(info), index);
        }

        @Override
        public Class<?> getClass(int index) {
            CodeInfo info = MetadataAccessorImpl.getCodeInfo();
            return NonmovableArrays.getObject(CodeInfoAccess.getClasses(info), index);
        }

        @Override
        public String getMemberName(int index) {
            CodeInfo info = MetadataAccessorImpl.getCodeInfo();
            return NonmovableArrays.getObject(CodeInfoAccess.getMemberNames(info), index);
        }

        @Override
        public String getOtherString(int index) {
            CodeInfo info = MetadataAccessorImpl.getCodeInfo();
            return NonmovableArrays.getObject(CodeInfoAccess.getOtherStrings(info), index);
        }

        private static CodeInfo getCodeInfo() {
            return CodeInfoTable.getFirstImageCodeInfo();
        }
    }
}

